/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.rules;

import io.confluent.security.policyapi.ast.BaseVisitor;
import io.confluent.security.policyapi.ast.EqualsNode;
import io.confluent.security.policyapi.ast.FunctionCallNode;
import io.confluent.security.policyapi.ast.ListNode;
import io.confluent.security.policyapi.ast.LogicalAndNode;
import io.confluent.security.policyapi.ast.LogicalNotNode;
import io.confluent.security.policyapi.ast.LogicalOrNode;
import io.confluent.security.policyapi.ast.ParameterNode;
import io.confluent.security.policyapi.ast.StringLiteralNode;
import io.confluent.security.policyapi.ast.VariableNode;
import io.confluent.security.policyapi.exception.LinkerException;
import io.confluent.security.policyapi.rules.Rule;
import io.confluent.security.policyapi.rules.RuleEquals;
import io.confluent.security.policyapi.rules.RuleFunctionArrayClaimContains;
import io.confluent.security.policyapi.rules.RuleFunctionClaimInArray;
import io.confluent.security.policyapi.rules.RuleFunctionEndsWith;
import io.confluent.security.policyapi.rules.RuleFunctionHas;
import io.confluent.security.policyapi.rules.RuleFunctionStartsWith;
import io.confluent.security.policyapi.rules.RuleLogicalAnd;
import io.confluent.security.policyapi.rules.RuleLogicalNot;
import io.confluent.security.policyapi.rules.RuleLogicalOr;

final class RuleVisitor
extends BaseVisitor<Rule> {
    RuleVisitor() {
    }

    private static String getVariableName(FunctionCallNode node, int parameterIndex) {
        return ((VariableNode)node.getParameters().getList().get(parameterIndex)).getVariableName();
    }

    private static String getStringLiteral(FunctionCallNode node, int parameterIndex) {
        return ((StringLiteralNode)node.getParameters().getList().get(parameterIndex)).getValue();
    }

    @Override
    public Rule visitLogicalAndNode(LogicalAndNode node) {
        return new RuleLogicalAnd((Rule)super.visit(node.getLeft()), (Rule)super.visit(node.getRight()));
    }

    @Override
    public Rule visitLogicalNotNode(LogicalNotNode node) {
        return new RuleLogicalNot((Rule)super.visit(node.getNext()));
    }

    @Override
    public Rule visitLogicalOrNode(LogicalOrNode node) {
        return new RuleLogicalOr((Rule)super.visit(node.getLeft()), (Rule)super.visit(node.getRight()));
    }

    @Override
    public Rule visitEqualsNode(EqualsNode node) {
        return new RuleEquals(node.getVariable().getVariableName(), node.getStringLiteral().getValue());
    }

    @Override
    public Rule visitFunctionCallNode(FunctionCallNode node) {
        String functionName;
        switch (functionName = node.getFunctionName()) {
            case "in": {
                if (this.tryParameterTypes(node, VariableNode.class, ListNode.class)) {
                    return new RuleFunctionClaimInArray(RuleVisitor.getVariableName(node, 0), (ListNode)node.getParameters().getList().get(1));
                }
                if (this.tryParameterTypes(node, StringLiteralNode.class, VariableNode.class)) {
                    return new RuleFunctionArrayClaimContains(RuleVisitor.getVariableName(node, 1), RuleVisitor.getStringLiteral(node, 0));
                }
                throw new LinkerException(node);
            }
            case "has": {
                this.checkParameterTypes(node, VariableNode.class);
                return new RuleFunctionHas(RuleVisitor.getVariableName(node, 0));
            }
            case "startswith": {
                this.checkParameterTypes(node, VariableNode.class, StringLiteralNode.class);
                return new RuleFunctionStartsWith(RuleVisitor.getVariableName(node, 0), RuleVisitor.getStringLiteral(node, 1));
            }
            case "endswith": {
                this.checkParameterTypes(node, VariableNode.class, StringLiteralNode.class);
                return new RuleFunctionEndsWith(RuleVisitor.getVariableName(node, 0), RuleVisitor.getStringLiteral(node, 1));
            }
        }
        throw new LinkerException(node);
    }

    @SafeVarargs
    private final void checkParameterTypes(FunctionCallNode node, Class<? extends ParameterNode> ... classes) {
        if (!this.tryParameterTypes(node, classes)) {
            throw new LinkerException(node);
        }
    }

    @SafeVarargs
    private final boolean tryParameterTypes(FunctionCallNode node, Class<? extends ParameterNode> ... classes) {
        ListNode<ParameterNode> parameters = node.getParameters();
        if (parameters.getList().size() != classes.length) {
            return false;
        }
        for (int i = 0; i < parameters.getList().size(); ++i) {
            Class<? extends ParameterNode> clazz = classes[i];
            ParameterNode parameter = parameters.getList().get(i);
            if (clazz.isInstance(parameter)) continue;
            return false;
        }
        return true;
    }
}

