/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.trustservice.store.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.policyapi.TrustPolicy;
import java.util.Objects;

public class IdentityPool {
    private final String poolId;
    private final String issuer;
    private final String subjectClaim;
    private final String serviceAccount;
    private final TrustPolicy policy;

    public IdentityPool(@JsonProperty(value="poolId") String poolId, @JsonProperty(value="version") long version, @JsonProperty(value="issuer") String issuer, @JsonProperty(value="subjectClaim") String subjectClaim, @JsonProperty(value="serviceAccount") String serviceAccount, @JsonProperty(value="policy") String policy) {
        this.poolId = poolId;
        this.issuer = issuer;
        this.subjectClaim = subjectClaim == null ? "sub" : subjectClaim;
        this.serviceAccount = serviceAccount;
        this.policy = new TrustPolicy(poolId, version, policy);
    }

    @JsonProperty(value="poolId")
    public String poolId() {
        return this.poolId;
    }

    @JsonProperty(value="version")
    public long version() {
        return this.policy.version();
    }

    @JsonProperty(value="issuer")
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty(value="subjectClaim")
    public String subjectClaim() {
        return this.subjectClaim;
    }

    @JsonProperty(value="serviceAccount")
    public String serviceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="policy")
    public TrustPolicy policy() {
        return this.policy;
    }

    public int hashCode() {
        return Objects.hash(this.poolId, this.policy.version());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityPool)) {
            return false;
        }
        IdentityPool that = (IdentityPool)o;
        return Objects.equals(this.poolId, that.poolId) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.subjectClaim, that.subjectClaim) && Objects.equals(this.serviceAccount, that.serviceAccount) && Objects.equals(this.policy, that.policy);
    }
}

