/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public final class IssuerExtractor {
    private IssuerExtractor() {
    }

    public static String getIssuer(String encodedJwt) throws InvalidJwtException, MalformedClaimException {
        return BaseJwtConsumer.INSTANCE.processToClaims(encodedJwt).getIssuer();
    }

    private static class BaseJwtConsumer {
        private static final JwtConsumer INSTANCE = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();

        private BaseJwtConsumer() {
        }
    }
}

