/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.IssuerExtractor;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.authentication.oauthbearer.JwtPrincipal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;

public final class JwtAuthenticator
implements Authenticator<BearerCredential, JwtPrincipal> {
    private final Map<String, JwtConsumer> jwtConsumers = new ConcurrentHashMap<String, JwtConsumer>();

    public JwtAuthenticator(List<JwtIssuer> issuers, Collection<Constraint> constraints) {
        for (JwtIssuer issuer : issuers) {
            this.jwtConsumers.put(issuer.name(), issuer.createConsumer(constraints));
        }
    }

    @Override
    public JwtPrincipal authenticate(BearerCredential credential) {
        try {
            String issuerName = IssuerExtractor.getIssuer(credential.bearerToken());
            if (issuerName == null) {
                throw new IllegalArgumentException("Bearer token missing required issuer claim");
            }
            JwtConsumer jwtConsumer = this.jwtConsumers.getOrDefault(issuerName, this.jwtConsumers.get("*"));
            if (jwtConsumer == null) {
                throw new AuthenticationException("Unrecognized issuer " + issuerName);
            }
            JwtClaims claims = jwtConsumer.processToClaims(credential.bearerToken());
            return new JwtPrincipal(claims);
        }
        catch (Throwable t) {
            throw new AuthenticationException("Failed to authenticate bearer credentials", t);
        }
    }
}

