/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.keys.EcKeyUtil;
import org.jose4j.keys.RsaKeyUtil;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;

@JsonDeserialize(builder=Builder.class)
public final class JwtIssuerStatic
extends JwtIssuer {
    private final String name;
    private final Set<String> audience;
    private final JsonWebKeySet jwks;

    private JwtIssuerStatic(String name, Set<String> audience, JsonWebKeySet jwks) {
        this.name = name;
        this.audience = Collections.unmodifiableSet(audience);
        this.jwks = jwks;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="audience")
    public Set<String> audience() {
        return this.audience;
    }

    @JsonIgnore
    JsonWebKeySet jwks() {
        return this.jwks;
    }

    @Override
    public ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> constraints) {
        JwksVerificationKeyResolver keyResolver = new JwksVerificationKeyResolver(this.jwks.getJsonWebKeys());
        return new ConstrainedVerificationKeyResolver((VerificationKeyResolver)keyResolver, constraints);
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String name;
        private Set<String> audience;
        private List<String> pems;

        private Builder() {
        }

        @JsonSetter(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(value="audience", nulls=Nulls.AS_EMPTY)
        public Builder audience(Set<String> audience) {
            this.audience = audience;
            return this;
        }

        @JsonSetter(value="pems", nulls=Nulls.AS_EMPTY)
        public Builder pems(List<String> pems) {
            this.pems = pems;
            return this;
        }

        public JwtIssuerStatic build() throws JoseException, InvalidKeySpecException {
            return new JwtIssuerStatic(this.name, this.audience == null ? Collections.emptySet() : this.audience, this.jwks(this.pems));
        }

        private JsonWebKeySet jwks(List<String> pems) throws JoseException, InvalidKeySpecException {
            JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[0]);
            RsaKeyUtil rsaKeyUtil = new RsaKeyUtil();
            EcKeyUtil ecKeyUtil = new EcKeyUtil();
            for (String pem : pems) {
                try {
                    PublicKey publicKey = rsaKeyUtil.fromPemEncoded(pem);
                    jwks.addJsonWebKey((JsonWebKey)new RsaJsonWebKey((RSAPublicKey)publicKey));
                }
                catch (InvalidKeySpecException e) {
                    PublicKey publicKey = ecKeyUtil.fromPemEncoded(pem);
                    jwks.addJsonWebKey((JsonWebKey)new EllipticCurveJsonWebKey((ECPublicKey)publicKey));
                }
            }
            return jwks;
        }
    }
}

