/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authentication.oidc.GrantBase;
import io.confluent.security.authentication.oidc.TokenRequest;
import java.util.Set;

public class ClientCredentialsGrant
extends GrantBase {
    public ClientCredentialsGrant(Set<String> scopes) {
        this.setTokenRequest(new ClientCredentialsRequest(scopes));
    }

    public ClientCredentialsGrant(String scopesString) {
        this.setTokenRequest(new ClientCredentialsRequest(scopesString));
    }

    @Override
    public GrantBase.GrantType getGrantType() {
        return GrantBase.GrantType.CLIENT_CREDENTIALS;
    }

    private static class ClientCredentialsRequest
    implements TokenRequest {
        private final String scopes;

        @Override
        @JsonProperty(value="grant_type")
        public GrantBase.GrantType grantType() {
            return GrantBase.GrantType.CLIENT_CREDENTIALS;
        }

        @JsonProperty(value="scope")
        public String scope() {
            return this.scopes;
        }

        private ClientCredentialsRequest(Set<String> scopesSet) {
            StringBuilder scopeStringBuilder = new StringBuilder();
            for (String scope : scopesSet) {
                if (scopeStringBuilder.length() > 0) {
                    scopeStringBuilder.append(" ");
                }
                scopeStringBuilder.append(scope);
            }
            this.scopes = scopeStringBuilder.toString();
        }

        private ClientCredentialsRequest(String scopesString) {
            this.scopes = scopesString;
        }
    }
}

