/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast;

import io.confluent.security.policyapi.PolicyRuleLexer;
import io.confluent.security.policyapi.PolicyRuleParser;
import io.confluent.security.policyapi.ast.AbstractSyntaxTreeNode;
import io.confluent.security.policyapi.ast.AstVisitor;
import io.confluent.security.policyapi.ast.checker.ArrayLimitVisitor;
import io.confluent.security.policyapi.ast.checker.ChainLevelVisitor;
import io.confluent.security.policyapi.ast.checker.NestLevelVisitor;
import io.confluent.security.policyapi.ast.checker.ParameterListLimitVisitor;
import io.confluent.security.policyapi.exception.LexerException;
import io.confluent.security.policyapi.exception.RuleBuilderException;
import io.confluent.security.policyapi.exception.SyntaxException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public final class AstBuilder {
    private final int arrayListLimit;
    private final int chainLimit;
    private final int parameterListLimit;
    private final int nestingLimit;

    AstBuilder(int arrayListLimit, int chainLimit, int parameterListLimit, int nestingLimit) {
        this.arrayListLimit = arrayListLimit;
        this.chainLimit = chainLimit;
        this.parameterListLimit = parameterListLimit;
        this.nestingLimit = nestingLimit;
    }

    private PolicyRuleParser.ProgramContext parseExpression(final String expr) throws RuleBuilderException {
        CodePointCharStream stream = CharStreams.fromString((String)expr);
        PolicyRuleLexer lexer = new PolicyRuleLexer((CharStream)stream);
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new LexerException(AstBuilder.getParseErrorMessage(expr, line, charPositionInLine, msg), (Throwable)e);
            }
        });
        PolicyRuleParser parser = new PolicyRuleParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new SyntaxException(AstBuilder.getParseErrorMessage(expr, line, charPositionInLine, msg), (Throwable)e);
            }
        });
        return parser.program();
    }

    private static String getParseErrorMessage(String expr, int line, int charInLine, String msg) {
        return "Failed to parse '" + expr + "' at line " + line + ", position " + charInLine + " due to " + msg;
    }

    public AbstractSyntaxTreeNode build(String expression) throws RuleBuilderException {
        PolicyRuleParser.ProgramContext programContext = this.parseExpression(expression);
        AbstractSyntaxTreeNode ast = (AbstractSyntaxTreeNode)new AstVisitor().visit((ParseTree)programContext);
        new ArrayLimitVisitor(this.arrayListLimit).visit((ParseTree)programContext);
        new ChainLevelVisitor(this.chainLimit).visit((ParseTree)programContext);
        new ParameterListLimitVisitor(this.parameterListLimit).visit((ParseTree)programContext);
        new NestLevelVisitor(this.nestingLimit).visit(ast);
        return ast;
    }
}

