/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast;

import io.confluent.security.policyapi.PolicyRuleBaseVisitor;
import io.confluent.security.policyapi.PolicyRuleParser;
import io.confluent.security.policyapi.ast.AbstractSyntaxTreeNode;
import io.confluent.security.policyapi.ast.EqualsNode;
import io.confluent.security.policyapi.ast.ExpressionNode;
import io.confluent.security.policyapi.ast.FunctionCallNode;
import io.confluent.security.policyapi.ast.ListNode;
import io.confluent.security.policyapi.ast.LogicalAndNode;
import io.confluent.security.policyapi.ast.LogicalNotNode;
import io.confluent.security.policyapi.ast.LogicalOrNode;
import io.confluent.security.policyapi.ast.ParameterNode;
import io.confluent.security.policyapi.ast.StringLiteralNode;
import io.confluent.security.policyapi.ast.VariableNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

final class AstVisitor
extends PolicyRuleBaseVisitor<AbstractSyntaxTreeNode> {
    AstVisitor() {
    }

    private static String extractStringLiteral(String literal) {
        assert (literal != null);
        assert (literal.startsWith("\""));
        assert (literal.endsWith("\""));
        return literal.substring(1, literal.length() - 1).replace("\"\"", "\"");
    }

    private static VariableNode buildVariableNode(TerminalNode node) {
        return new VariableNode(node.getText());
    }

    private static StringLiteralNode buildStringLiteralNode(TerminalNode node) {
        return new StringLiteralNode(AstVisitor.extractStringLiteral(node.getText()));
    }

    @Override
    public AbstractSyntaxTreeNode visitProgram(PolicyRuleParser.ProgramContext ctx) {
        return new ExpressionNode((AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression()));
    }

    @Override
    public AbstractSyntaxTreeNode visitExpressionNestedExpr(PolicyRuleParser.ExpressionNestedExprContext ctx) {
        return new ExpressionNode((AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression()));
    }

    @Override
    public AbstractSyntaxTreeNode visitExpressionLogicalNotExpr(PolicyRuleParser.ExpressionLogicalNotExprContext ctx) {
        return new LogicalNotNode((AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression()));
    }

    @Override
    public AbstractSyntaxTreeNode visitExpressionLogicalAndExpr(PolicyRuleParser.ExpressionLogicalAndExprContext ctx) {
        assert (ctx.expression().size() == 2);
        return new LogicalAndNode((AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression(0)), (AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression(1)));
    }

    @Override
    public AbstractSyntaxTreeNode visitExpressionLogicalOrExpr(PolicyRuleParser.ExpressionLogicalOrExprContext ctx) {
        assert (ctx.expression().size() == 2);
        return new LogicalOrNode((AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression(0)), (AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.expression(1)));
    }

    @Override
    public AbstractSyntaxTreeNode visitExpressionFunctionCallExpr(PolicyRuleParser.ExpressionFunctionCallExprContext ctx) {
        ListNode parameterListNode = (ListNode)super.visit((ParseTree)ctx.parameterList());
        return new FunctionCallNode(ctx.Identifier().getText(), parameterListNode);
    }

    @Override
    public AbstractSyntaxTreeNode visitOperatorNotEqualsExpr(PolicyRuleParser.OperatorNotEqualsExprContext ctx) {
        return new LogicalNotNode(new EqualsNode(AstVisitor.buildVariableNode(ctx.Variable()), AstVisitor.buildStringLiteralNode(ctx.StringLiteral())));
    }

    @Override
    public AbstractSyntaxTreeNode visitOperatorEqualsExpr(PolicyRuleParser.OperatorEqualsExprContext ctx) {
        return new EqualsNode(AstVisitor.buildVariableNode(ctx.Variable()), AstVisitor.buildStringLiteralNode(ctx.StringLiteral()));
    }

    @Override
    public AbstractSyntaxTreeNode visitParameterList(PolicyRuleParser.ParameterListContext ctx) {
        ListNode<ParameterNode> node = new ListNode<ParameterNode>();
        for (PolicyRuleParser.ParameterContext paramCtx : ctx.parameter()) {
            node.addNode((ParameterNode)super.visit((ParseTree)paramCtx));
        }
        return node;
    }

    @Override
    public AbstractSyntaxTreeNode visitParameterStringArrayExpr(PolicyRuleParser.ParameterStringArrayExprContext ctx) {
        return (AbstractSyntaxTreeNode)super.visit((ParseTree)ctx.stringArray());
    }

    @Override
    public AbstractSyntaxTreeNode visitParameterStringLiteralExpr(PolicyRuleParser.ParameterStringLiteralExprContext ctx) {
        return AstVisitor.buildStringLiteralNode(ctx.StringLiteral());
    }

    @Override
    public AbstractSyntaxTreeNode visitParameterVariableExpr(PolicyRuleParser.ParameterVariableExprContext ctx) {
        return AstVisitor.buildVariableNode(ctx.Variable());
    }

    @Override
    public AbstractSyntaxTreeNode visitStringArray(PolicyRuleParser.StringArrayContext ctx) {
        ListNode<StringLiteralNode> list = new ListNode<StringLiteralNode>();
        for (TerminalNode node : ctx.StringLiteral()) {
            list.addNode(AstVisitor.buildStringLiteralNode(node));
        }
        return list;
    }
}

