/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast;

import io.confluent.security.policyapi.ast.AbstractSyntaxTreeNode;
import io.confluent.security.policyapi.ast.BaseNode;
import io.confluent.security.policyapi.ast.ParameterNode;
import io.confluent.security.policyapi.ast.Visitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class ListNode<T>
extends BaseNode
implements ParameterNode {
    private final List<T> list = new ArrayList<T>();

    public void addNode(T node) {
        assert (node instanceof AbstractSyntaxTreeNode);
        this.list.add(node);
    }

    public List<T> getList() {
        return this.list;
    }

    public <V> V accept(Visitor<V> visitor) {
        return visitor.visitListNode(this);
    }

    @Override
    public List<AbstractSyntaxTreeNode> getChildren() {
        return this.list.stream().map(t -> (AbstractSyntaxTreeNode)t).collect(Collectors.toList());
    }
}

