/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast.checker;

import io.confluent.security.policyapi.ast.BaseVisitor;
import io.confluent.security.policyapi.ast.ExpressionNode;
import io.confluent.security.policyapi.exception.RuleBuilderException;

public final class NestLevelVisitor
extends BaseVisitor<Void> {
    private int currentNestLevel = 0;
    private final int limit;

    public NestLevelVisitor(int limit) {
        this.limit = limit;
    }

    @Override
    public Void visitExpressionNode(ExpressionNode node) {
        if (this.currentNestLevel++ > this.limit) {
            throw new RuleBuilderException("Illegal nesting level");
        }
        super.visitExpressionNode(node);
        --this.currentNestLevel;
        return null;
    }
}

