/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication;

import io.confluent.security.authentication.AuthenticationErrorInfo;
import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.Claims;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticator;
import io.confluent.security.policyapi.engine.PolicyEngine;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import io.confluent.security.trustservice.store.data.IdentityProvider;
import io.confluent.security.util.SecurityContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdmissionController {
    private static final Logger log = LoggerFactory.getLogger(AdmissionController.class);
    public static final String OAUTH_AUTHORIZED_PARTY = "azp";
    public static final String OAUTH_POOL_DELIMITER = ",";
    public static final String OAUTH_UNION_OF_POOLS_AUDIT_IDENTITY = "OAuth-ClientCredentials";
    static final String OAUTH_IDENTITY_POOL_PROPERTY_KEY = "identityPoolId";
    private final Authenticator<?, ?> authenticator;
    private final Supplier<TrustCache> trustCacheSupplier;
    private final PolicyEngine<String> policyEngine;

    public AdmissionController(Authenticator<?, ?> authenticator, Supplier<TrustCache> trustCacheSupplier, PolicyEngine<String> policyEngine) {
        this.authenticator = authenticator;
        this.trustCacheSupplier = trustCacheSupplier;
        this.policyEngine = policyEngine;
    }

    public Claims authenticate(BearerCredential credential, SecurityContext context) throws AuthenticationException {
        if (this.authenticator instanceof JwtAuthenticator) {
            JwtAuthenticator auth = (JwtAuthenticator)this.authenticator;
            return auth.authenticate(credential, context);
        }
        throw new AuthenticationException("Unable to process credential", "INCORRECT_AUTHENTICATOR_TYPE");
    }

    public Claims authenticate(BearerCredential credential) throws AuthenticationException {
        if (this.authenticator instanceof JwtAuthenticator) {
            return ((JwtAuthenticator)this.authenticator).authenticate(credential);
        }
        throw new AuthenticationException("Unable to process credential", "INCORRECT_AUTHENTICATOR_TYPE");
    }

    public Map<String, Object> assumePrincipal(Map<String, Object> claims, String poolId, String orgId) throws AuthenticationException, IllegalArgumentException {
        IdentityPool identityPool = this.trustCacheSupplier.get().identityPool(poolId);
        HashMap<String, Object> identityPoolClaims = new HashMap<String, Object>();
        if (identityPool == null) {
            throw this.getAuthExWithClaimsInfo(String.format("Unknown Identity Pool %s.", poolId), "IDENTITY_POOL_NOT_FOUND", claims);
        }
        if (!AdmissionController.validateIssuer(claims, identityPool.issuer())) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided claim issuer %s do not match Identity Pool %s Pool Filter issuer %s.", AdmissionController.claimValue(claims, "iss", String.class), poolId, identityPool.issuer()), "CLAIM_ISSUER_POOL_FILTER_MISMATCH", claims);
        }
        if (!this.policyEngine.evaluatePolicy(identityPool.policy(), claims)) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided claims do not match Identity Pool %s Pool Filter.", poolId), "CLAIMS_POOL_FILTER_MISMATCH", claims);
        }
        if (!orgId.equals(identityPool.orgId())) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided orgId %s do not match Identity Pool orgId %s Pool Filter.", orgId, identityPool.orgId()), "ORG_ID_POOL_FILTER_MISMATCH", claims);
        }
        if (!claims.containsKey(identityPool.subjectClaim())) {
            throw this.getAuthExWithClaimsInfo(String.format("Provided token does not contain claim %s in Identity Pool.", identityPool.subjectClaim()), "IDENTITY_POOL_IDENTITY_CLAIM_ABSENT_IN_CLAIMS", claims);
        }
        identityPoolClaims.put(OAUTH_AUTHORIZED_PARTY, claims.get(identityPool.subjectClaim()));
        claims.put(OAUTH_AUTHORIZED_PARTY, claims.get(identityPool.subjectClaim()));
        identityPoolClaims.put("sub", identityPool.serviceAccount());
        claims.put("sub", identityPool.serviceAccount());
        return identityPoolClaims;
    }

    public Map<String, Object> assumePrincipal(Map<String, Object> claims, String providerId, String poolId, String orgId) throws AuthenticationException, IllegalArgumentException {
        HashMap<String, Object> identityPoolClaims = new HashMap<String, Object>();
        ArrayList<String> validatedPools = new ArrayList<String>();
        IdentityProvider provider = this.trustCacheSupplier.get().identityProvider(providerId);
        if (provider == null) {
            throw this.getAuthExWithClaimsInfo(String.format("No valid identity provider found for id %s.", providerId), "NO_VALID_IDENTITY_PROVIDER_FOUND", claims);
        }
        List<IdentityPool> potentialPools = this.getPotentialPools(providerId, poolId);
        if (potentialPools.isEmpty()) {
            throw this.getAuthExWithClaimsInfo(String.format("No valid identity pools found for provider %s.", providerId), "NO_VALID_IDENTITY_POOLS_FOUND", claims);
        }
        for (IdentityPool pool : potentialPools) {
            if (!claims.containsKey(provider.subjectClaim())) {
                log.debug("Union of pools assumePrincipal - Provided token does not contain claim {} in Identity Provider.", (Object)provider.subjectClaim());
                continue;
            }
            if (!orgId.equals(pool.orgId())) {
                log.debug("Union of pools assumePrincipal - Provided orgId {} do not match Identity Pool orgId {} Pool Filter.", (Object)orgId, (Object)pool.orgId());
                continue;
            }
            if (!AdmissionController.validateIssuer(claims, pool.issuer())) {
                log.debug("Union of pools assumePrincipal - Provided claim issuer {} do not match Identity Pool {} Pool Filter issuer {}.", new Object[]{AdmissionController.claimValue(claims, "iss", String.class), poolId, pool.issuer()});
                continue;
            }
            if (!this.policyEngine.evaluatePolicy(pool.policy(), claims)) {
                log.debug("Union of pools assumePrincipal - Provided claims do not match Identity Pool {} Pool Filter.", (Object)poolId);
                continue;
            }
            validatedPools.add(pool.poolId());
        }
        if (validatedPools.isEmpty()) {
            throw this.getAuthExWithClaimsInfo(String.format("No identity pools successfully validated for provider %s.", providerId), "NO_VALID_IDENTITY_POOLS_FOUND", claims);
        }
        identityPoolClaims.put(OAUTH_AUTHORIZED_PARTY, claims.get(provider.subjectClaim()));
        claims.put(OAUTH_AUTHORIZED_PARTY, claims.get(provider.subjectClaim()));
        identityPoolClaims.put("sub", OAUTH_UNION_OF_POOLS_AUDIT_IDENTITY);
        claims.put("sub", OAUTH_UNION_OF_POOLS_AUDIT_IDENTITY);
        String pools = String.join((CharSequence)OAUTH_POOL_DELIMITER, validatedPools);
        identityPoolClaims.put(OAUTH_IDENTITY_POOL_PROPERTY_KEY, pools);
        claims.put(OAUTH_IDENTITY_POOL_PROPERTY_KEY, pools);
        return identityPoolClaims;
    }

    private List<IdentityPool> getPotentialPools(String providerId, String poolId) {
        ArrayList poolIds;
        ArrayList<IdentityPool> potentialPools = new ArrayList<IdentityPool>();
        List<Object> list = poolIds = poolId == null || poolId.isBlank() ? new ArrayList() : Arrays.asList(poolId.split(OAUTH_POOL_DELIMITER));
        if (!poolIds.isEmpty()) {
            for (String poolIdStr : poolIds) {
                IdentityPool pool = this.trustCacheSupplier.get().identityPool(poolIdStr.trim());
                if (pool == null || !pool.providerId().equals(providerId)) continue;
                potentialPools.add(pool);
            }
        } else {
            potentialPools.addAll(this.trustCacheSupplier.get().findIdentityPools(providerId));
        }
        return potentialPools;
    }

    private static boolean validateIssuer(Map<String, Object> claims, String issuer) {
        return issuer.equals(AdmissionController.claimValue(claims, "iss", String.class));
    }

    private static <T> T claimValue(Map<String, Object> claims, String claim, Class<T> valueType) {
        try {
            return valueType.cast(claims.get(claim));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to read claim - " + claim, t);
        }
    }

    private AuthenticationException getAuthExWithClaimsInfo(String msg, String code, Map<String, Object> claims) {
        AuthenticationException exe = new AuthenticationException(msg, code);
        AuthenticationErrorInfo.JwtClaimsInfo errInfo = new AuthenticationErrorInfo.JwtClaimsInfo();
        errInfo.claims(claims);
        exe.errorInfo((AuthenticationErrorInfo)errInfo);
        return exe;
    }
}

