/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.KeyConstraintException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.jose4j.jws.JsonWebSignature;

final class JkuDomainWhitelist
implements Constraint {
    private final List<String> domainWhitelist;

    public JkuDomainWhitelist(List<String> domainWhitelist) {
        this.domainWhitelist = domainWhitelist;
    }

    @Override
    public void validate(JsonWebSignature jws) throws KeyConstraintException {
        String jku = jws.getHeaders().getStringHeaderValue("jku");
        if (!this.hasValidJkuDomain(jku)) {
            throw new KeyConstraintException("Invalid jku: " + jku);
        }
    }

    public boolean hasValidJkuDomain(String jku) {
        try {
            URL url = new URL(jku);
            if (!url.getProtocol().equalsIgnoreCase("https")) {
                return false;
            }
            String host = url.getHost().toLowerCase(Locale.US);
            for (String domain : this.domainWhitelist) {
                if (domain.startsWith(".") && host.endsWith(domain)) {
                    return true;
                }
                if (!host.equals(domain)) continue;
                return true;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        return false;
    }
}

