/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.authentication.oauthbearer.JwtIssuerSpireConfigurator;
import io.confluent.security.authentication.oauthbearer.SpireVerificationKeyResolver;
import io.confluent.security.util.SecurityContext;
import io.spiffe.exception.JwtSourceException;
import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.workloadapi.DefaultJwtSource;
import io.spiffe.workloadapi.JwtSource;
import io.spiffe.workloadapi.JwtSourceOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public class JwtIssuerSpire
extends JwtIssuer
implements JwtIssuerSpireConfigurator {
    private static final Logger log = LoggerFactory.getLogger(JwtIssuerSpire.class);
    private final String name;
    private String spireAgentSocketEndpoint;
    private final Set<String> audience;
    private JwtSourceOptions jwtSourceOptions;
    private final String spireIssuerSuffix;
    private JwtSource jwtSource;

    public JwtIssuerSpire(String name, Set<String> audience, String spireIssuerSuffix) {
        this.name = name;
        this.audience = audience;
        this.spireIssuerSuffix = spireIssuerSuffix;
    }

    @Override
    public void configureJwtSource(String spireAgentSocketEndpoint) {
        Objects.requireNonNull(spireAgentSocketEndpoint, "spireAgentSocketEndpoint must be non null");
        this.spireAgentSocketEndpoint = spireAgentSocketEndpoint;
        this.jwtSourceOptions = JwtSourceOptions.builder().spiffeSocketPath(this.spireAgentSocketEndpoint).initTimeout(Duration.ofSeconds(1L)).build();
        this.initializeJwtSource();
    }

    private void initializeJwtSource() {
        try {
            this.jwtSource = DefaultJwtSource.newSource((JwtSourceOptions)this.jwtSourceOptions);
        }
        catch (JwtSourceException | SocketEndpointAddressException e) {
            log.error(e.getMessage(), e);
            this.jwtSource = null;
        }
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="audience")
    public Set<String> audience() {
        return this.audience;
    }

    @JsonProperty(value="spireAgentSocketEndpoint")
    public String spireAgentSocketEndpoint() {
        return this.spireAgentSocketEndpoint;
    }

    @Override
    public ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> constraints, SecurityContext context) {
        if (this.jwtSource == null) {
            this.initializeJwtSource();
        }
        SpireVerificationKeyResolver keyResolver = new SpireVerificationKeyResolver(this.jwtSource, this.spireIssuerSuffix);
        return new ConstrainedVerificationKeyResolver(keyResolver, constraints);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Set<String> audience = Collections.emptySet();
        private String spireIssuerSuffix = "spire.internal.confluent.cloud";

        private Builder() {
        }

        @JsonSetter(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(value="audience")
        public Builder audience(Set<String> audience) {
            if (audience != null) {
                this.audience = audience;
            }
            return this;
        }

        @JsonSetter(value="spireIssuerSuffix")
        public Builder spireIssuerSuffix(String spireIssuerSuffix) {
            if (spireIssuerSuffix != null && !spireIssuerSuffix.isEmpty()) {
                this.spireIssuerSuffix = spireIssuerSuffix;
            }
            return this;
        }

        public JwtIssuerSpire build() throws SocketEndpointAddressException, JwtSourceException {
            return new JwtIssuerSpire(this.name, this.audience, this.spireIssuerSuffix);
        }
    }
}

