/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.options.ShellWords;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CurlOption {
    private final URI uri;
    private final HttpMethod method;
    private final List<Map.Entry<String, String>> headers;

    private CurlOption(HttpMethod method, URI uri, List<Map.Entry<String, String>> headers) {
        this.uri = Objects.requireNonNull(uri);
        this.method = Objects.requireNonNull(method);
        this.headers = Objects.requireNonNull(headers);
    }

    @SafeVarargs
    public static CurlOption create(HttpMethod method, URI uri, Map.Entry<String, String> ... headers) {
        return new CurlOption(method, uri, Arrays.asList(headers));
    }

    public static CurlOption parse(String cmdLine) {
        List<String> args = ShellWords.parse(cmdLine);
        String url = null;
        HttpMethod method = HttpMethod.PUT;
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        while (!args.isEmpty()) {
            String arg = args.remove(0);
            if (arg.equals("-X")) {
                String methodArg = CurlOption.removeArgFor(arg, args);
                method = HttpMethod.parse(methodArg);
                continue;
            }
            if (arg.equals("-H")) {
                String headerArg = CurlOption.removeArgFor(arg, args);
                AbstractMap.SimpleEntry<String, String> e = CurlOption.parseHeader(headerArg);
                headers.add(e);
                continue;
            }
            if (url != null) {
                throw new IllegalArgumentException("'" + cmdLine + "' was not a valid curl command");
            }
            url = arg;
        }
        if (url == null) {
            throw new IllegalArgumentException("'" + cmdLine + "' was not a valid curl command");
        }
        try {
            return new CurlOption(method, new URI(url), headers);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String removeArgFor(String arg, List<String> args) {
        if (!args.isEmpty()) {
            return args.remove(0);
        }
        throw new IllegalArgumentException("Missing argument for " + arg);
    }

    private static AbstractMap.SimpleEntry<String, String> parseHeader(String headerArg) {
        String[] parts = headerArg.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("'" + headerArg + "' was not a valid header");
        }
        return new AbstractMap.SimpleEntry<String, String>(parts[0].trim(), parts[1].trim());
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        TRACE;


        static HttpMethod parse(String argument) {
            for (HttpMethod value : HttpMethod.values()) {
                if (!value.name().equals(argument)) continue;
                return value;
            }
            throw new IllegalArgumentException(argument + " was not a http method");
        }
    }
}

