/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.CurlOption;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.core.plugin.UrlOutputStream;
import io.cucumber.plugin.Plugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class PluginFactory {
    private static final Logger log = LoggerFactory.getLogger(PluginFactory.class);
    private final Class<?>[] CTOR_PARAMETERS = new Class[]{String.class, File.class, URI.class, URL.class, OutputStream.class, Appendable.class};
    private String pluginUsingDefaultOut = null;
    private PrintStream defaultOut = new PrintStream(System.out){

        @Override
        public void close() {
        }
    };

    Plugin create(Options.Plugin plugin) {
        try {
            return this.instantiate(plugin.pluginString(), plugin.pluginClass(), plugin.argument());
        }
        catch (IOException | URISyntaxException e) {
            throw new CucumberException(e);
        }
    }

    private <T extends Plugin> T instantiate(String pluginString, Class<T> pluginClass, String argument) throws IOException, URISyntaxException {
        Map<Class<?>, Constructor<T>> singleArgConstructors = this.findSingleArgConstructors(pluginClass);
        if (argument == null) {
            Constructor<T> outputStreamConstructor = singleArgConstructors.get(OutputStream.class);
            if (outputStreamConstructor != null) {
                return this.newInstance(outputStreamConstructor, this.defaultOutOrFailIfAlreadyUsed(pluginString));
            }
            Constructor<T> emptyConstructor = this.findEmptyConstructor(pluginClass);
            if (emptyConstructor != null) {
                return this.newInstance(emptyConstructor, new Object[0]);
            }
            if (!singleArgConstructors.isEmpty()) {
                throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:DIR|FILE|URL", pluginString, pluginString));
            }
            throw new CucumberException(String.format("%s must have at least one empty constructor or a constructor that declares a single parameter of one of: %s", pluginClass, Arrays.asList(this.CTOR_PARAMETERS)));
        }
        if (singleArgConstructors.size() != 1) {
            throw new CucumberException(String.format("%s must have exactly one constructor that declares a single parameter of one of: %s", pluginClass, Arrays.asList(this.CTOR_PARAMETERS)));
        }
        Map.Entry<Class<?>, Constructor<T>> singleArgConstructorEntry = singleArgConstructors.entrySet().iterator().next();
        Class<?> parameterType = singleArgConstructorEntry.getKey();
        Constructor<T> singleArgConstructor = singleArgConstructorEntry.getValue();
        return this.newInstance(singleArgConstructor, this.convert(argument, parameterType, pluginString, pluginClass));
    }

    private <T> Map<Class<?>, Constructor<T>> findSingleArgConstructors(Class<T> pluginClass) {
        HashMap result = new HashMap();
        for (Class<?> ctorArgClass : this.CTOR_PARAMETERS) {
            try {
                result.put(ctorArgClass, pluginClass.getConstructor(ctorArgClass));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return result;
    }

    private <T extends Plugin> T newInstance(Constructor<T> constructor, Object ... ctorArgs) {
        try {
            return (T)((Plugin)constructor.newInstance(ctorArgs));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CucumberException(e);
        }
        catch (InvocationTargetException e) {
            throw new CucumberException(e.getTargetException());
        }
    }

    private PrintStream defaultOutOrFailIfAlreadyUsed(String pluginString) {
        try {
            if (this.defaultOut != null) {
                this.pluginUsingDefaultOut = pluginString;
                PrintStream printStream = this.defaultOut;
                return printStream;
            }
            throw new CucumberException("Only one plugin can use STDOUT, now both " + this.pluginUsingDefaultOut + " and " + pluginString + " use it. If you use more than one plugin you must specify output path with " + pluginString + ":DIR|FILE|URL");
        }
        finally {
            this.defaultOut = null;
        }
    }

    private <T extends Plugin> Constructor<T> findEmptyConstructor(Class<T> pluginClass) {
        try {
            return pluginClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private Object convert(String arg, Class<?> ctorArgClass, String pluginString, Class<?> pluginClass) throws IOException, URISyntaxException {
        if (ctorArgClass.equals(URI.class)) {
            return PluginFactory.makeURL(arg).toURI();
        }
        if (ctorArgClass.equals(URL.class)) {
            return PluginFactory.makeURL(arg);
        }
        if (ctorArgClass.equals(File.class)) {
            return new File(arg);
        }
        if (ctorArgClass.equals(String.class)) {
            return arg;
        }
        if (ctorArgClass.equals(OutputStream.class)) {
            if (arg == null) {
                return this.defaultOutOrFailIfAlreadyUsed(pluginString);
            }
            return PluginFactory.openStream(arg);
        }
        if (ctorArgClass.equals(Appendable.class)) {
            String recommendedParameters = Arrays.stream(this.CTOR_PARAMETERS).filter(c -> c != Appendable.class).map(Class::getName).collect(Collectors.joining(", "));
            log.error(() -> String.format("The %s plugin class takes a java.lang.Appendable in its constructor, which is deprecated and will be removed in the next major release. It should be changed to accept one of %s", pluginClass.getName(), recommendedParameters));
            return new UTF8OutputStreamWriter(PluginFactory.openStream(arg));
        }
        throw new CucumberException(String.format("Cannot convert %s into a %s to pass to the %s plugin", arg, ctorArgClass, pluginString));
    }

    private static URL makeURL(String arg) throws MalformedURLException {
        if (arg.matches("^(file|http|https):.*")) {
            return new URL(arg);
        }
        return new URL("file:" + arg);
    }

    private static OutputStream openStream(String arg) throws IOException {
        if (arg.matches("^(http|https):.*")) {
            CurlOption option = CurlOption.parse(arg);
            return new UrlOutputStream(option, null);
        }
        if (arg.matches("^file:.*")) {
            return PluginFactory.createFileOutputStream(new File(new URL(arg).getFile()));
        }
        return PluginFactory.createFileOutputStream(new File(arg));
    }

    private static FileOutputStream createFileOutputStream(File file) {
        try {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("Couldn't create a file output stream for %s.\nMake sure the the file isn't a directory.\nThe details are in the stack trace below:", file), e);
        }
    }
}

