package io.cucumber.core.plugin;

import io.cucumber.messages.MessageToNdjsonWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;

import java.io.IOException;
import java.io.OutputStream;

public final class MessageFormatter implements ConcurrentEventListener {

    private final MessageToNdjsonWriter writer;

    public MessageFormatter(OutputStream outputStream) {
        this.writer = new MessageToNdjsonWriter(outputStream, Jackson.OBJECT_MAPPER::writeValue);
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            writer.write(event);
        } catch (IOException e) {
            throw new IllegalStateException(e);
        }

        // TODO: Plugins should implement the closable interface
        // and be closed by Cucumber
        if (event.getTestRunFinished().isPresent()) {
            try {
                writer.close();
            } catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

}
