/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.jsonformatter;

import java.util.List;
import java.util.Objects;

final class CucumberJvmJson {
    CucumberJvmJson() {
    }

    private static <T> List<T> nullIfEmpty(List<T> list) {
        return list.isEmpty() ? null : list;
    }

    static class JvmLocation {
        private final Long line;
        private final Long column;

        JvmLocation(Long line, Long column) {
            this.line = Objects.requireNonNull(line);
            this.column = Objects.requireNonNull(column);
        }

        public Long getLine() {
            return this.line;
        }

        public Long getColumn() {
            return this.column;
        }
    }

    static class JvmLocationTag {
        private final String name;
        private final String type;
        private final JvmLocation location;

        JvmLocationTag(String name, String type, JvmLocation location) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
            this.location = Objects.requireNonNull(location);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public JvmLocation getLocation() {
            return this.location;
        }
    }

    static class JvmTag {
        private final String name;

        JvmTag(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String getName() {
            return this.name;
        }
    }

    static class JvmEmbedding {
        private final String mime_type;
        private final String data;
        private final String name;

        JvmEmbedding(String mime_type, String data, String name) {
            this.mime_type = Objects.requireNonNull(mime_type);
            this.data = Objects.requireNonNull(data);
            this.name = name;
        }

        public String getData() {
            return this.data;
        }

        public String getMime_type() {
            return this.mime_type;
        }

        public String getName() {
            return this.name;
        }
    }

    static class JvmHook {
        private final JvmMatch match;
        private final JvmResult result;
        private final List<JvmEmbedding> embeddings;
        private final List<String> output;

        JvmHook(JvmMatch match, JvmResult result, List<JvmEmbedding> embeddings, List<String> output) {
            this.match = Objects.requireNonNull(match);
            this.result = Objects.requireNonNull(result);
            this.embeddings = CucumberJvmJson.nullIfEmpty(embeddings);
            this.output = CucumberJvmJson.nullIfEmpty(output);
        }

        public JvmMatch getMatch() {
            return this.match;
        }

        public JvmResult getResult() {
            return this.result;
        }

        public List<JvmEmbedding> getEmbeddings() {
            return this.embeddings;
        }

        public List<String> getOutput() {
            return this.output;
        }
    }

    static class JvmDataTableRow {
        private final List<String> cells;

        JvmDataTableRow(List<String> cells) {
            this.cells = Objects.requireNonNull(cells);
        }

        public List<String> getCells() {
            return this.cells;
        }
    }

    static class JvmDocString {
        private final Long line;
        private final String value;
        private final String content_type;

        JvmDocString(Long line, String value, String content_type) {
            this.line = Objects.requireNonNull(line);
            this.value = Objects.requireNonNull(value);
            this.content_type = content_type;
        }

        public Long getLine() {
            return this.line;
        }

        public String getValue() {
            return this.value;
        }

        public String getContent_type() {
            return this.content_type;
        }
    }

    static class JvmResult {
        private final Long duration;
        private final JvmStatus status;
        private final String error_message;

        JvmResult(Long duration, JvmStatus status, String error_message) {
            this.duration = duration;
            this.status = Objects.requireNonNull(status);
            this.error_message = error_message;
        }

        public Long getDuration() {
            return this.duration;
        }

        public JvmStatus getStatus() {
            return this.status;
        }

        public String getError_message() {
            return this.error_message;
        }
    }

    static class JvmArgument {
        private final String val;
        private final Number offset;

        JvmArgument(String val, Number offset) {
            this.val = Objects.requireNonNull(val);
            this.offset = Objects.requireNonNull(offset);
        }

        public String getVal() {
            return this.val;
        }

        public Number getOffset() {
            return this.offset;
        }
    }

    static class JvmMatch {
        private final String location;
        private final List<JvmArgument> arguments;

        JvmMatch(String location, List<JvmArgument> arguments) {
            this.location = location;
            this.arguments = arguments;
        }

        public String getLocation() {
            return this.location;
        }

        public List<JvmArgument> getArguments() {
            return this.arguments;
        }
    }

    static class JvmStep {
        private final String keyword;
        private final Long line;
        private final JvmMatch match;
        private final String name;
        private final JvmResult result;
        private final JvmDocString doc_string;
        private final List<JvmDataTableRow> rows;
        private final List<JvmHook> before;
        private final List<JvmHook> after;
        private final List<JvmEmbedding> embeddings;
        private final List<String> output;

        JvmStep(String keyword, Long line, JvmMatch match, String name, JvmResult result, JvmDocString doc_string, List<JvmDataTableRow> rows, List<JvmHook> before, List<JvmHook> after, List<JvmEmbedding> embeddings, List<String> output) {
            this.keyword = Objects.requireNonNull(keyword);
            this.line = Objects.requireNonNull(line);
            this.match = match;
            this.name = Objects.requireNonNull(name);
            this.result = Objects.requireNonNull(result);
            this.doc_string = doc_string;
            this.rows = rows;
            this.before = CucumberJvmJson.nullIfEmpty(before);
            this.after = CucumberJvmJson.nullIfEmpty(after);
            this.embeddings = CucumberJvmJson.nullIfEmpty(embeddings);
            this.output = CucumberJvmJson.nullIfEmpty(output);
        }

        public String getKeyword() {
            return this.keyword;
        }

        public Long getLine() {
            return this.line;
        }

        public JvmMatch getMatch() {
            return this.match;
        }

        public String getName() {
            return this.name;
        }

        public JvmResult getResult() {
            return this.result;
        }

        public JvmDocString getDoc_string() {
            return this.doc_string;
        }

        public List<JvmDataTableRow> getRows() {
            return this.rows;
        }

        public List<JvmHook> getBefore() {
            return this.before;
        }

        public List<JvmHook> getAfter() {
            return this.after;
        }

        public List<JvmEmbedding> getEmbeddings() {
            return this.embeddings;
        }

        public List<String> getOutput() {
            return this.output;
        }
    }

    static class JvmElement {
        private final String start_timestamp;
        private final Long line;
        private final String id;
        private final JvmElementType type;
        private final String keyword;
        private final String name;
        private final String description;
        private final List<JvmStep> steps;
        private final List<JvmHook> before;
        private final List<JvmHook> after;
        private final List<JvmTag> tags;

        JvmElement(String start_timestamp, Long line, String id, JvmElementType type, String keyword, String name, String description, List<JvmStep> steps, List<JvmHook> before, List<JvmHook> after, List<JvmTag> tags) {
            this.start_timestamp = start_timestamp;
            this.line = Objects.requireNonNull(line);
            this.id = id;
            this.type = Objects.requireNonNull(type);
            this.keyword = Objects.requireNonNull(keyword);
            this.name = Objects.requireNonNull(name);
            this.description = Objects.requireNonNull(description);
            this.steps = Objects.requireNonNull(steps);
            this.before = CucumberJvmJson.nullIfEmpty(before);
            this.after = CucumberJvmJson.nullIfEmpty(after);
            this.tags = CucumberJvmJson.nullIfEmpty(tags);
        }

        public String getStart_timestamp() {
            return this.start_timestamp;
        }

        public Long getLine() {
            return this.line;
        }

        public String getId() {
            return this.id;
        }

        public JvmElementType getType() {
            return this.type;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<JvmStep> getSteps() {
            return this.steps;
        }

        public List<JvmHook> getBefore() {
            return this.before;
        }

        public List<JvmHook> getAfter() {
            return this.after;
        }

        public List<JvmTag> getTags() {
            return this.tags;
        }
    }

    static class JvmFeature {
        private final Long line;
        private final String uri;
        private final String id;
        private final String keyword;
        private final String name;
        private final String description;
        private final List<JvmElement> elements;
        private final List<JvmLocationTag> tags;

        JvmFeature(String uri, String id, Long line, String keyword, String name, String description, List<JvmElement> elements, List<JvmLocationTag> tags) {
            this.uri = Objects.requireNonNull(uri);
            this.id = Objects.requireNonNull(id);
            this.line = Objects.requireNonNull(line);
            this.keyword = Objects.requireNonNull(keyword);
            this.name = Objects.requireNonNull(name);
            this.description = Objects.requireNonNull(description);
            this.elements = Objects.requireNonNull(elements);
            this.tags = tags;
        }

        public String getUri() {
            return this.uri;
        }

        public String getId() {
            return this.id;
        }

        public Long getLine() {
            return this.line;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<JvmElement> getElements() {
            return this.elements;
        }

        public List<JvmLocationTag> getTags() {
            return this.tags;
        }
    }

    static enum JvmStatus {
        passed,
        failed,
        skipped,
        undefined,
        pending;

    }

    static enum JvmElementType {
        background,
        scenario;

    }
}

