/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.spring;

import java.util.HashMap;
import java.util.Map;

class GlueCodeContext {
    private static final ThreadLocal<GlueCodeContext> localContext = new ThreadLocal<GlueCodeContext>(){

        @Override
        protected GlueCodeContext initialValue() {
            return new GlueCodeContext();
        }
    };
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private final Map<String, Runnable> callbacks = new HashMap<String, Runnable>();
    private int counter;

    private GlueCodeContext() {
    }

    public static GlueCodeContext getInstance() {
        return localContext.get();
    }

    public void start() {
        this.cleanUp();
        ++this.counter;
    }

    public String getId() {
        return "cucumber_glue_" + this.counter;
    }

    public void stop() {
        for (Runnable callback : this.callbacks.values()) {
            callback.run();
        }
        this.cleanUp();
    }

    public Object get(String name) {
        return this.objects.get(name);
    }

    public void put(String name, Object object) {
        this.objects.put(name, object);
    }

    public Object remove(String name) {
        this.callbacks.remove(name);
        return this.objects.remove(name);
    }

    private void cleanUp() {
        this.objects.clear();
        this.callbacks.clear();
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.callbacks.put(name, callback);
    }
}

