/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.htmlformatter;

import io.cucumber.htmlformatter.JsonInHtmlWriter;
import io.cucumber.messages.types.Envelope;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;

public final class MessagesToHtmlWriter
implements AutoCloseable {
    private final OutputStreamWriter writer;
    private final JsonInHtmlWriter jsonInHtmlWriter;
    private final Serializer serializer;
    private final String template;
    private final Supplier<InputStream> title;
    private final Supplier<InputStream> icon;
    private final Supplier<InputStream> css;
    private final Supplier<InputStream> customCss;
    private final Supplier<InputStream> script;
    private final Supplier<InputStream> customScript;
    private boolean preMessageWritten = false;
    private boolean postMessageWritten = false;
    private boolean firstMessageWritten = false;
    private boolean streamClosed = false;

    @Deprecated
    public MessagesToHtmlWriter(OutputStream outputStream, Serializer serializer) throws IOException {
        this(MessagesToHtmlWriter.createWriter(outputStream), Objects.requireNonNull(serializer), () -> MessagesToHtmlWriter.createInputStream("Cucumber"), () -> MessagesToHtmlWriter.getResource("icon.url"), () -> MessagesToHtmlWriter.getResource("main.css"), MessagesToHtmlWriter::createEmptyInputStream, () -> MessagesToHtmlWriter.getResource("main.js"), MessagesToHtmlWriter::createEmptyInputStream);
    }

    private MessagesToHtmlWriter(OutputStreamWriter writer, Serializer serializer, Supplier<InputStream> title, Supplier<InputStream> icon, Supplier<InputStream> css, Supplier<InputStream> customCss, Supplier<InputStream> script, Supplier<InputStream> customScript) {
        this.writer = writer;
        this.jsonInHtmlWriter = new JsonInHtmlWriter(writer);
        this.serializer = serializer;
        this.template = MessagesToHtmlWriter.readTemplate();
        this.title = title;
        this.icon = icon;
        this.css = css;
        this.customCss = customCss;
        this.customScript = customScript;
        this.script = script;
    }

    private static OutputStreamWriter createWriter(OutputStream outputStream) {
        return new OutputStreamWriter(Objects.requireNonNull(outputStream), StandardCharsets.UTF_8);
    }

    private static String readTemplate() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));){
                InputStream resource = MessagesToHtmlWriter.getResource("index.mustache.html");
                MessagesToHtmlWriter.writeResource((Writer)writer, resource);
            }
            return new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read resource index.mustache.html", e);
        }
    }

    private static InputStream createInputStream(String text) {
        return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
    }

    private static InputStream createEmptyInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    private static InputStream getResource(String name) {
        InputStream resource = MessagesToHtmlWriter.class.getResourceAsStream(name);
        Objects.requireNonNull(resource, name + " could not be loaded");
        return resource;
    }

    private void writePreMessage() throws IOException {
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, null, "{{title}}");
        MessagesToHtmlWriter.writeResource((Writer)this.writer, this.title);
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{title}}", "{{icon}}");
        MessagesToHtmlWriter.writeResource((Writer)this.writer, this.icon);
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{icon}}", "{{css}}");
        MessagesToHtmlWriter.writeResource((Writer)this.writer, this.css);
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{css}}", "{{custom_css}}");
        MessagesToHtmlWriter.writeResource((Writer)this.writer, this.customCss);
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{custom_css}}", "{{messages}}");
    }

    private void writePostMessage() throws IOException {
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{messages}}", "{{script}}");
        MessagesToHtmlWriter.writeResource((Writer)this.writer, this.script);
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{script}}", "{{custom_script}}");
        MessagesToHtmlWriter.writeResource((Writer)this.writer, this.customScript);
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{custom_script}}", null);
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.preMessageWritten) {
            this.writePreMessage();
            this.preMessageWritten = true;
        }
        if (!this.firstMessageWritten) {
            this.firstMessageWritten = true;
        } else {
            this.writer.write(",");
        }
        this.serializer.writeValue(this.jsonInHtmlWriter, envelope);
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        if (!this.preMessageWritten) {
            this.writePreMessage();
            this.preMessageWritten = true;
        }
        if (!this.postMessageWritten) {
            this.writePostMessage();
            this.postMessageWritten = true;
        }
        try {
            this.writer.close();
        }
        finally {
            this.streamClosed = true;
        }
    }

    private static void writeTemplateBetween(Writer writer, String template, String begin, String end) throws IOException {
        int beginIndex = begin == null ? 0 : template.indexOf(begin) + begin.length();
        int endIndex = end == null ? template.length() : template.indexOf(end);
        writer.write(template.substring(beginIndex, endIndex));
    }

    private static void writeResource(Writer writer, Supplier<InputStream> resource) throws IOException {
        MessagesToHtmlWriter.writeResource(writer, resource.get());
    }

    private static void writeResource(Writer writer, InputStream resource) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
        char[] buffer = new char[1024];
        int read = reader.read(buffer);
        while (read != -1) {
            writer.write(buffer, 0, read);
            read = reader.read(buffer);
        }
    }

    public static Builder builder(Serializer serializer) {
        return new Builder(serializer);
    }

    @FunctionalInterface
    public static interface Serializer {
        public void writeValue(Writer var1, Envelope var2) throws IOException;
    }

    public static final class Builder {
        private final Serializer serializer;
        private Supplier<InputStream> title = () -> MessagesToHtmlWriter.access$300("Cucumber");
        private Supplier<InputStream> icon = () -> MessagesToHtmlWriter.access$500("icon.url");
        private Supplier<InputStream> css = () -> MessagesToHtmlWriter.access$500("main.css");
        private Supplier<InputStream> customCss = () -> MessagesToHtmlWriter.access$400();
        private Supplier<InputStream> script = () -> MessagesToHtmlWriter.access$500("main.js");
        private Supplier<InputStream> customScript = () -> MessagesToHtmlWriter.access$400();

        private Builder(Serializer serializer) {
            this.serializer = Objects.requireNonNull(serializer);
        }

        public Builder title(String title) {
            Objects.requireNonNull(title);
            this.title = () -> MessagesToHtmlWriter.createInputStream(title);
            return this;
        }

        public Builder icon(Supplier<InputStream> icon) {
            this.icon = Objects.requireNonNull(icon);
            return this;
        }

        public Builder icon(String icon) {
            Objects.requireNonNull(icon);
            return this.icon(() -> MessagesToHtmlWriter.createInputStream(icon));
        }

        public Builder css(Supplier<InputStream> css) {
            this.css = Objects.requireNonNull(css);
            return this;
        }

        public Builder customCss(Supplier<InputStream> customCss) {
            this.customCss = Objects.requireNonNull(customCss);
            return this;
        }

        public Builder script(Supplier<InputStream> script) {
            this.script = Objects.requireNonNull(script);
            return this;
        }

        public Builder customScript(Supplier<InputStream> customScript) {
            this.customScript = Objects.requireNonNull(customScript);
            return this;
        }

        public MessagesToHtmlWriter build(OutputStream out) {
            return new MessagesToHtmlWriter(MessagesToHtmlWriter.createWriter(out), this.serializer, this.title, this.icon, this.css, this.customCss, this.script, this.customScript);
        }
    }
}

