/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.prettyformatter.LineBuilder;
import io.cucumber.prettyformatter.Theme;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;

final class ExceptionFormatter {
    private final int indent;
    private final Theme theme;
    private final TestStepResultStatus status;

    ExceptionFormatter(int indent, Theme theme, TestStepResultStatus status) {
        this.indent = indent;
        this.theme = theme;
        this.status = status;
    }

    Optional<String> format(Exception exception) {
        if (exception.getStackTrace().isPresent()) {
            String stacktrace = (String)exception.getStackTrace().get();
            return Optional.of(this.format(stacktrace));
        }
        if (exception.getMessage().isPresent()) {
            String message = (String)exception.getMessage().get();
            return Optional.of(this.format(message));
        }
        return Optional.empty();
    }

    String format(String message) {
        LineBuilder builder = new LineBuilder(this.theme);
        try (BufferedReader lines = new BufferedReader(new StringReader(message));){
            String line;
            while ((line = lines.readLine()) != null) {
                builder.indent(this.indent).append(Theme.Element.STEP, this.status, line).newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }
}

