/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.Lineage;
import io.cucumber.query.LineageReducer;
import java.util.Objects;
import java.util.function.Supplier;

class LineageReducerAscending<T>
implements LineageReducer<T> {
    private final Supplier<? extends LineageReducer.Collector<T>> collectorSupplier;

    LineageReducerAscending(Supplier<? extends LineageReducer.Collector<T>> collectorSupplier) {
        this.collectorSupplier = Objects.requireNonNull(collectorSupplier);
    }

    @Override
    public T reduce(Lineage lineage) {
        LineageReducer.Collector<T> collector = this.collectorSupplier.get();
        LineageReducerAscending.reduceAddLineage(collector, lineage);
        return collector.finish();
    }

    @Override
    public T reduce(Lineage lineage, Pickle pickle) {
        LineageReducer.Collector<T> collector = this.collectorSupplier.get();
        collector.add(pickle);
        LineageReducerAscending.reduceAddLineage(collector, lineage);
        return collector.finish();
    }

    private static <T> void reduceAddLineage(LineageReducer.Collector<T> reducer, Lineage lineage) {
        lineage.example().ifPresent(example -> reducer.add((TableRow)example, (int)lineage.exampleIndex().orElse(0)));
        lineage.examples().ifPresent(examples -> reducer.add((Examples)examples, (int)lineage.examplesIndex().orElse(0)));
        lineage.scenario().ifPresent(reducer::add);
        lineage.rule().ifPresent(reducer::add);
        lineage.feature().ifPresent(reducer::add);
        reducer.add(lineage.document());
    }
}

