/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.teamcityformatter;

import io.cucumber.messages.types.Snippet;
import io.cucumber.messages.types.Suggestion;
import java.util.Collection;
import java.util.stream.Collectors;

final class SuggestionFormatter {
    SuggestionFormatter() {
    }

    static String format(Collection<Suggestion> suggestions) {
        if (suggestions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("You can implement this step");
        if (suggestions.size() > 1) {
            sb.append(" and ").append(suggestions.size() - 1).append(" other step(s)");
        }
        sb.append(" using the snippet(s) below:\n\n");
        String snippets = suggestions.stream().map(Suggestion::getSnippets).flatMap(Collection::stream).map(Snippet::getCode).distinct().collect(Collectors.joining("\n", "", "\n"));
        sb.append(snippets);
        return sb.toString();
    }
}

