/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.generator;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.DekorateException;
import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.hook.ImageBuildHook;
import io.dekorate.knative.adapter.KnativeConfigAdapter;
import io.dekorate.knative.annotation.KnativeApplication;
import io.dekorate.knative.config.EditableKnativeConfig;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.KnativeConfigBuilder;
import io.dekorate.knative.config.KnativeConfigCustomAdapter;
import io.dekorate.knative.handler.KnativeHandler;
import io.dekorate.kubernetes.configurator.ApplyBuildToImageConfiguration;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;

public interface KnativeApplicationGenerator
extends Generator,
WithSession,
WithProject,
SessionListener {
    public static final String KNATIVE = "knative";

    default public String getKey() {
        return KNATIVE;
    }

    default public Class<? extends Annotation> getAnnotation() {
        return KnativeApplication.class;
    }

    default public void add(Element element) {
        KnativeApplication knativeApplication = element.getAnnotation(KnativeApplication.class);
        EditableKnativeConfig knativeConfig = KnativeConfigCustomAdapter.newBuilder(this.getProject(), knativeApplication).build();
        this.on((ConfigurationSupplier<KnativeConfig>)new ConfigurationSupplier((VisitableBuilder)((KnativeConfigBuilder)KnativeConfigAdapter.newBuilder(element.getAnnotation(KnativeApplication.class)).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(Map map) {
        EditableKnativeConfig knativeConfig = KnativeConfigAdapter.newBuilder((Map)map.get(KnativeApplication.class.getName())).build();
        this.on((ConfigurationSupplier<KnativeConfig>)new ConfigurationSupplier((VisitableBuilder)((KnativeConfigBuilder)KnativeConfigAdapter.newBuilder(this.propertiesMap(map, KnativeApplication.class)).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void on(ConfigurationSupplier<KnativeConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.handlers().add(new KnativeHandler(session.resources(), session.configurators()));
        session.addListener((SessionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void onClosed() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Session session = this.getSession();
            Project project = this.getProject();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            KnativeConfig config = (KnativeConfig)((Object)session.configurators().get(KnativeConfig.class).get());
            Optional imageConfiguration = session.configurators().getImageConfig(BuildServiceFactories.supplierMatches((Project)project));
            imageConfiguration.ifPresent(i -> {
                String name = i.getName();
                if (i.isAutoBuildEnabled() || config.isAutoDeployEnabled()) {
                    BuildService buildService;
                    KubernetesList generated = (KubernetesList)session.getGeneratedResources().get(KNATIVE);
                    try {
                        buildService = (BuildService)imageConfiguration.map(BuildServiceFactories.create((Project)this.getProject(), (Collection)generated.getItems())).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
                    }
                    catch (Exception e) {
                        throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
                    }
                    ImageBuildHook hook = new ImageBuildHook(this.getProject(), buildService);
                    hook.register();
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

