/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.adapter;

import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.Container;
import io.dekorate.deps.kubernetes.api.model.ContainerBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPortDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsMemoryDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsMemoryDecorator;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;

public class ContainerAdapter {
    public static Container adapt(io.dekorate.kubernetes.config.Container container) {
        String name = container.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = Images.getName((String)container.getImage());
        }
        ContainerBuilder builder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(name)).withImage(container.getImage())).withCommand(container.getCommand())).withArgs(container.getArguments());
        for (Env env : container.getEnvVars()) {
            builder.accept((Visitor)new AddEnvVarDecorator(env));
        }
        for (Port port : container.getPorts()) {
            builder.accept((Visitor)new AddPortDecorator(port));
        }
        for (Mount mount : container.getMounts()) {
            builder.accept((Visitor)new AddMountDecorator(mount));
        }
        builder.accept((Visitor)new ApplyImagePullPolicyDecorator(container.getImagePullPolicy()));
        builder.accept((Visitor)new AddLivenessProbeDecorator(name, container.getLivenessProbe()));
        builder.accept((Visitor)new AddReadinessProbeDecorator(name, container.getReadinessProbe()));
        if (Strings.isNotNullOrEmpty((String)container.getLimitResources().getCpu())) {
            builder.accept((Visitor)new ApplyLimitsCpuDecorator(name, container.getLimitResources().getCpu()));
        }
        if (Strings.isNotNullOrEmpty((String)container.getLimitResources().getMemory())) {
            builder.accept((Visitor)new ApplyLimitsMemoryDecorator(name, container.getLimitResources().getMemory()));
        }
        if (Strings.isNotNullOrEmpty((String)container.getRequestResources().getCpu())) {
            builder.accept((Visitor)new ApplyRequestsCpuDecorator(name, container.getRequestResources().getCpu()));
        }
        if (Strings.isNotNullOrEmpty((String)container.getRequestResources().getMemory())) {
            builder.accept((Visitor)new ApplyRequestsMemoryDecorator(name, container.getRequestResources().getMemory()));
        }
        return builder.build();
    }
}

