/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.AzureFileVolumeFluent;
import io.dekorate.kubernetes.config.AzureFileVolumeFluentImpl;
import io.dekorate.kubernetes.config.EditableAzureFileVolume;

public class AzureFileVolumeBuilder
extends AzureFileVolumeFluentImpl<AzureFileVolumeBuilder>
implements VisitableBuilder<AzureFileVolume, AzureFileVolumeBuilder> {
    AzureFileVolumeFluent<?> fluent;
    Boolean validationEnabled;

    public AzureFileVolumeBuilder() {
        this(true);
    }

    public AzureFileVolumeBuilder(Boolean validationEnabled) {
        this(new AzureFileVolume(), validationEnabled);
    }

    public AzureFileVolumeBuilder(AzureFileVolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AzureFileVolumeBuilder(AzureFileVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AzureFileVolume(), validationEnabled);
    }

    public AzureFileVolumeBuilder(AzureFileVolumeFluent<?> fluent, AzureFileVolume instance) {
        this(fluent, instance, true);
    }

    public AzureFileVolumeBuilder(AzureFileVolumeFluent<?> fluent, AzureFileVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withVolumeName(instance.getVolumeName());
        fluent.withShareName(instance.getShareName());
        fluent.withSecretName(instance.getSecretName());
        fluent.withReadOnly(instance.isReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public AzureFileVolumeBuilder(AzureFileVolume instance) {
        this(instance, (Boolean)true);
    }

    public AzureFileVolumeBuilder(AzureFileVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withVolumeName(instance.getVolumeName());
        this.withShareName(instance.getShareName());
        this.withSecretName(instance.getSecretName());
        this.withReadOnly(instance.isReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public EditableAzureFileVolume build() {
        EditableAzureFileVolume buildable = new EditableAzureFileVolume(this.fluent.getVolumeName(), this.fluent.getShareName(), this.fluent.getSecretName(), this.fluent.isReadOnly());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureFileVolumeBuilder that = (AzureFileVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

