/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.SecretBuilder;
import io.dekorate.deps.kubernetes.api.model.SecretFluent;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AddBasicAuthSecretDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String KUBERNETES_IO_BASIC_AUTH = "kubernetes.io/basic-auth";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private final String name;
    private final String username;
    private final String password;
    private final Map<String, String> annotations;

    public AddBasicAuthSecretDecorator(String username, String password) {
        this(null, username, password, Collections.emptyMap());
    }

    public AddBasicAuthSecretDecorator(String username, String password, Map<String, String> annotations) {
        this(null, username, password, annotations);
    }

    public AddBasicAuthSecretDecorator(String name, String username, String password) {
        this(name, username, password, Collections.emptyMap());
    }

    public AddBasicAuthSecretDecorator(String name, String username, String password, Map<String, String> annotations) {
        this.name = name;
        this.username = username;
        this.password = password;
        this.annotations = annotations;
    }

    public void visit(KubernetesListBuilder list) {
        String name;
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        String string = name = Strings.isNullOrEmpty((String)this.name) ? meta.getName() : this.name;
        if (this.contains(list, "v1", "Secret", name)) {
            return;
        }
        HashMap<String, String> data = new HashMap<String, String>(){
            {
                this.put(AddBasicAuthSecretDecorator.USERNAME, AddBasicAuthSecretDecorator.this.username);
                this.put(AddBasicAuthSecretDecorator.PASSWORD, AddBasicAuthSecretDecorator.this.password);
            }
        };
        list.addToItems(new HasMetadata[]{((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).withAnnotations(this.annotations)).endMetadata()).withType(KUBERNETES_IO_BASIC_AUTH)).addToStringData((Map)data)).build()});
    }
}

