/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;

@Description(value="Apply the service account.")
public class ApplyServiceAccountNamedDecorator
extends NamedResourceDecorator<PodSpecFluent> {
    private static final String NONE = null;
    private final String serviceAccount;

    public ApplyServiceAccountNamedDecorator() {
        this(ANY, NONE);
    }

    public ApplyServiceAccountNamedDecorator(String serviceAccount) {
        super(ANY);
        this.serviceAccount = serviceAccount;
    }

    public ApplyServiceAccountNamedDecorator(String resourceName, String serviceAccount) {
        super(resourceName);
        this.serviceAccount = serviceAccount;
    }

    @Override
    public void andThenVisit(PodSpecFluent podSpec, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.serviceAccount)) {
            podSpec.withServiceAccount(this.serviceAccount);
        } else {
            podSpec.withServiceAccount(resourceMeta.getName());
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

