/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Builder;
import io.dekorate.deps.kubernetes.api.builder.TypedVisitor;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Generics;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import java.util.Optional;

public abstract class NamedResourceDecorator<T>
extends Decorator<VisitableBuilder> {
    public static final String ANY = null;
    protected final String kind;
    protected final String name;
    private final ResourceVisitor visitor = new ResourceVisitor(null, null);

    public NamedResourceDecorator() {
        this(ANY, ANY);
    }

    public NamedResourceDecorator(String name) {
        this(ANY, name);
    }

    public NamedResourceDecorator(String kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public void visit(VisitableBuilder builder) {
        Optional resourceKind = Metadata.getKind((Builder)builder);
        Optional objectMeta = Metadata.getMetadata((Builder)builder);
        if (!resourceKind.isPresent() || !objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.kind)) {
            if (Strings.isNullOrEmpty((String)this.name)) {
                builder.accept((Visitor)this.visitor.withKind((String)resourceKind.get()).withMetadata((ObjectMeta)objectMeta.get()));
            } else if (objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.name)).isPresent()) {
                builder.accept((Visitor)this.visitor.withKind((String)resourceKind.get()).withMetadata((ObjectMeta)objectMeta.get()));
            }
        } else if (resourceKind.filter(k -> k.equals(this.kind)).isPresent()) {
            if (Strings.isNullOrEmpty((String)this.name)) {
                builder.accept((Visitor)this.visitor.withKind((String)resourceKind.get()).withMetadata((ObjectMeta)objectMeta.get()));
            } else if (objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.name)).isPresent()) {
                builder.accept((Visitor)this.visitor.withKind((String)resourceKind.get()).withMetadata((ObjectMeta)objectMeta.get()));
            }
        }
    }

    public abstract void andThenVisit(T var1, ObjectMeta var2);

    public void andThenVisit(T item, String kind, ObjectMeta resourceMeta) {
        this.andThenVisit(item, resourceMeta);
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    private class ResourceVisitor
    extends TypedVisitor<T> {
        private final String kind;
        private final ObjectMeta metadata;

        public ResourceVisitor(String kind, ObjectMeta metadata) {
            this.kind = kind;
            this.metadata = metadata;
        }

        public void visit(T item) {
            NamedResourceDecorator.this.andThenVisit(item, this.kind, this.metadata);
        }

        public ResourceVisitor withKind(String kind) {
            return new ResourceVisitor(kind, this.metadata);
        }

        public ResourceVisitor withMetadata(ObjectMeta metadata) {
            return new ResourceVisitor(this.kind, metadata);
        }

        public Class<T> getType() {
            return (Class)Generics.getTypeArguments(NamedResourceDecorator.class, NamedResourceDecorator.this.getClass()).get(0);
        }
    }
}

