/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.SecretVolume;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KubernetesConfigAdapter {
    public static KubernetesConfig adapt(KubernetesApplication instance) {
        return KubernetesConfigAdapter.newBuilder(instance).build();
    }

    public static KubernetesConfigBuilder newBuilder(KubernetesApplication instance) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, instance.partOf(), instance.name(), instance.version(), Arrays.asList(instance.labels()).stream().map(i -> new Label(i.key(), i.value(), i.kinds())).collect(Collectors.toList()).toArray(new Label[0]), Arrays.asList(instance.annotations()).stream().map(i -> new Annotation(i.key(), i.value(), i.kinds())).collect(Collectors.toList()).toArray(new Annotation[0]), Arrays.asList(instance.envVars()).stream().map(i -> new Env(i.name(), i.value(), i.secret(), i.configmap(), i.field(), i.resourceField())).collect(Collectors.toList()).toArray(new Env[0]), instance.workingDir(), instance.command(), instance.arguments(), instance.serviceAccount(), instance.host(), Arrays.asList(instance.ports()).stream().map(i -> new Port(i.name(), i.containerPort(), i.hostPort(), i.path(), i.protocol())).collect(Collectors.toList()).toArray(new Port[0]), instance.serviceType(), Arrays.asList(instance.pvcVolumes()).stream().map(i -> new PersistentVolumeClaimVolume(i.volumeName(), i.claimName(), i.readOnly())).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]), Arrays.asList(instance.secretVolumes()).stream().map(i -> new SecretVolume(i.volumeName(), i.secretName(), i.defaultMode(), i.optional())).collect(Collectors.toList()).toArray(new SecretVolume[0]), Arrays.asList(instance.configMapVolumes()).stream().map(i -> new ConfigMapVolume(i.volumeName(), i.configMapName(), i.defaultMode(), i.optional())).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]), Arrays.asList(instance.gitRepoVolumes()).stream().map(i -> new GitRepoVolume(i.volumeName(), i.repository(), i.directory(), i.revision())).collect(Collectors.toList()).toArray(new GitRepoVolume[0]), Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i -> new AwsElasticBlockStoreVolume(i.volumeName(), i.volumeId(), i.partition(), i.fsType(), i.readOnly())).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]), Arrays.asList(instance.azureDiskVolumes()).stream().map(i -> new AzureDiskVolume(i.volumeName(), i.diskName(), i.diskURI(), i.kind(), i.cachingMode(), i.fsType(), i.readOnly())).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]), Arrays.asList(instance.azureFileVolumes()).stream().map(i -> new AzureFileVolume(i.volumeName(), i.shareName(), i.secretName(), i.readOnly())).collect(Collectors.toList()).toArray(new AzureFileVolume[0]), Arrays.asList(instance.mounts()).stream().map(i -> new Mount(i.name(), i.path(), i.subPath(), i.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]), instance.imagePullPolicy(), instance.imagePullSecrets(), Arrays.asList(instance.hostAliases()).stream().map(i -> new HostAlias(i.ip(), i.hostnames())).collect(Collectors.toList()).toArray(new HostAlias[0]), new Probe(instance.livenessProbe().httpActionPath(), instance.livenessProbe().execAction(), instance.livenessProbe().tcpSocketAction(), instance.livenessProbe().initialDelaySeconds(), instance.livenessProbe().periodSeconds(), instance.livenessProbe().timeoutSeconds(), instance.livenessProbe().successThreshold(), instance.livenessProbe().failureThreshold()), new Probe(instance.readinessProbe().httpActionPath(), instance.readinessProbe().execAction(), instance.readinessProbe().tcpSocketAction(), instance.readinessProbe().initialDelaySeconds(), instance.readinessProbe().periodSeconds(), instance.readinessProbe().timeoutSeconds(), instance.readinessProbe().successThreshold(), instance.readinessProbe().failureThreshold()), new ResourceRequirements(instance.requestResources().memory(), instance.requestResources().cpu()), new ResourceRequirements(instance.limitResources().memory(), instance.limitResources().cpu()), Arrays.asList(instance.sidecars()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field(), j.resourceField())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), j.containerPort(), j.hostPort(), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), j.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), i.livenessProbe().initialDelaySeconds(), i.livenessProbe().periodSeconds(), i.livenessProbe().timeoutSeconds(), i.livenessProbe().successThreshold(), i.livenessProbe().failureThreshold()), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), i.readinessProbe().initialDelaySeconds(), i.readinessProbe().periodSeconds(), i.readinessProbe().timeoutSeconds(), i.readinessProbe().successThreshold(), i.readinessProbe().failureThreshold()), new ResourceRequirements(i.requestResources().memory(), i.requestResources().cpu()), new ResourceRequirements(i.limitResources().memory(), i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]), instance.expose(), instance.autoDeployEnabled(), Arrays.asList(instance.initContainers()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field(), j.resourceField())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), j.containerPort(), j.hostPort(), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), j.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), i.livenessProbe().initialDelaySeconds(), i.livenessProbe().periodSeconds(), i.livenessProbe().timeoutSeconds(), i.livenessProbe().successThreshold(), i.livenessProbe().failureThreshold()), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), i.readinessProbe().initialDelaySeconds(), i.readinessProbe().periodSeconds(), i.readinessProbe().timeoutSeconds(), i.readinessProbe().successThreshold(), i.readinessProbe().failureThreshold()), new ResourceRequirements(i.requestResources().memory(), i.requestResources().cpu()), new ResourceRequirements(i.limitResources().memory(), i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]), instance.replicas(), instance.deploymentStrategy(), new RollingUpdate(instance.rollingUpdate().maxUnavailable(), instance.rollingUpdate().maxSurge()), instance.headless()));
    }

    public static KubernetesConfig adapt(Map map) {
        return new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("partOf", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null, i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null, i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("value", "") : "", i instanceof Map ? i.getOrDefault("secret", "") : "", i instanceof Map ? i.getOrDefault("configmap", "") : "", i instanceof Map ? i.getOrDefault("field", "") : "", i instanceof Map ? i.getOrDefault("resourceField", "") : "")).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("command")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("arguments")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, map instanceof Map ? map.getOrDefault("host", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("containerPort", null) : null, i instanceof Map ? i.getOrDefault("hostPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("path", "/") : "/", Protocol.valueOf(String.valueOf(i instanceof Map ? i.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), map instanceof Map ? (map.getOrDefault("serviceType", null) != null ? ServiceType.valueOf(String.valueOf(map.getOrDefault("serviceType", null))) : null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("claimName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("configMapName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(ConfigMapVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("repository", null) : null, i instanceof Map ? i.getOrDefault("directory", "") : "", i instanceof Map ? i.getOrDefault("revision", "") : "")).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("volumeId", null) : null, i instanceof Map ? i.getOrDefault("partition", null) : null, i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("diskName", null) : null, i instanceof Map ? i.getOrDefault("diskURI", null) : null, i instanceof Map ? i.getOrDefault("kind", "Managed") : "Managed", i instanceof Map ? i.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("shareName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("path", null) : null, i instanceof Map ? i.getOrDefault("subPath", "") : "", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), map instanceof Map ? (map.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf(String.valueOf(map.getOrDefault("imagePullPolicy", null))) : null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("imagePullSecrets")) : KubernetesConfigAdapter.toStringArray(map), (HostAlias[])Arrays.stream(map instanceof Map ? map.getOrDefault("hostAliases", new Map[0]) : new Map[]{}).map(i -> new HostAlias(i instanceof Map ? i.getOrDefault("ip", "") : "", i instanceof Map ? i.getOrDefault("hostnames", "") : "")).toArray(HostAlias[]::new), new Probe((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("cpu", "") : ""), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", null) : null, j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf(String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("expose", null) : null, map instanceof Map ? map.getOrDefault("autoDeployEnabled", null) : null, (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", null) : null, j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf(String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("replicas", null) : null, map instanceof Map ? (map.getOrDefault("deploymentStrategy", null) != null ? DeploymentStrategy.valueOf(String.valueOf(map.getOrDefault("deploymentStrategy", null))) : null) : null, new RollingUpdate((Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxUnavailable", "25%") : "25%", (Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxSurge", "25%") : "25%"), map instanceof Map ? map.getOrDefault("headless", null) : null);
    }

    public static KubernetesConfigBuilder newBuilder(Map map) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("partOf", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null, i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation(i instanceof Map ? i.getOrDefault("key", null) : null, i instanceof Map ? i.getOrDefault("value", null) : null, i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("value", "") : "", i instanceof Map ? i.getOrDefault("secret", "") : "", i instanceof Map ? i.getOrDefault("configmap", "") : "", i instanceof Map ? i.getOrDefault("field", "") : "", i instanceof Map ? i.getOrDefault("resourceField", "") : "")).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("command")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("arguments")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, map instanceof Map ? map.getOrDefault("host", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("containerPort", null) : null, i instanceof Map ? i.getOrDefault("hostPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("path", "/") : "/", Protocol.valueOf(String.valueOf(i instanceof Map ? i.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), map instanceof Map ? (map.getOrDefault("serviceType", null) != null ? ServiceType.valueOf(String.valueOf(map.getOrDefault("serviceType", null))) : null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("claimName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("configMapName", null) : null, i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false))).toArray(ConfigMapVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("repository", null) : null, i instanceof Map ? i.getOrDefault("directory", "") : "", i instanceof Map ? i.getOrDefault("revision", "") : "")).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("volumeId", null) : null, i instanceof Map ? i.getOrDefault("partition", null) : null, i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("diskName", null) : null, i instanceof Map ? i.getOrDefault("diskURI", null) : null, i instanceof Map ? i.getOrDefault("kind", "Managed") : "Managed", i instanceof Map ? i.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume(i instanceof Map ? i.getOrDefault("volumeName", null) : null, i instanceof Map ? i.getOrDefault("shareName", null) : null, i instanceof Map ? i.getOrDefault("secretName", null) : null, i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount(i instanceof Map ? i.getOrDefault("name", null) : null, i instanceof Map ? i.getOrDefault("path", null) : null, i instanceof Map ? i.getOrDefault("subPath", "") : "", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), map instanceof Map ? (map.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf(String.valueOf(map.getOrDefault("imagePullPolicy", null))) : null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("imagePullSecrets")) : KubernetesConfigAdapter.toStringArray(map), (HostAlias[])Arrays.stream(map instanceof Map ? map.getOrDefault("hostAliases", new Map[0]) : new Map[]{}).map(i -> new HostAlias(i instanceof Map ? i.getOrDefault("ip", "") : "", i instanceof Map ? i.getOrDefault("hostnames", "") : "")).toArray(HostAlias[]::new), new Probe((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("cpu", "") : ""), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", null) : null, j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf(String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("expose", null) : null, map instanceof Map ? map.getOrDefault("autoDeployEnabled", null) : null, (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container(i instanceof Map ? i.getOrDefault("image", null) : null, i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("containerPort", null) : null, j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf(String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount(j instanceof Map ? j.getOrDefault("name", null) : null, j instanceof Map ? j.getOrDefault("path", null) : null, j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("replicas", null) : null, map instanceof Map ? (map.getOrDefault("deploymentStrategy", null) != null ? DeploymentStrategy.valueOf(String.valueOf(map.getOrDefault("deploymentStrategy", null))) : null) : null, new RollingUpdate((Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxUnavailable", "25%") : "25%", (Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxSurge", "25%") : "25%"), map instanceof Map ? map.getOrDefault("headless", null) : null));
    }

    public static String[] toStringArray(Object o) {
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s.split(",[ ]*");
        }
        if (o instanceof List) {
            List c = (List)o;
            String[] result = new String[c.size()];
            for (int i = 0; i <= c.size(); ++i) {
                result[i] = String.valueOf(c.get(i));
            }
            return result;
        }
        return new String[0];
    }
}

