/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.BaseConfigFluentImpl;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluentImpl;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigFluent;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.RollingUpdateBuilder;
import io.dekorate.kubernetes.config.RollingUpdateFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KubernetesConfigFluentImpl<A extends KubernetesConfigFluent<A>>
extends BaseConfigFluentImpl<A>
implements KubernetesConfigFluent<A> {
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private Integer replicas;
    private DeploymentStrategy deploymentStrategy;
    private RollingUpdateBuilder rollingUpdate;
    private Boolean headless;

    public KubernetesConfigFluentImpl() {
    }

    public KubernetesConfigFluentImpl(KubernetesConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withHost(instance.getHost());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withHostAliases(instance.getHostAliases());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withRequestResources(instance.getRequestResources());
        this.withLimitResources(instance.getLimitResources());
        this.withSidecars(instance.getSidecars());
        this.withExpose(instance.getExpose());
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
        this.withInitContainers(instance.getInitContainers());
        this.withReplicas(instance.getReplicas());
        this.withDeploymentStrategy(instance.getDeploymentStrategy());
        this.withRollingUpdate(instance.getRollingUpdate());
        this.withHeadless(instance.getHeadless());
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Container[] getInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container[] buildInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container buildInitContainer(Integer index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"initContainers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index.intValue() : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"initContainers").size()) {
            this._visitables.get((Object)"initContainers").add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> setNewInitContainerLike(Integer index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editInitContainer(Integer index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    @Override
    public A withDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy = deploymentStrategy;
        return (A)this;
    }

    @Override
    public Boolean hasDeploymentStrategy() {
        return this.deploymentStrategy != null;
    }

    @Override
    @Deprecated
    public RollingUpdate getRollingUpdate() {
        return this.rollingUpdate != null ? this.rollingUpdate.build() : null;
    }

    @Override
    public RollingUpdate buildRollingUpdate() {
        return this.rollingUpdate != null ? this.rollingUpdate.build() : null;
    }

    @Override
    public A withRollingUpdate(RollingUpdate rollingUpdate) {
        this._visitables.get((Object)"rollingUpdate").remove(this.rollingUpdate);
        if (rollingUpdate != null) {
            this.rollingUpdate = new RollingUpdateBuilder(rollingUpdate);
            this._visitables.get((Object)"rollingUpdate").add(this.rollingUpdate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRollingUpdate() {
        return this.rollingUpdate != null;
    }

    @Override
    public A withNewRollingUpdate(String maxUnavailable, String maxSurge) {
        return this.withRollingUpdate(new RollingUpdate(maxUnavailable, maxSurge));
    }

    @Override
    public KubernetesConfigFluent.RollingUpdateNested<A> withNewRollingUpdate() {
        return new RollingUpdateNestedImpl();
    }

    @Override
    public KubernetesConfigFluent.RollingUpdateNested<A> withNewRollingUpdateLike(RollingUpdate item) {
        return new RollingUpdateNestedImpl(item);
    }

    @Override
    public KubernetesConfigFluent.RollingUpdateNested<A> editRollingUpdate() {
        return this.withNewRollingUpdateLike(this.getRollingUpdate());
    }

    @Override
    public KubernetesConfigFluent.RollingUpdateNested<A> editOrNewRollingUpdate() {
        return this.withNewRollingUpdateLike(this.getRollingUpdate() != null ? this.getRollingUpdate() : new RollingUpdateBuilder().build());
    }

    @Override
    public KubernetesConfigFluent.RollingUpdateNested<A> editOrNewRollingUpdateLike(RollingUpdate item) {
        return this.withNewRollingUpdateLike(this.getRollingUpdate() != null ? this.getRollingUpdate() : item);
    }

    @Override
    public Boolean getHeadless() {
        return this.headless;
    }

    @Override
    public A withHeadless(Boolean headless) {
        this.headless = headless;
        return (A)this;
    }

    @Override
    public Boolean hasHeadless() {
        return this.headless != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesConfigFluentImpl that = (KubernetesConfigFluentImpl)o;
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.deploymentStrategy != null ? !this.deploymentStrategy.equals((Object)that.deploymentStrategy) : that.deploymentStrategy != null) {
            return false;
        }
        if (this.rollingUpdate != null ? !this.rollingUpdate.equals(that.rollingUpdate) : that.rollingUpdate != null) {
            return false;
        }
        return !(this.headless != null ? !this.headless.equals(that.headless) : that.headless != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.initContainers, this.replicas, this.deploymentStrategy, this.rollingUpdate, this.headless, super.hashCode()});
    }

    public class RollingUpdateNestedImpl<N>
    extends RollingUpdateFluentImpl<KubernetesConfigFluent.RollingUpdateNested<N>>
    implements KubernetesConfigFluent.RollingUpdateNested<N>,
    Nested<N> {
        RollingUpdateBuilder builder;

        RollingUpdateNestedImpl(RollingUpdate item) {
            this.builder = new RollingUpdateBuilder(this, item);
        }

        RollingUpdateNestedImpl() {
            this.builder = new RollingUpdateBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesConfigFluentImpl.this.withRollingUpdate(this.builder.build());
        }

        @Override
        public N endRollingUpdate() {
            return this.and();
        }
    }

    public class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<KubernetesConfigFluent.InitContainersNested<N>>
    implements KubernetesConfigFluent.InitContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        InitContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesConfigFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }
}

