/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class LabelFluentImpl<A extends LabelFluent<A>>
extends BaseFluent<A>
implements LabelFluent<A> {
    private String key;
    private String value;
    private List<String> kinds = new ArrayList<String>();

    public LabelFluentImpl() {
    }

    public LabelFluentImpl(Label instance) {
        this.withKey(instance.getKey());
        this.withValue(instance.getValue());
        this.withKinds(instance.getKinds());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    @Override
    public Boolean hasKey() {
        return this.key != null;
    }

    @Override
    @Deprecated
    public A withNewKey(String arg0) {
        return this.withKey(new String(arg0));
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    @Deprecated
    public A withNewValue(String arg0) {
        return this.withValue(new String(arg0));
    }

    @Override
    public A withKinds(String ... kinds) {
        if (this.kinds != null) {
            this.kinds.clear();
        }
        if (kinds != null) {
            for (String item : kinds) {
                this.addToKinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getKinds() {
        int size = this.kinds != null ? this.kinds.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.kinds) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToKinds(Integer index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.add(index, item);
        return (A)this;
    }

    @Override
    public A setToKinds(Integer index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.set(index, item);
        return (A)this;
    }

    @Override
    public A addToKinds(String ... items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToKinds(Collection<String> items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromKinds(String ... items) {
        for (String item : items) {
            if (this.kinds == null) continue;
            this.kinds.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKinds(Collection<String> items) {
        for (String item : items) {
            if (this.kinds == null) continue;
            this.kinds.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKinds() {
        return this.kinds != null && !this.kinds.isEmpty();
    }

    @Override
    public A addNewKind(String arg0) {
        return this.addToKinds(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelFluentImpl that = (LabelFluentImpl)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.kinds != null ? !this.kinds.equals(that.kinds) : that.kinds != null);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.kinds, super.hashCode());
    }
}

