/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import java.util.Map;
import java.util.function.Predicate;

public class ApplyPort
extends Configurator<BaseConfigFluent<?>> {
    private static final String FALLBACK_PORT_NAME = "http";
    private static final String DEFAULT_PATH = "/";
    private final Port port;
    private final Map<String, Integer> nameMappings;

    public ApplyPort(Port port) {
        this(port, Ports.webPortNameMappings());
    }

    public ApplyPort(Port port, Map<String, Integer> nameMappings) {
        this.port = port;
        this.nameMappings = nameMappings;
    }

    public void visit(BaseConfigFluent<?> config) {
        Port updated = Ports.populateHostPort((Port)this.port);
        Predicate<PortBuilder> matchingPortName = p -> updated.getName().equals(p.getName());
        Predicate<PortBuilder> matchingHostPort = p -> updated.getHostPort() != null && updated.getHostPort().equals(p.getHostPort());
        boolean matchFound = false;
        if (config.hasMatchingPort(matchingPortName).booleanValue()) {
            matchFound = true;
            this.applyPath(config, updated, matchingPortName);
            this.applyContainerPort(config, updated, matchingPortName);
        }
        if (config.hasMatchingPort(matchingHostPort).booleanValue()) {
            matchFound = true;
            this.applyPath(config, updated, matchingHostPort);
            this.applyContainerPort(config, updated, matchingHostPort);
        }
        if (!matchFound) {
            config.addToPorts(updated);
        }
    }

    private void applyPath(BaseConfigFluent<?> config, Port port) {
        this.applyPath(config, port, p -> port.getName().equals(p.getName()));
    }

    private void applyPath(BaseConfigFluent<?> config, Port port, Predicate<PortBuilder> predicate) {
        if (Strings.isNotNullOrEmpty((String)port.getPath()) && !DEFAULT_PATH.equals(port.getPath())) {
            ((BaseConfigFluent.PortsNested)config.editMatchingPort(predicate).withPath(port.getPath())).endPort();
        }
    }

    private void applyContainerPort(BaseConfigFluent<?> config, Port port) {
        this.applyPath(config, port, p -> port.getName().equals(p.getName()));
    }

    private void applyContainerPort(BaseConfigFluent<?> config, Port port, Predicate<PortBuilder> predicate) {
        if (port.getContainerPort() != 0) {
            ((BaseConfigFluent.PortsNested)config.editMatchingPort(predicate).withContainerPort(port.getContainerPort())).endPort();
        }
    }

    private void applyHostPort(BaseConfigFluent<?> config, Port port) {
        this.applyPath(config, port, p -> port.getHostPort() != null && port.getHostPort().equals(p.getHostPort()));
    }

    private void applyHostPort(BaseConfigFluent<?> config, Port port, Predicate<PortBuilder> matchingHostPort) {
        if (port.getHostPort() != null && port.getHostPort() != 0 && !config.hasMatchingPort(matchingHostPort).booleanValue()) {
            ((BaseConfigFluent.PortsNested)config.editMatchingPort(matchingHostPort).withHostPort(port.getHostPort())).endPort();
        }
    }
}

