/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;

@Description(value="Add mount to the specified container.")
public class AddMountDecorator
extends ApplicationContainerDecorator<ContainerBuilder> {
    private final Mount mount;

    public AddMountDecorator(Mount mount) {
        this(ANY, ANY, mount);
    }

    public AddMountDecorator(String deployment, String container, Mount mount) {
        super(deployment, container);
        this.mount = mount;
    }

    @Override
    public void andThenVisit(ContainerBuilder container) {
        container.removeMatchingFromVolumeMounts(m -> this.mount.getName().equals(m.getName()));
        ((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)container.addNewVolumeMount().withName(this.mount.getName())).withMountPath(this.mount.getPath())).withSubPath(this.mount.getSubPath())).withReadOnly(Boolean.valueOf(this.mount.isReadOnly()))).endVolumeMount();
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class, AddInitContainerDecorator.class};
    }
}

