/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.util.Objects;

public class ApplicationConfigurationFluent<A extends ApplicationConfigurationFluent<A>>
extends ConfigurationFluent<A> {
    private String partOf;
    private String name;
    private String version;

    public ApplicationConfigurationFluent() {
    }

    public ApplicationConfigurationFluent(ApplicationConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ApplicationConfiguration instance) {
        ApplicationConfiguration applicationConfiguration = instance = instance != null ? instance : new ApplicationConfiguration();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withPartOf(instance.getPartOf());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
        }
    }

    public String getPartOf() {
        return this.partOf;
    }

    public A withPartOf(String partOf) {
        this.partOf = partOf;
        return (A)((Object)this);
    }

    public boolean hasPartOf() {
        return this.partOf != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationConfigurationFluent that = (ApplicationConfigurationFluent)((Object)o);
        if (!Objects.equals(this.partOf, that.partOf)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partOf, this.name, this.version, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.partOf != null) {
            sb.append("partOf:");
            sb.append(this.partOf + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }
}

