/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.adapter.ContainerAdapter;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Predicates;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import java.util.function.Predicate;

@Description(value="A decorator that adds a the container if no matching container found")
public class ApplyApplicationContainerDecorator
extends NamedResourceDecorator<PodSpecBuilder> {
    private final io.dekorate.kubernetes.config.Container container;

    public ApplyApplicationContainerDecorator(io.dekorate.kubernetes.config.Container container) {
        this(ANY, container);
    }

    public ApplyApplicationContainerDecorator(String deployment, io.dekorate.kubernetes.config.Container container) {
        super(deployment);
        this.container = container;
    }

    @Override
    public void andThenVisit(PodSpecBuilder podSpec, ObjectMeta resourceMeta) {
        Predicate p = Predicates.builderMatches((io.dekorate.kubernetes.config.Container)this.container);
        if (!podSpec.hasMatchingContainer(p)) {
            podSpec.addToContainers(new Container[]{ContainerAdapter.adapt(this.container)});
        } else {
            ContainerBuilder builder = new ContainerBuilder(podSpec.buildMatchingContainer(p));
            podSpec.removeMatchingFromContainers(p);
            podSpec.addToContainers(new Container[]{((ContainerBuilder)builder.withName(this.container.getName())).build()});
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

