/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import java.util.Map;
import java.util.Objects;

public class S2iBuildConfig
extends ImageConfiguration {
    private String builderImage;
    private Env[] buildEnvVars = new Env[0];
    private Boolean autoDeployEnabled;

    public S2iBuildConfig() {
    }

    public S2iBuildConfig(Project project, Map<ConfigKey, Object> attributes, Boolean enabled, String registry, String group, String name, String version, String image, String dockerFile, Boolean autoBuildEnabled, Boolean autoPushEnabled, Boolean autoLoadEnabled, String builderImage, Env[] buildEnvVars, Boolean autoDeployEnabled) {
        super(project, attributes, enabled, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled, autoLoadEnabled);
        this.builderImage = builderImage;
        this.buildEnvVars = buildEnvVars != null ? buildEnvVars : new Env[]{};
        this.autoDeployEnabled = autoDeployEnabled;
    }

    public String getBuilderImage() {
        return this.builderImage;
    }

    public Env[] getBuildEnvVars() {
        return this.buildEnvVars;
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled != null && this.autoDeployEnabled != false;
    }

    public static S2iBuildConfigBuilder newS2iBuildConfigBuilder() {
        return new S2iBuildConfigBuilder();
    }

    public static S2iBuildConfigBuilder newS2iBuildConfigBuilderFromDefaults() {
        return (S2iBuildConfigBuilder)((S2iBuildConfigBuilder)((S2iBuildConfigBuilder)((S2iBuildConfigBuilder)((S2iBuildConfigBuilder)((S2iBuildConfigBuilder)new S2iBuildConfigBuilder().withEnabled(true)).withDockerFile("Dockerfile")).withBuilderImage("fabric8/s2i-java:2.3")).withAutoPushEnabled(false)).withAutoBuildEnabled(false)).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S2iBuildConfig that = (S2iBuildConfig)((Object)o);
        if (this.builderImage != null ? !this.builderImage.equals(that.builderImage) : that.builderImage != null) {
            return false;
        }
        if (this.buildEnvVars != null ? !this.buildEnvVars.equals(that.buildEnvVars) : that.buildEnvVars != null) {
            return false;
        }
        return !(this.autoDeployEnabled != null ? !this.autoDeployEnabled.equals(that.autoDeployEnabled) : that.autoDeployEnabled != null);
    }

    public int hashCode() {
        return Objects.hash(this.builderImage, this.buildEnvVars, this.autoDeployEnabled, super.hashCode());
    }
}

