/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.cameramanager;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import io.dyte.core.models.DyteVideoDevice;
import io.dyte.core.models.VideoDeviceType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/dyte/core/cameramanager/DyteCameraManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "getCameraManager", "()Landroid/hardware/camera2/CameraManager;", "getCameraDevices", "", "Lio/dyte/core/models/DyteVideoDevice;", "shared_debug"})
public final class DyteCameraManager {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraManager cameraManager;

    public DyteCameraManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        this.cameraManager = (CameraManager)object;
    }

    @NotNull
    public final CameraManager getCameraManager() {
        return this.cameraManager;
    }

    @NotNull
    public final List<DyteVideoDevice> getCameraDevices() {
        ArrayList<DyteVideoDevice> devices = new ArrayList<DyteVideoDevice>();
        String[] stringArray = this.cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cameraManager.cameraIdList");
        Object[] $this$forEach$iv = stringArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CameraCharacteristics cameraCharacteristics;
            String cameraId = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.cameraManager.getCameraCharacteristics(cameraId), (String)"cameraManager.getCameraCharacteristics(cameraId)");
            Integer n = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            if (n == null) {
                n = -1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"cameraCharacteristics.ge\u2026istics.LENS_FACING) ?: -1");
            int lensFacing = ((Number)n).intValue();
            switch (lensFacing) {
                case 0: {
                    Intrinsics.checkNotNullExpressionValue((Object)cameraId, (String)"cameraId");
                    devices.add(new DyteVideoDevice(cameraId, VideoDeviceType.FRONT));
                    break;
                }
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)cameraId, (String)"cameraId");
                    devices.add(new DyteVideoDevice(cameraId, VideoDeviceType.REAR));
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)cameraId, (String)"cameraId");
                    devices.add(new DyteVideoDevice(cameraId, VideoDeviceType.EXTERNAL));
                }
            }
        }
        return devices;
    }
}

