/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.chat;

import io.dyte.core.chat.FileSocketChatMessage;
import io.dyte.core.chat.ImageSocketChatMessage;
import io.dyte.core.chat.SocketChatMessage;
import io.dyte.core.chat.TextSocketChatMessage;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketChatMessage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import socket.chat.ChatMessage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/dyte/core/chat/SocketChatMessageMapper;", "", "()V", "fromSocketIoChatMessage", "Lio/dyte/core/chat/SocketChatMessage;", "socketIoChatMessage", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketChatMessage;", "fromSocketServiceChatMessage", "socketServerChatMessage", "Lsocket/chat/ChatMessage;", "shared_debug"})
public final class SocketChatMessageMapper {
    @NotNull
    public static final SocketChatMessageMapper INSTANCE = new SocketChatMessageMapper();

    private SocketChatMessageMapper() {
    }

    @NotNull
    public final SocketChatMessage fromSocketIoChatMessage(@NotNull WebSocketChatMessage socketIoChatMessage) {
        Intrinsics.checkNotNullParameter((Object)socketIoChatMessage, (String)"socketIoChatMessage");
        switch (socketIoChatMessage.getType()) {
            case 0: {
                String string = socketIoChatMessage.getMessage();
                if (string == null) {
                    throw new IllegalStateException("Text message is null".toString());
                }
                Long l = socketIoChatMessage.getTime();
                if (l == null) {
                    throw new IllegalStateException("Message time is null".toString());
                }
                return new TextSocketChatMessage(string, socketIoChatMessage.getUserId(), socketIoChatMessage.getDisplayName(), l, "", false, false, null, false, null, 992, null);
            }
            case 1: {
                String string = socketIoChatMessage.getLink();
                if (string == null) {
                    string = "";
                }
                Long l = socketIoChatMessage.getTime();
                if (l == null) {
                    throw new IllegalStateException("Message time is null".toString());
                }
                return new ImageSocketChatMessage(string, socketIoChatMessage.getUserId(), socketIoChatMessage.getDisplayName(), l, "", false, false, null, false, null, 992, null);
            }
            case 2: {
                String string = socketIoChatMessage.getName();
                if (string == null) {
                    string = "";
                }
                Long l = socketIoChatMessage.getSize();
                long l2 = l != null ? l : 0L;
                String string2 = socketIoChatMessage.getLink();
                if (string2 == null) {
                    string2 = "";
                }
                Long l3 = socketIoChatMessage.getTime();
                if (l3 == null) {
                    throw new IllegalStateException("Message time is null".toString());
                }
                return new FileSocketChatMessage(string, l2, string2, socketIoChatMessage.getUserId(), socketIoChatMessage.getDisplayName(), l3, "", false, false, null, false, null, 3968, null);
            }
        }
        throw new UnsupportedOperationException("Message type " + socketIoChatMessage.getType() + " not supported");
    }

    @NotNull
    public final SocketChatMessage fromSocketServiceChatMessage(@NotNull ChatMessage socketServerChatMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketServerChatMessage), (String)"socketServerChatMessage");
        switch (socketServerChatMessage.getPayload_type()) {
            case 0: {
                return new TextSocketChatMessage(socketServerChatMessage.getPayload(), socketServerChatMessage.getUser_id(), socketServerChatMessage.getDisplay_name(), socketServerChatMessage.getCreated_at(), socketServerChatMessage.getChat_id(), false, false, null, false, null, 992, null);
            }
            case 1: {
                return new ImageSocketChatMessage(socketServerChatMessage.getPayload(), socketServerChatMessage.getUser_id(), socketServerChatMessage.getDisplay_name(), socketServerChatMessage.getCreated_at(), socketServerChatMessage.getChat_id(), false, false, null, false, null, 992, null);
            }
            case 2: {
                JsonObject fileMessagePayload = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(socketServerChatMessage.getPayload()));
                return new FileSocketChatMessage(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)fileMessagePayload), (Object)"name"))).getContent(), JsonElementKt.getLong((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)fileMessagePayload), (Object)"size")))), JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)fileMessagePayload), (Object)"link"))).getContent(), socketServerChatMessage.getUser_id(), socketServerChatMessage.getDisplay_name(), socketServerChatMessage.getCreated_at(), socketServerChatMessage.getChat_id(), false, false, null, false, null, 3968, null);
            }
        }
        throw new UnsupportedOperationException("Message type " + socketServerChatMessage.getPayload_type() + " not supported");
    }
}

