/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.controllers;

import android.net.Uri;
import io.dyte.core.chat.ChatSocketHandler;
import io.dyte.core.chat.FileSocketChatMessage;
import io.dyte.core.chat.ImageSocketChatMessage;
import io.dyte.core.chat.SocketChatMessage;
import io.dyte.core.chat.TextSocketChatMessage;
import io.dyte.core.controllers.BaseController;
import io.dyte.core.controllers.ChatController;
import io.dyte.core.controllers.DyteEventType;
import io.dyte.core.controllers.IChatController;
import io.dyte.core.controllers.IControllerContainer;
import io.dyte.core.feat.DyteChatMessage;
import io.dyte.core.feat.DyteFileMessage;
import io.dyte.core.feat.DyteImageMessage;
import io.dyte.core.feat.DyteTextMessage;
import io.dyte.core.network.PresignedUrlApiService;
import io.dyte.core.network.models.PresignedUrlResponse;
import io.dyte.core.platform.IDytePlatformUtils;
import io.dyte.core.platform.PlatformFile;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketChatMessage;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketChatMessagesModel;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientJvmKt;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.client.plugins.logging.Logger;
import io.ktor.client.plugins.logging.LoggerKt;
import io.ktor.client.plugins.logging.Logging;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.NullBody;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u0003:\u00018B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\u0011\u0010%\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001cH\u0016J\u0014\u0010)\u001a\u00020\u001f2\n\u0010*\u001a\u00060+j\u0002`,H\u0016J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002J\u0014\u00102\u001a\u00020\u001f2\n\u00103\u001a\u00060+j\u0002`,H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u00104\u001a\u00020.H\u0016J\u0010\u00105\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00106\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020.H\u0016J\b\u00107\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"Lio/dyte/core/controllers/ChatController;", "Lio/dyte/core/controllers/IChatController;", "Lio/dyte/core/controllers/BaseController;", "Lio/dyte/core/chat/ChatSocketHandler$OnMessageListener;", "controllerContainer", "Lio/dyte/core/controllers/IControllerContainer;", "chatSocketHandler", "Lio/dyte/core/chat/ChatSocketHandler;", "presignedUrlApiService", "Lio/dyte/core/network/PresignedUrlApiService;", "(Lio/dyte/core/controllers/IControllerContainer;Lio/dyte/core/chat/ChatSocketHandler;Lio/dyte/core/network/PresignedUrlApiService;)V", "httpClient", "Lio/ktor/client/HttpClient;", "getHttpClient", "()Lio/ktor/client/HttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "messages", "Ljava/util/ArrayList;", "Lio/dyte/core/feat/DyteChatMessage;", "Lkotlin/collections/ArrayList;", "getMessages", "()Ljava/util/ArrayList;", "addMessage", "chatMessage", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketChatMessage;", "convertToDyteChatMessage", "socketChatMessage", "Lio/dyte/core/chat/SocketChatMessage;", "createPrivateHttpClient", "handleChatMessages", "", "dyteChatMessages", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketChatMessagesModel;", "handleNewChatMessage", "dyteChatMessage", "init", "loadChatMessages", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onMessageToRoom", "message", "sendFileMessage", "fileUri", "Landroid/net/Uri;", "Lio/dyte/core/platform/Uri;", "filePath", "", "sendFileMessageInternal", "file", "Lio/dyte/core/platform/PlatformFile;", "sendImageMessage", "imageUri", "imagePath", "sendImageMessageInternal", "sendMessage", "setOnMessageListener", "Companion", "shared_debug"})
public final class ChatController
extends BaseController
implements IChatController,
ChatSocketHandler.OnMessageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatSocketHandler chatSocketHandler;
    @NotNull
    private final PresignedUrlApiService presignedUrlApiService;
    @NotNull
    private final Lazy httpClient$delegate;
    @NotNull
    private final ArrayList<DyteChatMessage> messages;
    @NotNull
    private static final List<String> ACCEPTED_IMAGE_TYPES;

    public ChatController(@NotNull IControllerContainer controllerContainer, @NotNull ChatSocketHandler chatSocketHandler, @NotNull PresignedUrlApiService presignedUrlApiService) {
        Intrinsics.checkNotNullParameter((Object)controllerContainer, (String)"controllerContainer");
        Intrinsics.checkNotNullParameter((Object)chatSocketHandler, (String)"chatSocketHandler");
        Intrinsics.checkNotNullParameter((Object)presignedUrlApiService, (String)"presignedUrlApiService");
        super(controllerContainer);
        this.chatSocketHandler = chatSocketHandler;
        this.presignedUrlApiService = presignedUrlApiService;
        this.httpClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpClient>(this){
            final /* synthetic */ ChatController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HttpClient invoke() {
                return ChatController.access$createPrivateHttpClient(this.this$0);
            }
        }));
        this.messages = new ArrayList();
    }

    private final HttpClient getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClient)lazy.getValue();
    }

    @NotNull
    public ArrayList<DyteChatMessage> getMessages() {
        return this.messages;
    }

    @Override
    public void init() {
        this.setOnMessageListener();
    }

    private final void setOnMessageListener() {
        this.chatSocketHandler.setOnMessageListener(this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object loadChatMessages(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof loadChatMessages.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChatController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadChatMessages((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.chatSocketHandler.getChatMessages((Continuation<? super List<? extends SocketChatMessage>>)$continuation);
                ** if (v0 != var9_4) goto lbl19
lbl18:
                // 1 sources

                return var9_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (ChatController)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    socketChatMessages = (List)v0;
                    dyteChatMessages = new ArrayList<DyteChatMessage>();
                    for (SocketChatMessage message : socketChatMessages) {
                        try {
                            dyteChatMessage = this.convertToDyteChatMessage(message);
                            dyteChatMessages.add(dyteChatMessage);
                        }
                        catch (Exception e) {
                            this.getControllerContainer().getLoggerController().traceError("ChatController parse message error: " + e + ", " + message);
                        }
                    }
                    this.getMessages().clear();
                    this.getMessages().addAll((Collection)dyteChatMessages);
                    if (((Collection)dyteChatMessages).isEmpty() == false) {
                        this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnMeetingMessagesReceived((List<? extends DyteChatMessage>)dyteChatMessages));
                    }
                }
                catch (Exception e) {
                    this.getControllerContainer().getLoggerController().traceError("ChatController loadChatMessages error: " + e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void handleChatMessages(@NotNull WebSocketChatMessagesModel dyteChatMessages) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)dyteChatMessages, (String)"dyteChatMessages");
            List<WebSocketChatMessage> list = dyteChatMessages.getMessages();
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WebSocketChatMessage it = (WebSocketChatMessage)element$iv;
                boolean bl = false;
                DyteChatMessage dyteChatMessage = this.addMessage(it);
                if (dyteChatMessage == null) continue;
                this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnNewMeetingMessageReceived(dyteChatMessage));
            }
        }
    }

    @Override
    public void handleNewChatMessage(@NotNull WebSocketChatMessage dyteChatMessage) {
        Intrinsics.checkNotNullParameter((Object)dyteChatMessage, (String)"dyteChatMessage");
        DyteChatMessage message = this.addMessage(dyteChatMessage);
        if (message != null) {
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnNewMeetingMessageReceived(message));
        }
    }

    @Override
    public void onMessageToRoom(@NotNull SocketChatMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            DyteChatMessage dyteChatMessage = this.convertToDyteChatMessage(message);
            ((ArrayList)this.getMessages()).add(dyteChatMessage);
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnNewMeetingMessageReceived(dyteChatMessage));
        }
        catch (Exception e) {
            this.getControllerContainer().getLoggerController().traceError("ChatController parse message error: " + e + ", " + message);
        }
    }

    private final DyteChatMessage addMessage(WebSocketChatMessage chatMessage) {
        DyteChatMessage dyteChatMessage = null;
        switch (chatMessage.getType()) {
            case 0: {
                String string = chatMessage.getUserId();
                String string2 = chatMessage.getDisplayName();
                String string3 = chatMessage.getMessage();
                if (string3 == null) {
                    String string4 = "Required value was null.";
                    throw new IllegalArgumentException(string4.toString());
                }
                IDytePlatformUtils iDytePlatformUtils = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils();
                Long l = chatMessage.getTime();
                Intrinsics.checkNotNull((Object)l);
                dyteChatMessage = new DyteTextMessage(string, string2, false, null, string3, iDytePlatformUtils.getUserDisplayableTime(l));
                ((ArrayList)this.getMessages()).add(dyteChatMessage);
                break;
            }
            case 1: {
                String string = chatMessage.getUserId();
                String string5 = chatMessage.getDisplayName();
                String string6 = chatMessage.getLink();
                if (string6 == null) {
                    string6 = "";
                }
                IDytePlatformUtils iDytePlatformUtils = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils();
                Long l = chatMessage.getTime();
                Intrinsics.checkNotNull((Object)l);
                dyteChatMessage = new DyteImageMessage(string, string5, false, null, string6, iDytePlatformUtils.getUserDisplayableTime(l));
                ((ArrayList)this.getMessages()).add(dyteChatMessage);
                break;
            }
            case 2: {
                String string = chatMessage.getUserId();
                String string7 = chatMessage.getDisplayName();
                String string8 = chatMessage.getName();
                if (string8 == null) {
                    string8 = "";
                }
                IDytePlatformUtils iDytePlatformUtils = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils();
                Long l = chatMessage.getTime();
                Intrinsics.checkNotNull((Object)l);
                String string9 = iDytePlatformUtils.getUserDisplayableTime(l);
                String string10 = chatMessage.getLink();
                if (string10 == null) {
                    string10 = "";
                }
                Long l2 = chatMessage.getSize();
                dyteChatMessage = new DyteFileMessage(string, string7, false, null, string8, string9, string10, l2 != null ? l2 : 0L);
                ((ArrayList)this.getMessages()).add(dyteChatMessage);
                break;
            }
            default: {
                this.getControllerContainer().getLoggerController().traceError("message type not supported " + chatMessage);
            }
        }
        return dyteChatMessage;
    }

    @Override
    public void sendMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getControllerContainer().getLoggerController().traceLog("DyteChat.sendTextMessage");
        if (!this.getControllerContainer().getPresetController().canSendChatText()) {
            this.getControllerContainer().getLoggerController().traceError("sendTextMessage::public_chat_permission_denied");
            throw new UnsupportedOperationException("not allowed to send text message");
        }
        if (((CharSequence)message).length() == 0) {
            this.getControllerContainer().getLoggerController().traceError("sendTextMessage::message_can_not_be_empty");
            throw new IllegalArgumentException("message can not be empty");
        }
        BuildersKt.launch$default((CoroutineScope)this.getSerialScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ ChatController this$0;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatController.access$getChatSocketHandler$p(this.this$0).sendTextMessage(this.$message, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void sendFileMessage(@NotNull Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        this.getControllerContainer().getLoggerController().traceLog("DyteChat.sendFileMessage");
        if (!this.getControllerContainer().getPresetController().canSendChatFile()) {
            this.getControllerContainer().getLoggerController().traceLog("sendFileMessage::chat_permission_denied");
            throw new UnsupportedOperationException("not allowed to send file message");
        }
        PlatformFile platformFile = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getPlatformFile(fileUri);
        if (platformFile == null) {
            ChatController $this$sendFileMessage_u24lambda_u241 = this;
            boolean bl = false;
            $this$sendFileMessage_u24lambda_u241.getControllerContainer().getLoggerController().traceLog("sendFileMessage::chat_read_file_failed");
            throw new Exception("Requested file doesn't exist or is missing read permission");
        }
        PlatformFile file = platformFile;
        this.sendFileMessageInternal(file);
    }

    @Override
    public void sendFileMessage(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getControllerContainer().getLoggerController().traceLog("DyteChat.sendFileMessage");
        if (!this.getControllerContainer().getPresetController().canSendChatFile()) {
            this.getControllerContainer().getLoggerController().traceLog("sendFileMessage::chat_permission_denied");
            throw new UnsupportedOperationException("not allowed to send file message");
        }
        PlatformFile platformFile = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getPlatformFile(filePath);
        if (platformFile == null) {
            ChatController $this$sendFileMessage_u24lambda_u242 = this;
            boolean bl = false;
            $this$sendFileMessage_u24lambda_u242.getControllerContainer().getLoggerController().traceLog("sendFileMessage::chat_read_file_failed");
            throw new Exception("Requested file doesn't exist or is missing read permission");
        }
        PlatformFile file = platformFile;
        this.sendFileMessageInternal(file);
    }

    @Override
    public void sendImageMessage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.getControllerContainer().getLoggerController().traceLog("DyteChat.sendImageMessage");
        if (!this.getControllerContainer().getPresetController().canSendChatFile()) {
            this.getControllerContainer().getLoggerController().traceError("sendImageMessage::permission_denied");
            throw new UnsupportedOperationException("not allowed to send file message");
        }
        PlatformFile platformFile = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getPlatformFile(imageUri);
        if (platformFile == null) {
            ChatController $this$sendImageMessage_u24lambda_u243 = this;
            boolean bl = false;
            $this$sendImageMessage_u24lambda_u243.getControllerContainer().getLoggerController().traceError("sendImageMessage::required_argument_image_can_not_be_empty");
            throw new Exception("Requested image doesn't exist or is missing read permission");
        }
        PlatformFile file = platformFile;
        this.sendImageMessageInternal(file);
    }

    @Override
    public void sendImageMessage(@NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        this.getControllerContainer().getLoggerController().traceLog("DyteChat.sendImageMessage");
        if (!this.getControllerContainer().getPresetController().canSendChatFile()) {
            this.getControllerContainer().getLoggerController().traceError("sendImageMessage::permission_denied");
            throw new UnsupportedOperationException("not allowed to send image message");
        }
        PlatformFile platformFile = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getPlatformFile(imagePath);
        if (platformFile == null) {
            throw new Exception("Requested image doesn't exist or is missing read permission");
        }
        PlatformFile file = platformFile;
        this.sendImageMessageInternal(file);
    }

    private final void sendImageMessageInternal(PlatformFile file) {
        if (!CollectionsKt.contains((Iterable)ACCEPTED_IMAGE_TYPES, (Object)file.getMimeType())) {
            this.getControllerContainer().getLoggerController().traceError("sendImageMessage::image_type_not_supported");
            throw new UnsupportedOperationException("Unsupported image file found -> " + file.getMimeType());
        }
        BuildersKt.launch$default((CoroutineScope)this.getSerialScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, null){
            Object L$0;
            int label;
            final /* synthetic */ ChatController this$0;
            final /* synthetic */ PlatformFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var23_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ChatController.access$getPresignedUrlApiService$p(this.this$0).getPresignedUrl2(this.$file.getName(), this.this$0.getControllerContainer().getMetaController().getRoomUuid(), (Continuation<? super PresignedUrlResponse>)((Continuation)this));
                        if (v0 == var23_2) {
                            return var23_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        putLocation = (v1 = (presignedUrl = (PresignedUrlResponse)v0)) != null && (v1 = v1.getData()) != null ? v1.getPutLocation() : null;
                        v2 = presignedUrl;
                        getLocation = v2 != null && (v2 = v2.getData()) != null ? v2.getGetLocation() : null;
                        var5_6 = putLocation;
                        if (var5_6 == null || StringsKt.isBlank((CharSequence)var5_6) != false || (var5_6 = (CharSequence)getLocation) == null || StringsKt.isBlank((CharSequence)var5_6) != false) {
                            this.this$0.getControllerContainer().getLoggerController().traceError("sendImageMessage::failure_get_presigned_url");
                            throw new Exception("Failed to upload image");
                        }
                        var6_7 = ChatController.access$getHttpClient(this.this$0);
                        var7_8 = this.$file;
                        $i$f$put = false;
                        var9_11 = $this$put$iv;
                        $this$invokeSuspend_u24lambda_u240 = var10_12 = new HttpRequestBuilder();
                        $i$a$-put-ChatController$sendImageMessageInternal$1$uploadImageResponse$1 = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$invokeSuspend_u24lambda_u240, (String)putLocation);
                        var13_15 = $this$invokeSuspend_u24lambda_u240;
                        body$iv = var7_8.getContent();
                        $i$f$setBody = false;
                        var16_18 = body$iv;
                        if (var16_18 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            $i$f$typeInfo = false;
                            kType$iv$iv = Reflection.typeOf(byte[].class);
                            reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(byte[].class), (KType)kType$iv$iv));
                        } else if (var16_18 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)body$iv);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)body$iv);
                            $i$f$typeInfo = false;
                            kType$iv$iv = Reflection.typeOf(byte[].class);
                            reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(byte[].class), (KType)kType$iv$iv));
                        }
                        builder$iv$iv = var10_12;
                        $i$f$put = false;
                        builder$iv$iv.setMethod(HttpMethod.Companion.getPut());
                        $this$request$iv$iv$iv = $this$put$iv$iv;
                        $i$f$request = false;
                        this.L$0 = getLocation;
                        this.label = 2;
                        v3 = new HttpStatement(builder$iv$iv, (HttpClient)$this$request$iv$iv$iv).execute((Continuation)this);
                        if (v3 == var23_2) {
                            return var23_2;
                        }
                        ** GOTO lbl70
                    }
                    case 2: {
                        $i$f$put = false;
                        $i$f$put = false;
                        $i$f$request = false;
                        getLocation = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl70:
                        // 2 sources

                        uploadImageResponse = (HttpResponse)v3;
                        if (uploadImageResponse.getStatus().getValue() != HttpStatusCode.Companion.getOK().getValue()) {
                            this.this$0.getControllerContainer().getLoggerController().traceError("sendImageMessage::failure_upload_image_file");
                            throw new Exception("Failed to upload image");
                        }
                        this.L$0 = null;
                        this.label = 3;
                        v4 = ChatController.access$getChatSocketHandler$p(this.this$0).sendImageMessage(getLocation, (Continuation<? super Unit>)((Continuation)this));
                        if (v4 == var23_2) {
                            return var23_2;
                        }
                        ** GOTO lbl83
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl83:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void sendFileMessageInternal(PlatformFile file) {
        BuildersKt.launch$default((CoroutineScope)this.getSerialScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, null){
            Object L$0;
            int label;
            final /* synthetic */ ChatController this$0;
            final /* synthetic */ PlatformFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var27_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ChatController.access$getPresignedUrlApiService$p(this.this$0).getPresignedUrl2(this.$file.getName(), this.this$0.getControllerContainer().getMetaController().getRoomUuid(), (Continuation<? super PresignedUrlResponse>)((Continuation)this));
                        if (v0 == var27_2) {
                            return var27_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        putLocation = (v1 = (presignedUrl = (PresignedUrlResponse)v0)) != null && (v1 = v1.getData()) != null ? v1.getPutLocation() : null;
                        v2 = presignedUrl;
                        getLocation = v2 != null && (v2 = v2.getData()) != null ? v2.getGetLocation() : null;
                        var5_6 = putLocation;
                        if (var5_6 == null || StringsKt.isBlank((CharSequence)var5_6) != false || (var5_6 = (CharSequence)getLocation) == null || StringsKt.isBlank((CharSequence)var5_6) != false) {
                            this.this$0.getControllerContainer().getLoggerController().traceError("sendFileMessage::failure_get_presigned_url");
                            throw new Exception("Failed to upload file");
                        }
                        var6_7 = ChatController.access$getHttpClient(this.this$0);
                        var7_8 = this.$file;
                        $i$f$put = false;
                        $this$put$iv$iv = $this$put$iv;
                        $i$f$put = false;
                        var11_14 = $this$put$iv$iv;
                        $this$put_u24lambda_u246$iv = var12_15 = new HttpRequestBuilder();
                        $i$a$-put-BuildersKt$put$5$iv = false;
                        HttpRequestKt.url((HttpRequestBuilder)$this$put_u24lambda_u246$iv, (String)putLocation);
                        $this$invokeSuspend_u24lambda_u240 = $this$put_u24lambda_u246$iv;
                        $i$a$-put-ChatController$sendFileMessageInternal$1$uploadFileResponse$1 = false;
                        UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (String)HttpHeaders.INSTANCE.getContentType(), (Object)var7_8.getMimeType());
                        var17_20 = $this$invokeSuspend_u24lambda_u240;
                        body$iv = var7_8.getContent();
                        $i$f$setBody = false;
                        var20_23 = body$iv;
                        if (var20_23 == null) {
                            $this$setBody$iv.setBody((Object)NullBody.INSTANCE);
                            $i$f$typeInfo = false;
                            kType$iv$iv = Reflection.typeOf(byte[].class);
                            reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(byte[].class), (KType)kType$iv$iv));
                        } else if (var20_23 instanceof OutgoingContent) {
                            $this$setBody$iv.setBody((Object)body$iv);
                            $this$setBody$iv.setBodyType(null);
                        } else {
                            $this$setBody$iv.setBody((Object)body$iv);
                            $i$f$typeInfo = false;
                            kType$iv$iv = Reflection.typeOf(byte[].class);
                            reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(byte[].class), (KType)kType$iv$iv));
                        }
                        builder$iv$iv$iv = var12_15;
                        $i$f$put = false;
                        builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPut());
                        $this$request$iv$iv$iv$iv = $this$put$iv$iv$iv;
                        $i$f$request = false;
                        this.L$0 = getLocation;
                        this.label = 2;
                        v3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                        if (v3 == var27_2) {
                            return var27_2;
                        }
                        ** GOTO lbl78
                    }
                    case 2: {
                        $i$f$put = false;
                        $i$f$put = false;
                        $i$f$put = false;
                        $i$f$request = false;
                        getLocation = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl78:
                        // 2 sources

                        uploadFileResponse = (HttpResponse)v3;
                        if (uploadFileResponse.getStatus().getValue() != HttpStatusCode.Companion.getOK().getValue()) {
                            this.this$0.getControllerContainer().getLoggerController().traceError("sendFileMessage::failure_upload_file");
                            throw new Exception("Failed to upload file");
                        }
                        this.L$0 = null;
                        this.label = 3;
                        v4 = ChatController.access$getChatSocketHandler$p(this.this$0).sendFileMessage(getLocation, this.$file.getName(), this.$file.getSize(), (Continuation<? super Unit>)((Continuation)this));
                        if (v4 == var27_2) {
                            return var27_2;
                        }
                        ** GOTO lbl91
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl91:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final HttpClient createPrivateHttpClient() {
        return HttpClientJvmKt.HttpClient((Function1)new Function1<HttpClientConfig<?>, Unit>(this){
            final /* synthetic */ ChatController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HttpClientConfig<?> $this$HttpClient) {
                Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                $this$HttpClient.install((HttpClientPlugin)Logging.Companion, (Function1)new Function1<Logging.Config, Unit>(this.this$0){
                    final /* synthetic */ ChatController this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Logging.Config $this$install) {
                        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                        $this$install.setLogger(LoggerKt.getSIMPLE((Logger.Companion)Logger.Companion));
                        $this$install.setLevel(this.this$0.getControllerContainer().getPlatformUtilsProvider().getLogger().isLoggerEnabled() ? LogLevel.ALL : LogLevel.NONE);
                    }
                });
                $this$HttpClient.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)createPrivateHttpClient.2.INSTANCE);
                $this$HttpClient.install((HttpClientPlugin)HttpTimeout.Plugin, (Function1)createPrivateHttpClient.3.INSTANCE);
            }
        });
    }

    private final DyteChatMessage convertToDyteChatMessage(SocketChatMessage socketChatMessage) {
        DyteChatMessage dyteChatMessage;
        SocketChatMessage socketChatMessage2 = socketChatMessage;
        if (socketChatMessage2 instanceof TextSocketChatMessage) {
            dyteChatMessage = new DyteTextMessage(socketChatMessage.getUserId(), socketChatMessage.getDisplayName(), socketChatMessage.getRead(), socketChatMessage.getPluginId(), ((TextSocketChatMessage)socketChatMessage).getMessage(), this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getUserDisplayableTime(socketChatMessage.getTime()));
        } else if (socketChatMessage2 instanceof ImageSocketChatMessage) {
            dyteChatMessage = new DyteImageMessage(socketChatMessage.getUserId(), socketChatMessage.getDisplayName(), socketChatMessage.getRead(), socketChatMessage.getPluginId(), ((ImageSocketChatMessage)socketChatMessage).getLink(), this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getUserDisplayableTime(socketChatMessage.getTime()));
        } else if (socketChatMessage2 instanceof FileSocketChatMessage) {
            dyteChatMessage = new DyteFileMessage(socketChatMessage.getUserId(), socketChatMessage.getDisplayName(), socketChatMessage.getRead(), socketChatMessage.getPluginId(), ((FileSocketChatMessage)socketChatMessage).getName(), this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getUserDisplayableTime(socketChatMessage.getTime()), ((FileSocketChatMessage)socketChatMessage).getLink(), ((FileSocketChatMessage)socketChatMessage).getSize());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dyteChatMessage;
    }

    public static final /* synthetic */ ChatSocketHandler access$getChatSocketHandler$p(ChatController $this) {
        return $this.chatSocketHandler;
    }

    public static final /* synthetic */ PresignedUrlApiService access$getPresignedUrlApiService$p(ChatController $this) {
        return $this.presignedUrlApiService;
    }

    public static final /* synthetic */ HttpClient access$getHttpClient(ChatController $this) {
        return $this.getHttpClient();
    }

    public static final /* synthetic */ HttpClient access$createPrivateHttpClient(ChatController $this) {
        return $this.createPrivateHttpClient();
    }

    static {
        Object[] objectArray = new String[]{"image/jpeg", "image/png"};
        ACCEPTED_IMAGE_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/dyte/core/controllers/ChatController$Companion;", "", "()V", "ACCEPTED_IMAGE_TYPES", "", "", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

