/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.controllers;

import io.dyte.core.controllers.BaseController;
import io.dyte.core.controllers.IControllerContainer;
import io.dyte.core.controllers.IHostController;
import io.dyte.core.feat.DyteMeetingParticipant;
import io.dyte.core.socket.events.OutboundMeetingEventType;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000b\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0011\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0018\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lio/dyte/core/controllers/HostController;", "Lio/dyte/core/controllers/IHostController;", "Lio/dyte/core/controllers/BaseController;", "controllerContainer", "Lio/dyte/core/controllers/IControllerContainer;", "(Lio/dyte/core/controllers/IControllerContainer;)V", "kick", "", "id", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kickAll", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "muteAllAudio", "allowUnmute", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "muteAllVideo", "muteAudio", "dyteMeetingParticipant", "Lio/dyte/core/feat/DyteMeetingParticipant;", "(Lio/dyte/core/feat/DyteMeetingParticipant;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "muteVideo", "pinParticipant", "unpinParticipant", "shared_debug"})
public final class HostController
extends BaseController
implements IHostController {
    public HostController(@NotNull IControllerContainer controllerContainer) {
        Intrinsics.checkNotNullParameter((Object)controllerContainer, (String)"controllerContainer");
        super(controllerContainer);
    }

    @Override
    @Nullable
    public Object kick(@NotNull String id2, @NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.kickPeer");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanKickParticipant()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_kick");
            throw new UnsupportedOperationException("not allowed to kick participant");
        }
        HashMap content = new HashMap();
        ((Map)content).put("id", JsonElementKt.JsonPrimitive((String)id2));
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.KICK_PEER, (JsonElement)new JsonObject((Map)content), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object kickAll(@NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.kickAll");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanKickParticipant()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_kick_all");
            throw new UnsupportedOperationException("not allowed to kick all");
        }
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.KICK_ALL, null, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object muteAllAudio(boolean allowUnmute, @NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.disableAllAudio");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanMuteAudio()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_disable_all_audio");
            throw new UnsupportedOperationException("not allowed to mute all audio");
        }
        HashMap content = new HashMap();
        ((Map)content).put("allowUnMute", JsonElementKt.JsonPrimitive((Boolean)Boxing.boxBoolean((boolean)allowUnmute)));
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.MUTE_ALL_AUDIO, (JsonElement)new JsonObject((Map)content), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object muteAllVideo(@NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.disableAllVideo");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanMuteVideo()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipants::unauthorized_disable_all_video");
            throw new UnsupportedOperationException("not allowed to mute all video");
        }
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.MUTE_ALL_VIDEO, null, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object muteAudio(@NotNull DyteMeetingParticipant dyteMeetingParticipant, @NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.disablePeerAudio");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanMuteAudio()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_disable_audio");
            throw new UnsupportedOperationException("cant disable participant audio");
        }
        HashMap content = new HashMap();
        ((Map)content).put("id", JsonElementKt.JsonPrimitive((String)dyteMeetingParticipant.getId()));
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.MUTE_PEER_AUDIO, (JsonElement)new JsonObject((Map)content), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object muteVideo(@NotNull DyteMeetingParticipant dyteMeetingParticipant, @NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.disablePeerVideo");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanMuteVideo()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_disable_video");
            throw new UnsupportedOperationException("cant produce video");
        }
        HashMap content = new HashMap();
        ((Map)content).put("id", JsonElementKt.JsonPrimitive((String)dyteMeetingParticipant.getId()));
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.MUTE_PEER_VIDEO, (JsonElement)new JsonObject((Map)content), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object pinParticipant(@NotNull DyteMeetingParticipant dyteMeetingParticipant, @NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.pinPeer");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanPinParticipant()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_pin_peer");
            throw new UnsupportedOperationException("not allowed to pin participant");
        }
        HashMap content = new HashMap();
        ((Map)content).put("id", JsonElementKt.JsonPrimitive((String)dyteMeetingParticipant.getId()));
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.PIN_PARTICIPANT, (JsonElement)new JsonObject((Map)content), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object unpinParticipant(@NotNull Continuation<? super Unit> $completion) {
        this.getControllerContainer().getLoggerController().traceLog("DyteParticipants.unpinPeer");
        if (!this.getControllerContainer().getPresetController().getPermissions().getHost().getCanPinParticipant()) {
            this.getControllerContainer().getLoggerController().traceError("DyteParticipant::unauthorized_unpin_peer");
            throw new UnsupportedOperationException("not allowed to un-pin participant");
        }
        HashMap content = new HashMap();
        String nullString = null;
        ((Map)content).put("id", JsonElementKt.JsonPrimitive(nullString));
        Object object = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.PIN_PARTICIPANT, (JsonElement)new JsonObject((Map)content), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

