/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.controllers;

import io.dyte.core.controllers.BaseController;
import io.dyte.core.controllers.IControllerContainer;
import io.dyte.core.controllers.IMetaController;
import io.dyte.core.controllers.MeetingConfig;
import io.dyte.core.controllers.MeetingInfo;
import io.dyte.core.network.info.ParticipantInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\tH\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\tH\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/dyte/core/controllers/MetaController;", "Lio/dyte/core/controllers/IMetaController;", "Lio/dyte/core/controllers/BaseController;", "meetingInfo", "Lio/dyte/core/controllers/MeetingInfo;", "controllerContainer", "Lio/dyte/core/controllers/IControllerContainer;", "(Lio/dyte/core/controllers/MeetingInfo;Lio/dyte/core/controllers/IControllerContainer;)V", "meetingUserPeerId", "", "participantInfo", "Lio/dyte/core/network/info/ParticipantInfo;", "roomUuid", "getAuthToken", "getBaseUrl", "getBaseUrlWithoutVersion", "getDisplayName", "getMeetingConfig", "Lio/dyte/core/controllers/MeetingConfig;", "getMeetingId", "getMeetingStatedTimestamp", "getMeetingTitle", "getOrgId", "getPeerId", "getRoomName", "getRoomType", "getRoomUuid", "init", "", "isAudioEnabled", "", "isGroupCall", "isV2AuthToken", "isVideoEnabled", "isWebinar", "setMeetingStartedTimestamp", "timestamp", "setMeetingTitle", "title", "setParticipantInfo", "setRoomUuid", "shared_debug"})
public final class MetaController
extends BaseController
implements IMetaController {
    @NotNull
    private final MeetingInfo meetingInfo;
    private ParticipantInfo participantInfo;
    @NotNull
    private final String meetingUserPeerId;
    private String roomUuid;

    public MetaController(@NotNull MeetingInfo meetingInfo, @NotNull IControllerContainer controllerContainer) {
        Intrinsics.checkNotNullParameter((Object)meetingInfo, (String)"meetingInfo");
        Intrinsics.checkNotNullParameter((Object)controllerContainer, (String)"controllerContainer");
        super(controllerContainer);
        this.meetingInfo = meetingInfo;
        this.meetingUserPeerId = controllerContainer.getPlatformUtilsProvider().getPlatformUtils().getUuid();
    }

    @Override
    public void init() {
        this.meetingInfo.setMeetingId$shared_debug(this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().decodeAuthToken(this.meetingInfo.getAuthToken()));
        this.meetingInfo.setV2Meeting$shared_debug(this.meetingInfo.getMeetingId$shared_debug() != null);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        ParticipantInfo participantInfo = this.participantInfo;
        if (participantInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"participantInfo");
            participantInfo = null;
        }
        return participantInfo.getName();
    }

    @Override
    @NotNull
    public String getRoomName() {
        return this.meetingInfo.getRoomName();
    }

    @Override
    @NotNull
    public String getAuthToken() {
        return this.meetingInfo.getAuthToken();
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.meetingInfo.getBaseUrl();
    }

    @Override
    @NotNull
    public String getBaseUrlWithoutVersion() {
        String string = this.meetingInfo.getBaseUrl().substring(0, this.meetingInfo.getBaseUrl().length() - 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @Override
    @NotNull
    public String getPeerId() {
        return this.meetingUserPeerId;
    }

    @Override
    @NotNull
    public String getOrgId() {
        ParticipantInfo participantInfo = this.participantInfo;
        if (participantInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"participantInfo");
            participantInfo = null;
        }
        return participantInfo.getOrganizationId();
    }

    @Override
    @NotNull
    public String getMeetingTitle() {
        String string = this.meetingInfo.getMeetingTitle$shared_debug();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getMeetingStatedTimestamp() {
        String string = this.meetingInfo.getMeetingStartedAt$shared_debug();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getRoomType() {
        ParticipantInfo participantInfo = this.participantInfo;
        if (participantInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"participantInfo");
            participantInfo = null;
        }
        return participantInfo.getPresetInfo().getViewType();
    }

    @Override
    public void setMeetingTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.meetingInfo.setMeetingTitle$shared_debug(title);
    }

    @Override
    public void setMeetingStartedTimestamp(@NotNull String timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.meetingInfo.setMeetingStartedAt$shared_debug(timestamp);
    }

    @Override
    @NotNull
    public String getMeetingId() {
        return this.meetingInfo.getRoomName();
    }

    @Override
    public boolean isV2AuthToken() {
        return this.meetingInfo.isV2Meeting$shared_debug();
    }

    @Override
    public void setParticipantInfo(@NotNull ParticipantInfo participantInfo) {
        Intrinsics.checkNotNullParameter((Object)participantInfo, (String)"participantInfo");
        this.participantInfo = participantInfo;
    }

    @Override
    public boolean isWebinar() {
        ParticipantInfo participantInfo = this.participantInfo;
        if (participantInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"participantInfo");
            participantInfo = null;
        }
        return Intrinsics.areEqual((Object)participantInfo.getPresetInfo().getViewType(), (Object)"WEBINAR");
    }

    @Override
    public boolean isGroupCall() {
        ParticipantInfo participantInfo = this.participantInfo;
        if (participantInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"participantInfo");
            participantInfo = null;
        }
        return Intrinsics.areEqual((Object)participantInfo.getPresetInfo().getViewType(), (Object)"GROUP_CALL");
    }

    @Override
    public boolean isAudioEnabled() {
        if (!this.meetingInfo.getConfig().getInvalidateDefautlAudioSetting()) {
            return this.meetingInfo.getConfig().getEnableAudio();
        }
        return true;
    }

    @Override
    public boolean isVideoEnabled() {
        if (!this.meetingInfo.getConfig().getInvalidateDefaultVideoSetting()) {
            return this.meetingInfo.getConfig().getEnableVideo();
        }
        return true;
    }

    @Override
    @NotNull
    public MeetingConfig getMeetingConfig() {
        return this.meetingInfo.getConfig();
    }

    @Override
    public void setRoomUuid(@NotNull String roomUuid) {
        Intrinsics.checkNotNullParameter((Object)roomUuid, (String)"roomUuid");
        this.roomUuid = roomUuid;
    }

    @Override
    @NotNull
    public String getRoomUuid() {
        String string = this.roomUuid;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"roomUuid");
            string = null;
        }
        return string;
    }
}

