/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.controllers;

import io.dyte.core.VideoView;
import io.dyte.core.controllers.BaseController;
import io.dyte.core.controllers.DyteEventType;
import io.dyte.core.controllers.GridInfo;
import io.dyte.core.controllers.IControllerContainer;
import io.dyte.core.controllers.IParticipantController;
import io.dyte.core.controllers.ParticipantController;
import io.dyte.core.feat.DyteMeetingParticipant;
import io.dyte.core.feat.ParticipantFlags;
import io.dyte.core.models.DyteJoinedMeetingParticipant;
import io.dyte.core.models.DyteRoomParticipants;
import io.dyte.core.models.DyteScreenShareMeetingParticipant;
import io.dyte.core.platform.IDyteMediaSoupUtils;
import io.dyte.core.platform.IDyteSFUUtils;
import io.dyte.core.platform.IDyteVideoUtils;
import io.dyte.core.socket.events.OutboundMeetingEventType;
import io.dyte.core.socket.events.payloadmodel.inbound.ConsumerAppData;
import io.dyte.core.socket.events.payloadmodel.inbound.MeetingPeerFlags;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerClosedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerResumedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketGetPageModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerLeftModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerMuteModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerPinnedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketSelectedPeersModel;
import io.dyte.core.socket.events.payloadmodel.outbound.RoomState;
import io.dyte.core.socket.events.payloadmodel.outbound.WebSocketJoinRoomModel;
import io.dyte.core.socket.events.payloadmodel.outbound.WebSocketRoomStateModel;
import io.dyte.webrtc.VideoStreamTrack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0010H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001eH\u0002J\u0014\u0010(\u001a\u00060)j\u0002`*2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0018\u0010,\u001a\n\u0018\u00010)j\u0004\u0018\u0001`*2\u0006\u0010+\u001a\u00020\u0007H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020.H\u0016J\u0010\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020'H\u0016J\b\u00107\u001a\u00020.H\u0016J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010<\u001a\u00020.2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u00020.2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020.2\u0006\u0010D\u001a\u00020\u001cH\u0016J\b\u0010H\u001a\u00020.H\u0016J\u0010\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020.2\u0006\u0010J\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020PH\u0016J&\u0010Q\u001a\u00020.2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001e2\u0006\u0010R\u001a\u00020\u001a2\u0006\u0010S\u001a\u00020\u001aH\u0002J\u0019\u0010T\u001a\u00020.2\u0006\u0010U\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\u0012\u0010W\u001a\u00020.2\b\b\u0002\u0010X\u001a\u00020\u001aH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\nj\b\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00070\nj\b\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00070\nj\b\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\nj\b\u0012\u0004\u0012\u00020\u001c`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Y"}, d2={"Lio/dyte/core/controllers/ParticipantController;", "Lio/dyte/core/controllers/IParticipantController;", "Lio/dyte/core/controllers/BaseController;", "controllerContainer", "Lio/dyte/core/controllers/IControllerContainer;", "(Lio/dyte/core/controllers/IControllerContainer;)V", "_activeSpeaker", "Lio/dyte/core/models/DyteJoinedMeetingParticipant;", "_pinnedParticipant", "activeParticipants", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "activeSpeaker", "getActiveSpeaker", "()Lio/dyte/core/models/DyteJoinedMeetingParticipant;", "gridPagesInfo", "Lio/dyte/core/controllers/GridInfo;", "hiddenParticipants", "joinedParticipants", "meetingRoomParticipants", "Lio/dyte/core/models/DyteRoomParticipants;", "getMeetingRoomParticipants", "()Lio/dyte/core/models/DyteRoomParticipants;", "pinnedParticipant", "getPinnedParticipant", "requestedPageNumber", "", "screenshareParticipants", "Lio/dyte/core/models/DyteScreenShareMeetingParticipant;", "getDiff", "", "a", "b", "getDyteParticipant", "meetingPeerUser", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketMeetingPeerUser;", "getGridInfo", "getParticipantsArrayFrom", "peerIds", "", "getScreenShareView", "Lio/dyte/core/VideoView;", "Lio/dyte/core/platform/VideoView;", "dyteMeetingParticipant", "getVideoView", "handleRoomJoined", "", "webSocketJoinRoomModel", "Lio/dyte/core/socket/events/payloadmodel/outbound/WebSocketJoinRoomModel;", "handleRoomState", "webSocketRoomStateModel", "Lio/dyte/core/socket/events/payloadmodel/outbound/WebSocketRoomStateModel;", "init", "onActiveSpeaker", "id", "onNoActiveSpeaker", "onPeerAudioMuted", "webSocketPeerMuteModel", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketPeerMuteModel;", "onPeerAudioUnmuted", "onPeerJoined", "onPeerLeft", "webSocketPeerLeftModel", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketPeerLeftModel;", "onPeerPinned", "webSocketPeerPinnedModel", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketPeerPinnedModel;", "onPeerScreenShareStarted", "participant", "screenshareTrack", "Lio/dyte/webrtc/VideoStreamTrack;", "onPeerScreenSharedEnded", "onPeerUnpinned", "onPeerVideoMuted", "webSocketConsumerClosedModel", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketConsumerClosedModel;", "onPeerVideoUnmuted", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketConsumerResumedModel;", "onSelectedPeers", "webSocketSelectedPeersModel", "Lio/dyte/core/socket/events/payloadmodel/inbound/WebSocketSelectedPeersModel;", "processNewPage", "pageNumber", "previousPageNumber", "setPage", "newPageNumber", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updatePageCount", "currentPageNumber", "shared_debug"})
public final class ParticipantController
extends BaseController
implements IParticipantController {
    @NotNull
    private final ArrayList<DyteJoinedMeetingParticipant> joinedParticipants;
    @NotNull
    private final ArrayList<DyteJoinedMeetingParticipant> activeParticipants;
    @NotNull
    private final ArrayList<DyteScreenShareMeetingParticipant> screenshareParticipants;
    @NotNull
    private final ArrayList<DyteJoinedMeetingParticipant> hiddenParticipants;
    @NotNull
    private final DyteRoomParticipants meetingRoomParticipants;
    @Nullable
    private DyteJoinedMeetingParticipant _pinnedParticipant;
    @Nullable
    private DyteJoinedMeetingParticipant _activeSpeaker;
    private GridInfo gridPagesInfo;
    private int requestedPageNumber;

    public ParticipantController(@NotNull IControllerContainer controllerContainer) {
        Intrinsics.checkNotNullParameter((Object)controllerContainer, (String)"controllerContainer");
        super(controllerContainer);
        this.joinedParticipants = new ArrayList();
        this.activeParticipants = new ArrayList();
        this.screenshareParticipants = new ArrayList();
        this.hiddenParticipants = new ArrayList();
        this.meetingRoomParticipants = new DyteRoomParticipants(controllerContainer.getWaitlistController().getWaitlistedParticipants(), (List<? extends DyteJoinedMeetingParticipant>)this.joinedParticipants, (List<? extends DyteJoinedMeetingParticipant>)this.activeParticipants, (List<DyteScreenShareMeetingParticipant>)this.screenshareParticipants, controllerContainer);
    }

    @Override
    @NotNull
    public DyteRoomParticipants getMeetingRoomParticipants() {
        return this.meetingRoomParticipants;
    }

    @Override
    @Nullable
    public DyteJoinedMeetingParticipant getPinnedParticipant() {
        return this._pinnedParticipant;
    }

    @Override
    @Nullable
    public DyteJoinedMeetingParticipant getActiveSpeaker() {
        return this._activeSpeaker;
    }

    @Override
    public void init() {
        this.gridPagesInfo = new GridInfo(0, 0, false, false);
    }

    @Override
    @Nullable
    public VideoView getVideoView(@NotNull DyteJoinedMeetingParticipant dyteMeetingParticipant) {
        Intrinsics.checkNotNullParameter((Object)dyteMeetingParticipant, (String)"dyteMeetingParticipant");
        return this.getControllerContainer().getPlatformUtilsProvider().getVideoUtils().getVideoView(dyteMeetingParticipant);
    }

    @Override
    @NotNull
    public VideoView getScreenShareView(@NotNull DyteScreenShareMeetingParticipant dyteMeetingParticipant) {
        Intrinsics.checkNotNullParameter((Object)dyteMeetingParticipant, (String)"dyteMeetingParticipant");
        return this.getControllerContainer().getPlatformUtilsProvider().getVideoUtils().getScreenShareView(dyteMeetingParticipant);
    }

    @Override
    public void onPeerJoined(@NotNull WebSocketMeetingPeerUser meetingPeerUser) {
        Intrinsics.checkNotNullParameter((Object)meetingPeerUser, (String)"meetingPeerUser");
        DyteJoinedMeetingParticipant participant = this.getDyteParticipant(meetingPeerUser);
        if (participant.getFlags().getHiddenParticipant() || participant.getFlags().getRecorder()) {
            this.hiddenParticipants.add(participant);
            if (participant.getFlags().getRecorder()) {
                this.getControllerContainer().getRecordingController().onRecordingPeerJoined();
            }
        } else {
            Object v0;
            block8: {
                Iterable iterable = this.joinedParticipants;
                for (Object object : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)participant.getUserId())) continue;
                    v0 = object;
                    break block8;
                }
                v0 = null;
            }
            DyteJoinedMeetingParticipant existing = v0;
            if (existing == null) {
                this.joinedParticipants.add(participant);
            }
            ParticipantController.updatePageCount$default(this, 0, 1, null);
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerJoin(participant));
            if (this.joinedParticipants.size() < this.getControllerContainer().getPresetController().getMaxVideoCount()) {
                Object v1;
                block9: {
                    Object object;
                    Iterable iterable = this.activeParticipants;
                    object = iterable.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)participant.getUserId())) continue;
                        v1 = e;
                        break block9;
                    }
                    v1 = null;
                }
                DyteJoinedMeetingParticipant existingActive = v1;
                if (existingActive == null) {
                    this.activeParticipants.add(participant);
                }
                this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnActiveParticipantsChanged((List<? extends DyteJoinedMeetingParticipant>)this.activeParticipants));
            }
        }
    }

    @Override
    public void onPeerLeft(@NotNull WebSocketPeerLeftModel webSocketPeerLeftModel) {
        block19: {
            Object it;
            Iterable iterable;
            Ref.ObjectRef objectRef;
            Iterable iterable2;
            Ref.ObjectRef peerToRemove;
            boolean isHiddentParticipantLeft;
            block15: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)webSocketPeerLeftModel, (String)"webSocketPeerLeftModel");
                isHiddentParticipantLeft = false;
                peerToRemove = new Ref.ObjectRef();
                iterable2 = this.joinedParticipants;
                objectRef = peerToRemove;
                iterable = iterable2;
                for (Object t : iterable) {
                    it = (DyteJoinedMeetingParticipant)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((DyteJoinedMeetingParticipant)it).getId(), (Object)webSocketPeerLeftModel.getId())) continue;
                    object = t;
                    break block15;
                }
                object = objectRef.element = null;
            }
            if (peerToRemove.element == null) {
                block16: {
                    Object object;
                    iterable2 = this.hiddenParticipants;
                    objectRef = peerToRemove;
                    iterable = iterable2;
                    for (Object t : iterable) {
                        it = (DyteJoinedMeetingParticipant)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)((DyteJoinedMeetingParticipant)it).getId(), (Object)webSocketPeerLeftModel.getId())) continue;
                        object = t;
                        break block16;
                    }
                    object = objectRef.element = null;
                }
                if (peerToRemove.element != null) {
                    if (((DyteJoinedMeetingParticipant)peerToRemove.element).getFlags().getRecorder()) {
                        this.getControllerContainer().getRecordingController().onRecordingPeerLeft();
                    }
                    this.hiddenParticipants.remove(peerToRemove.element);
                    isHiddentParticipantLeft = true;
                }
            }
            if (isHiddentParticipantLeft) break block19;
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = (DyteJoinedMeetingParticipant)peerToRemove.element;
            if (dyteJoinedMeetingParticipant != null) {
                Object v3;
                block17: {
                    DyteJoinedMeetingParticipant it2 = dyteJoinedMeetingParticipant;
                    boolean bl = false;
                    it = this.screenshareParticipants;
                    Iterator bl2 = it.iterator();
                    while (bl2.hasNext()) {
                        Object t = bl2.next();
                        DyteScreenShareMeetingParticipant it3 = (DyteScreenShareMeetingParticipant)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it3.getId(), (Object)((DyteJoinedMeetingParticipant)peerToRemove.element).getId())) continue;
                        v3 = t;
                        break block17;
                    }
                    v3 = null;
                }
                DyteScreenShareMeetingParticipant screenSharePeer = v3;
                if (screenSharePeer != null) {
                    this.screenshareParticipants.remove(screenSharePeer);
                    this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerScreenShareEnded(screenSharePeer));
                }
                this.joinedParticipants.remove(peerToRemove.element);
                boolean removedFromActive2 = CollectionsKt.removeAll((List)this.activeParticipants, (Function1)((Function1)new Function1<DyteJoinedMeetingParticipant, Boolean>((Ref.ObjectRef<DyteJoinedMeetingParticipant>)peerToRemove){
                    final /* synthetic */ Ref.ObjectRef<DyteJoinedMeetingParticipant> $peerToRemove;
                    {
                        this.$peerToRemove = $peerToRemove;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull DyteJoinedMeetingParticipant it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getId(), (Object)((DyteJoinedMeetingParticipant)this.$peerToRemove.element).getId());
                    }
                }));
                if (removedFromActive2) {
                    boolean bl;
                    block18: {
                        Iterable $this$none$iv = this.activeParticipants;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                DyteJoinedMeetingParticipant it4 = (DyteJoinedMeetingParticipant)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it4.getId(), (Object)this.getControllerContainer().getSelfController().getSelf().getId())) continue;
                                bl = false;
                                break block18;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        this.activeParticipants.add(this.getControllerContainer().getSelfController().getSelf());
                    }
                    this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnActiveParticipantsChanged((List<? extends DyteJoinedMeetingParticipant>)this.activeParticipants));
                }
                ParticipantController.updatePageCount$default(this, 0, 1, null);
                DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant2 = this.getPinnedParticipant();
                if (Intrinsics.areEqual((Object)((DyteJoinedMeetingParticipant)peerToRemove.element).getId(), (Object)(dyteJoinedMeetingParticipant2 != null ? dyteJoinedMeetingParticipant2.getId() : null))) {
                    DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant3 = this.getPinnedParticipant();
                    if (dyteJoinedMeetingParticipant3 == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerUnpinned(dyteJoinedMeetingParticipant3));
                    this._pinnedParticipant = null;
                }
                this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerLeft((DyteMeetingParticipant)peerToRemove.element));
            }
        }
    }

    private final void updatePageCount(int currentPageNumber2) {
        int nextPages;
        int remotePeersCount = this.joinedParticipants.size() - 1;
        int n = remotePeersCount >= this.getControllerContainer().getPresetController().getMaxVideoCount() ? (int)Math.ceil((float)this.joinedParticipants.size() / (float)this.getControllerContainer().getPresetController().getMaxVideoCount()) + 1 : (nextPages = 1);
        GridInfo gridInfo = this.gridPagesInfo;
        if (gridInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridPagesInfo");
            gridInfo = null;
        }
        GridInfo newGridInfo = gridInfo.copy(nextPages, currentPageNumber2, currentPageNumber2 < nextPages - 1, currentPageNumber2 > 0);
        GridInfo gridInfo2 = this.gridPagesInfo;
        if (gridInfo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridPagesInfo");
            gridInfo2 = null;
        }
        if (!Intrinsics.areEqual((Object)newGridInfo, (Object)gridInfo2)) {
            this.gridPagesInfo = newGridInfo;
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnParticipantsUpdate(this.getMeetingRoomParticipants()));
        }
    }

    static /* synthetic */ void updatePageCount$default(ParticipantController participantController, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            GridInfo gridInfo = participantController.gridPagesInfo;
            if (gridInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gridPagesInfo");
                gridInfo = null;
            }
            n = gridInfo.getCurrentPageNumber();
        }
        participantController.updatePageCount(n);
    }

    @Override
    public void onPeerAudioMuted(@NotNull WebSocketPeerMuteModel webSocketPeerMuteModel) {
        block2: {
            DyteJoinedMeetingParticipant participant;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)webSocketPeerMuteModel, (String)"webSocketPeerMuteModel");
                Iterable iterable = this.joinedParticipants;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)webSocketPeerMuteModel.getPeerId())) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = participant = (DyteJoinedMeetingParticipant)v0;
            if (dyteJoinedMeetingParticipant == null) break block2;
            DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
            boolean bl = false;
            participant.set_audioEnabled$shared_debug(false);
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerAudioUpdate(participant));
        }
    }

    @Override
    public void onPeerAudioUnmuted(@NotNull WebSocketPeerMuteModel webSocketPeerMuteModel) {
        block2: {
            DyteJoinedMeetingParticipant participant;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)webSocketPeerMuteModel, (String)"webSocketPeerMuteModel");
                Iterable iterable = this.joinedParticipants;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)webSocketPeerMuteModel.getPeerId())) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = participant = (DyteJoinedMeetingParticipant)v0;
            if (dyteJoinedMeetingParticipant == null) break block2;
            DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
            boolean bl = false;
            participant.set_audioEnabled$shared_debug(true);
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerAudioUpdate(participant));
        }
    }

    @Override
    public void onPeerVideoMuted(@NotNull WebSocketConsumerClosedModel webSocketConsumerClosedModel) {
        block6: {
            DyteJoinedMeetingParticipant participant;
            Object v3;
            ConsumerAppData appdata;
            block5: {
                String peerId;
                Intrinsics.checkNotNullParameter((Object)webSocketConsumerClosedModel, (String)"webSocketConsumerClosedModel");
                String string = webSocketConsumerClosedModel.getId();
                if (string == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                String consumerType = this.getControllerContainer().getMediaSoupController().getConsumerType(string);
                if (Intrinsics.areEqual((Object)"audio", (Object)consumerType)) {
                    return;
                }
                String id2 = webSocketConsumerClosedModel.getId();
                boolean bl = false;
                ConsumerAppData consumerAppData = appdata = this.getControllerContainer().getMediaSoupController().getAppDataFromConsumerId(id2);
                String string3 = peerId = consumerAppData != null ? consumerAppData.getPeerId() : null;
                if (string3 == null) break block6;
                String it = string3;
                boolean bl2 = false;
                Iterable iterable = this.joinedParticipants;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it2 = (DyteJoinedMeetingParticipant)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)peerId)) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = participant = (DyteJoinedMeetingParticipant)v3;
            if (dyteJoinedMeetingParticipant != null) {
                DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)appdata.getScreenShare(), (Object)false)) {
                    participant.set_videoEnabled$shared_debug(false);
                    this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerVideoUpdate(participant));
                }
            }
        }
    }

    @Override
    public void onPeerVideoUnmuted(@NotNull WebSocketConsumerResumedModel webSocketConsumerClosedModel) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)webSocketConsumerClosedModel, (String)"webSocketConsumerClosedModel");
            String string = webSocketConsumerClosedModel.getId();
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            IDyteSFUUtils iDyteSFUUtils = this.getControllerContainer().getSfuUtils();
            IDyteMediaSoupUtils iDyteMediaSoupUtils = iDyteSFUUtils instanceof IDyteMediaSoupUtils ? (IDyteMediaSoupUtils)iDyteSFUUtils : null;
            if (iDyteMediaSoupUtils != null) {
                iDyteMediaSoupUtils.resumeConsumer(it);
            }
        }
    }

    @Override
    public void onPeerPinned(@NotNull WebSocketPeerPinnedModel webSocketPeerPinnedModel) {
        block3: {
            DyteJoinedMeetingParticipant participant;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)webSocketPeerPinnedModel, (String)"webSocketPeerPinnedModel");
                Iterable iterable = this.joinedParticipants;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)webSocketPeerPinnedModel.getPeerId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = participant = (DyteJoinedMeetingParticipant)v0;
            if (dyteJoinedMeetingParticipant == null) break block3;
            DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
            boolean bl = false;
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant2 = this._pinnedParticipant;
            if (dyteJoinedMeetingParticipant2 != null) {
                DyteJoinedMeetingParticipant it2 = dyteJoinedMeetingParticipant2;
                boolean bl2 = false;
                this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerUnpinned(it2));
            }
            this._pinnedParticipant = participant;
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerPinned(participant));
        }
    }

    @Override
    public void onPeerUnpinned() {
        DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = this._pinnedParticipant;
        if (dyteJoinedMeetingParticipant != null) {
            DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
            boolean bl = false;
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerUnpinned(it));
        }
        this._pinnedParticipant = null;
    }

    @Override
    public void onActiveSpeaker(@NotNull String id2) {
        block3: {
            DyteJoinedMeetingParticipant participant;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Iterable iterable = this.joinedParticipants;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = this._activeSpeaker = (participant = (DyteJoinedMeetingParticipant)v0);
            if (dyteJoinedMeetingParticipant == null) break block3;
            DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
            boolean bl = false;
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant2 = this._activeSpeaker;
            if (dyteJoinedMeetingParticipant2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnActiveSpeakerChanged(dyteJoinedMeetingParticipant2));
        }
    }

    @Override
    public void onNoActiveSpeaker() {
        this._activeSpeaker = null;
        this.getControllerContainer().getEventController().triggerEvent(DyteEventType.OnNoActiveSpeaker.INSTANCE);
    }

    @Override
    public void handleRoomState(@NotNull WebSocketRoomStateModel webSocketRoomStateModel) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)webSocketRoomStateModel, (String)"webSocketRoomStateModel");
            Object object = webSocketRoomStateModel.getRoomState();
            if (object == null || (object = ((RoomState)object).getPeers()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WebSocketMeetingPeerUser it = (WebSocketMeetingPeerUser)element$iv;
                boolean bl = false;
                this.onPeerJoined(it);
            }
        }
    }

    @Override
    public void handleRoomJoined(@NotNull WebSocketJoinRoomModel webSocketJoinRoomModel) {
        block6: {
            DyteJoinedMeetingParticipant pinnedParticipant;
            Object v3;
            block5: {
                Object v0;
                Object object2;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)webSocketJoinRoomModel, (String)"webSocketJoinRoomModel");
                    Iterable iterable = this.joinedParticipants;
                    for (Object object2 : iterable) {
                        DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)object2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)this.getControllerContainer().getSelfController().getSelf().getUserId())) continue;
                        v0 = object2;
                        break block4;
                    }
                    v0 = null;
                }
                if (v0 == null) {
                    this.joinedParticipants.add(this.getControllerContainer().getSelfController().getSelf());
                }
                String string = webSocketJoinRoomModel.getPinnedPeerId();
                boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
                if (!bl) break block6;
                Iterable iterable = this.joinedParticipants;
                object2 = iterable.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)e;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)webSocketJoinRoomModel.getPinnedPeerId())) continue;
                    v3 = e;
                    break block5;
                }
                v3 = null;
            }
            DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant = pinnedParticipant = (DyteJoinedMeetingParticipant)v3;
            if (dyteJoinedMeetingParticipant != null) {
                DyteJoinedMeetingParticipant it = dyteJoinedMeetingParticipant;
                boolean bl = false;
                this._pinnedParticipant = pinnedParticipant;
            }
        }
    }

    @Override
    public void onSelectedPeers(@NotNull WebSocketSelectedPeersModel webSocketSelectedPeersModel) {
        Intrinsics.checkNotNullParameter((Object)webSocketSelectedPeersModel, (String)"webSocketSelectedPeersModel");
        if (this.requestedPageNumber == 0) {
            GridInfo gridInfo;
            List list = webSocketSelectedPeersModel.getPeerIds();
            if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
                list = CollectionsKt.emptyList();
            }
            if ((gridInfo = this.gridPagesInfo) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gridPagesInfo");
                gridInfo = null;
            }
            this.processNewPage(list, 0, gridInfo.getCurrentPageNumber());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object setPage(int var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof setPage.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ParticipantController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.setPage(0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (newPageNumber < 0) {
                    throw new IllegalArgumentException("page number cant be less than 0");
                }
                this.requestedPageNumber = newPageNumber;
                content = new HashMap<K, V>();
                ((Map)content).put("pageNum", JsonElementKt.JsonPrimitive((Number)Boxing.boxInt((int)newPageNumber)));
                $continuation.L$0 = this;
                $continuation.I$0 = newPageNumber;
                $continuation.label = 1;
                v0 = this.getControllerContainer().getSocketController().sendMessage(OutboundMeetingEventType.GET_PAGE, (JsonElement)new JsonObject((Map)content), (Continuation<? super String>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                newPageNumber = $continuation.I$0;
                this = (ParticipantController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                prevPageResponse = (String)v0;
                var6_8 = this.getControllerContainer().getSocketMessageResponseParser().parseResponse(prevPageResponse).getPayload();
                Intrinsics.checkNotNull((Object)var6_8, (String)"null cannot be cast to non-null type io.dyte.core.socket.events.payloadmodel.inbound.WebSocketGetPageModel");
                pageModel = (WebSocketGetPageModel)var6_8;
                v1 = pageModel.getPeerIds();
                v2 = v1 != null ? !v1.isEmpty() : false;
                if (v2) {
                    v3 = pageModel.getPeerIds();
                    v4 = this.gridPagesInfo;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"gridPagesInfo");
                        v4 = null;
                    }
                    this.processNewPage(v3, newPageNumber, v4.getCurrentPageNumber());
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void processNewPage(List<String> peerIds, int pageNumber, int previousPageNumber) {
        List newParticipant = CollectionsKt.toMutableList((Collection)this.getParticipantsArrayFrom(peerIds));
        if (pageNumber == 0) {
            if (Intrinsics.areEqual((Object)this.getControllerContainer().getMetaController().getRoomType(), (Object)"WEBINAR")) {
                if (this.getControllerContainer().getWebinarController().isPresenting()) {
                    newParticipant.add(this.getControllerContainer().getSelfController().getSelf());
                }
            } else {
                newParticipant.add(this.getControllerContainer().getSelfController().getSelf());
            }
        }
        boolean activeParticipantsChanged = false;
        if (pageNumber > 0) {
            CollectionsKt.removeAll((List)this.activeParticipants, (Function1)((Function1)new Function1<DyteJoinedMeetingParticipant, Boolean>(this){
                final /* synthetic */ ParticipantController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull DyteJoinedMeetingParticipant it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getId(), (Object)this.this$0.getControllerContainer().getSelfController().getSelf().getId());
                }
            }));
        }
        if (previousPageNumber != pageNumber) {
            this.activeParticipants.clear();
            this.activeParticipants.addAll(CollectionsKt.toList((Iterable)newParticipant));
            activeParticipantsChanged = true;
        } else {
            List participantsToAdd = CollectionsKt.toMutableList((Collection)this.getDiff(newParticipant, (List<? extends DyteJoinedMeetingParticipant>)this.activeParticipants));
            List<DyteJoinedMeetingParticipant> participantsToRemove = this.getDiff((List<? extends DyteJoinedMeetingParticipant>)this.activeParticipants, newParticipant);
            if (!((Collection)participantsToAdd).isEmpty() || !((Collection)participantsToRemove).isEmpty()) {
                activeParticipantsChanged = true;
            }
            Iterable $this$forEach$iv = participantsToRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DyteJoinedMeetingParticipant it;
                DyteJoinedMeetingParticipant toRemove = (DyteJoinedMeetingParticipant)element$iv;
                boolean bl = false;
                int index = 0;
                Iterable $this$forEach$iv2 = this.activeParticipants;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    DyteJoinedMeetingParticipant it2 = (DyteJoinedMeetingParticipant)element$iv2;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it2.getId(), (Object)toRemove.getId())) {
                        return;
                    }
                    ++index;
                }
                this.activeParticipants.remove(index);
                DyteJoinedMeetingParticipant elementToAdd = (DyteJoinedMeetingParticipant)CollectionsKt.firstOrNull((List)participantsToAdd);
                if (elementToAdd == null) continue;
                boolean bl3 = false;
                this.activeParticipants.add(index, it);
                participantsToAdd.remove(it);
            }
            $this$forEach$iv = participantsToAdd;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)element$iv;
                boolean bl = false;
                this.activeParticipants.add(it);
            }
        }
        this.updatePageCount(pageNumber);
        if (activeParticipantsChanged) {
            this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnActiveParticipantsChanged((List<? extends DyteJoinedMeetingParticipant>)this.activeParticipants));
        }
    }

    private final List<DyteJoinedMeetingParticipant> getParticipantsArrayFrom(List<String> peerIds) {
        ArrayList<DyteJoinedMeetingParticipant> result2 = new ArrayList<DyteJoinedMeetingParticipant>();
        Iterable $this$forEach$iv = peerIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            block2: {
                String peerId = (String)element$iv;
                boolean bl = false;
                Iterable iterable = this.joinedParticipants;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)peerId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            DyteJoinedMeetingParticipant peer = v0;
            if (peer == null) continue;
            boolean bl = false;
            result2.add(peer);
        }
        return result2;
    }

    private final List<DyteJoinedMeetingParticipant> getDiff(List<? extends DyteJoinedMeetingParticipant> a, List<? extends DyteJoinedMeetingParticipant> b) {
        ArrayList<DyteJoinedMeetingParticipant> result2 = new ArrayList<DyteJoinedMeetingParticipant>();
        Iterable $this$forEach$iv = a;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DyteJoinedMeetingParticipant peer;
            Object v0;
            DyteJoinedMeetingParticipant participant;
            block2: {
                participant = (DyteJoinedMeetingParticipant)element$iv;
                boolean bl = false;
                Iterable iterable = b;
                for (Object t : iterable) {
                    DyteJoinedMeetingParticipant it = (DyteJoinedMeetingParticipant)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)participant.getId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((peer = (DyteJoinedMeetingParticipant)v0) != null) continue;
            result2.add(participant);
        }
        return result2;
    }

    @Override
    public void onPeerScreenShareStarted(@NotNull DyteScreenShareMeetingParticipant participant, @NotNull VideoStreamTrack screenshareTrack) {
        Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
        Intrinsics.checkNotNullParameter((Object)screenshareTrack, (String)"screenshareTrack");
        participant.set_screenShareTrack$shared_debug(screenshareTrack);
        this.screenshareParticipants.add(participant);
        this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerScreenShareStarted(participant));
        ParticipantController.updatePageCount$default(this, 0, 1, null);
    }

    @Override
    public void onPeerScreenSharedEnded(@NotNull DyteScreenShareMeetingParticipant participant) {
        Object v0;
        IDyteVideoUtils iDyteVideoUtils;
        block1: {
            Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
            Iterable iterable = this.screenshareParticipants;
            iDyteVideoUtils = this.getControllerContainer().getPlatformUtilsProvider().getVideoUtils();
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                DyteScreenShareMeetingParticipant it = (DyteScreenShareMeetingParticipant)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)participant.getId())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        iDyteVideoUtils.destroyView(v0);
        CollectionsKt.removeAll((List)this.screenshareParticipants, (Function1)((Function1)new Function1<DyteScreenShareMeetingParticipant, Boolean>(participant){
            final /* synthetic */ DyteScreenShareMeetingParticipant $participant;
            {
                this.$participant = $participant;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DyteScreenShareMeetingParticipant it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$participant.getId());
            }
        }));
        this.getControllerContainer().getEventController().triggerEvent(new DyteEventType.OnPeerScreenShareEnded(participant));
        ParticipantController.updatePageCount$default(this, 0, 1, null);
    }

    private final DyteJoinedMeetingParticipant getDyteParticipant(WebSocketMeetingPeerUser meetingPeerUser) {
        DyteJoinedMeetingParticipant dyteJoinedMeetingParticipant;
        Object object;
        Object object2 = meetingPeerUser.getFlags();
        ParticipantFlags flags = new ParticipantFlags(object2 != null && (object2 = ((MeetingPeerFlags)object2).getRecordere()) != null ? (Boolean)object2 : false, (object = meetingPeerUser.getFlags()) != null && (object = ((MeetingPeerFlags)object).getHiddenParticipant()) != null ? (Boolean)object : false);
        String string = meetingPeerUser.getId();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = meetingPeerUser.getUserId();
        if (string3 == null) {
            String string4 = "Required value was null.";
            throw new IllegalArgumentException(string4.toString());
        }
        String string5 = meetingPeerUser.getName();
        if (string5 == null) {
            string5 = "";
        }
        String string6 = meetingPeerUser.getPicture();
        Boolean bl = meetingPeerUser.isHost();
        boolean bl2 = bl != null ? bl : false;
        String string7 = meetingPeerUser.getClientSpecificId();
        if (string7 == null) {
            string7 = this.getControllerContainer().getPlatformUtilsProvider().getPlatformUtils().getUuid();
        }
        DyteJoinedMeetingParticipant $this$getDyteParticipant_u24lambda_u2436 = dyteJoinedMeetingParticipant = new DyteJoinedMeetingParticipant(string, string3, string5, string6, bl2, string7, flags, this.getControllerContainer());
        boolean bl3 = false;
        Boolean bl4 = meetingPeerUser.getAudioMuted();
        $this$getDyteParticipant_u24lambda_u2436.set_audioEnabled$shared_debug(bl4 != null ? !bl4.booleanValue() : false);
        return dyteJoinedMeetingParticipant;
    }

    @Override
    @NotNull
    public GridInfo getGridInfo() {
        GridInfo gridInfo = this.gridPagesInfo;
        if (gridInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridPagesInfo");
            gridInfo = null;
        }
        return gridInfo;
    }
}

