/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.controllers;

import io.dyte.core.controllers.BaseController;
import io.dyte.core.controllers.IControllerContainer;
import io.dyte.core.controllers.IPresetController;
import io.dyte.core.network.info.DyteDesignToken;
import io.dyte.core.network.info.ParticipantInfo;
import io.dyte.core.network.info.SelfPermissions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lio/dyte/core/controllers/PresetController;", "Lio/dyte/core/controllers/BaseController;", "Lio/dyte/core/controllers/IPresetController;", "participantInfo", "Lio/dyte/core/network/info/ParticipantInfo;", "controllerContainer", "Lio/dyte/core/controllers/IControllerContainer;", "(Lio/dyte/core/network/info/ParticipantInfo;Lio/dyte/core/controllers/IControllerContainer;)V", "designToken", "Lio/dyte/core/network/info/DyteDesignToken;", "getDesignToken", "()Lio/dyte/core/network/info/DyteDesignToken;", "permissions", "Lio/dyte/core/network/info/SelfPermissions;", "getPermissions", "()Lio/dyte/core/network/info/SelfPermissions;", "canCreatePoll", "", "canDoParticipantHostControls", "canPublishAudio", "canPublishVideo", "canRecord", "canSendChatFile", "canSendChatText", "canStartPlugins", "canViewPoll", "canVoteOnPoll", "closePlugins", "getMaxVideoCount", "", "shared_debug"})
public final class PresetController
extends BaseController
implements IPresetController {
    @NotNull
    private final ParticipantInfo participantInfo;

    public PresetController(@NotNull ParticipantInfo participantInfo, @NotNull IControllerContainer controllerContainer) {
        Intrinsics.checkNotNullParameter((Object)participantInfo, (String)"participantInfo");
        Intrinsics.checkNotNullParameter((Object)controllerContainer, (String)"controllerContainer");
        super(controllerContainer);
        this.participantInfo = participantInfo;
    }

    @Override
    @NotNull
    public SelfPermissions getPermissions() {
        return this.participantInfo.getPresetInfo().getPermissions();
    }

    @Override
    @NotNull
    public DyteDesignToken getDesignToken() {
        return this.participantInfo.getPresetInfo().getUi();
    }

    @Override
    public boolean canPublishVideo() {
        return this.participantInfo.getPresetInfo().getPermissions().getMedia().getCanPublishVideo();
    }

    @Override
    public boolean canPublishAudio() {
        return this.participantInfo.getPresetInfo().getPermissions().getMedia().getCanPublishAudio();
    }

    @Override
    public boolean canCreatePoll() {
        return this.participantInfo.getPresetInfo().getPermissions().getPolls().getCanCreate();
    }

    @Override
    public boolean canViewPoll() {
        return this.participantInfo.getPresetInfo().getPermissions().getPolls().getCanView();
    }

    @Override
    public boolean canVoteOnPoll() {
        return this.participantInfo.getPresetInfo().getPermissions().getPolls().getCanVote();
    }

    @Override
    public boolean closePlugins() {
        return this.participantInfo.getPresetInfo().getPermissions().getPlugins().getCanClose();
    }

    @Override
    public boolean canStartPlugins() {
        return this.participantInfo.getPresetInfo().getPermissions().getPlugins().getCanLaunch();
    }

    @Override
    public int getMaxVideoCount() {
        return this.participantInfo.getPresetInfo().getGridInfo().getMaxParticipantsPerPage();
    }

    @Override
    public boolean canRecord() {
        return this.participantInfo.getPresetInfo().getPermissions().getHost().getCanTriggerRecording();
    }

    @Override
    public boolean canSendChatText() {
        return this.participantInfo.getPresetInfo().getPermissions().getChat().getCanSendText();
    }

    @Override
    public boolean canSendChatFile() {
        return this.participantInfo.getPresetInfo().getPermissions().getChat().getCanSendFiles();
    }

    @Override
    public boolean canDoParticipantHostControls() {
        return this.participantInfo.getPresetInfo().getPermissions().getHost().getCanMuteAudio() || this.participantInfo.getPresetInfo().getPermissions().getHost().getCanMuteVideo() || this.participantInfo.getPresetInfo().getPermissions().getHost().getCanKickParticipant() || this.participantInfo.getPresetInfo().getPermissions().getHost().getCanPinParticipant();
    }
}

