/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.feat;

import android.net.Uri;
import io.dyte.core.controllers.Controller;
import io.dyte.core.feat.DyteChatMessage;
import io.dyte.core.feat.DyteChatMessageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0012\u0010\u0012\u001a\u00020\u000b2\n\u0010\u0013\u001a\u00060\rj\u0002`\u000eJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0010J\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00180\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/dyte/core/feat/DyteChat;", "", "controller", "Lio/dyte/core/controllers/Controller;", "(Lio/dyte/core/controllers/Controller;)V", "messages", "", "Lio/dyte/core/feat/DyteChatMessage;", "getMessages", "()Ljava/util/List;", "sendFileMessage", "", "fileUri", "Landroid/net/Uri;", "Lio/dyte/core/platform/Uri;", "filePath", "", "fileName", "sendImageMessage", "imageUri", "imagePath", "sendTextMessage", "message", "toMap", "", "shared_debug"})
public final class DyteChat {
    @NotNull
    private final Controller controller;
    @NotNull
    private final List<DyteChatMessage> messages;

    public DyteChat(@NotNull Controller controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.messages = this.controller.getChatController().getMessages();
    }

    @NotNull
    public final List<DyteChatMessage> getMessages() {
        return this.messages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Map<String, Object>> toMap() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DyteChatMessage dyteChatMessage = (DyteChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DyteChatMessageKt.encodeDyteChatMessage((DyteChatMessage)it));
        }
        return (List)destination$iv$iv;
    }

    public final void sendTextMessage(@NotNull String message) throws Exception {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.controller.getChatController().sendMessage(message);
    }

    @Deprecated(message="Sending a file message no longer needs fileName parameter. This method will be removed in next version of the SDK.", replaceWith=@ReplaceWith(expression="sendFileMessage(fileUri: Uri)", imports={}))
    public final void sendFileMessage(@NotNull String filePath, @NotNull String fileName) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.controller.getChatController().sendFileMessage(filePath);
    }

    @Deprecated(message="Sending an image message no longer needs fileName parameter. This method will be removed in next version of the SDK.", replaceWith=@ReplaceWith(expression="sendImageMessage(imageUri: Uri)", imports={}))
    public final void sendImageMessage(@NotNull String filePath, @NotNull String fileName) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.controller.getChatController().sendImageMessage(filePath);
    }

    public final void sendImageMessage(@NotNull Uri imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        this.controller.getChatController().sendImageMessage(imageUri);
    }

    public final void sendImageMessage(@NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        this.controller.getChatController().sendImageMessage(imagePath);
    }

    public final void sendFileMessage(@NotNull Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        this.controller.getChatController().sendFileMessage(fileUri);
    }

    public final void sendFileMessage(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.controller.getChatController().sendFileMessage(filePath);
    }
}

