/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.incallmanager;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import io.dyte.core.incallmanager.InCallManagerEventCallbacks;
import io.dyte.core.incallmanager.InCallProximityManager;
import io.dyte.core.incallmanager.InCallWakeLockUtils;
import io.dyte.core.incallmanager.apprtc.AppRTCBluetoothManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b+\u0018\u0000 \u00a2\u00012\u00020\u0001:\f\u00a0\u0001\u00a1\u0001\u00a2\u0001\u00a3\u0001\u00a4\u0001\u00a5\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010R\u001a\u00020\u0014H\u0002J\b\u0010S\u001a\u00020\u0014H\u0002J\b\u0010T\u001a\u00020\u0014H\u0003J\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\r0VJ\u0012\u0010W\u001a\u0004\u0018\u00010\u00152\u0006\u0010X\u001a\u00020\u0014H\u0002J\u0010\u0010Y\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u0014H\u0002J\u0010\u0010B\u001a\u00020\r2\u0006\u0010[\u001a\u00020\u0011H\u0002J\u0012\u0010\\\u001a\u0004\u0018\u00010\u00152\u0006\u0010X\u001a\u00020\u0014H\u0002J\u0012\u0010]\u001a\u0004\u0018\u00010\u00152\u0006\u0010X\u001a\u00020\u0014H\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010\u00152\u0006\u0010_\u001a\u00020\u0014H\u0002J\b\u0010`\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u0011H\u0002J\b\u0010a\u001a\u00020bH\u0002J\b\u0010c\u001a\u00020bH\u0002J\u0010\u0010d\u001a\u00020b2\u0006\u0010e\u001a\u00020\u001eH\u0016J\u000e\u0010f\u001a\u00020b2\u0006\u0010g\u001a\u00020\u0011J\b\u0010h\u001a\u00020\u0014H\u0002J\b\u0010i\u001a\u00020\u0014H\u0002J\b\u0010j\u001a\u00020\u0014H\u0003J\b\u0010k\u001a\u00020bH\u0003J\u000e\u0010l\u001a\u00020b2\u0006\u0010m\u001a\u00020\rJ\u001a\u0010n\u001a\u00020b2\u0006\u0010o\u001a\u00020\u00142\b\u0010p\u001a\u0004\u0018\u00010qH\u0002J\u0010\u0010r\u001a\u00020b2\u0006\u0010m\u001a\u00020\rH\u0002J\u0010\u0010s\u001a\u00020b2\b\u0010t\u001a\u0004\u0018\u00010\rJ\u000e\u0010u\u001a\u00020b2\u0006\u0010v\u001a\u00020\u001eJ\u000e\u0010w\u001a\u00020b2\u0006\u0010x\u001a\u00020\u0011J\u0018\u0010y\u001a\u00020b2\u0006\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020\u0014H\u0002J\u000e\u0010}\u001a\u00020b2\u0006\u0010x\u001a\u00020\u0011J\u000e\u0010~\u001a\u00020b2\u0006\u0010x\u001a\u00020\u0011J!\u0010\u007f\u001a\u00020b2\u0007\u0010\u0080\u0001\u001a\u00020\u00142\u0007\u0010\u0081\u0001\u001a\u00020\u00112\u0007\u0010\u0082\u0001\u001a\u00020\u0014J\u0010\u0010\u0083\u0001\u001a\u00020\u00112\u0007\u0010\u0084\u0001\u001a\u00020\u0014J\t\u0010\u0085\u0001\u001a\u00020bH\u0002J\t\u0010\u0086\u0001\u001a\u00020bH\u0002J\t\u0010\u0087\u0001\u001a\u00020bH\u0002J\u0007\u0010\u0088\u0001\u001a\u00020bJ\u0010\u0010\u0089\u0001\u001a\u00020b2\u0007\u0010\u0082\u0001\u001a\u00020\u0014J\t\u0010\u008a\u0001\u001a\u00020bH\u0002J\u0014\u0010\u008b\u0001\u001a\u00020b2\t\b\u0002\u0010\u0084\u0001\u001a\u00020\u0014H\u0007J\t\u0010\u008c\u0001\u001a\u00020bH\u0002J\t\u0010\u008d\u0001\u001a\u00020bH\u0002J\t\u0010\u008e\u0001\u001a\u00020bH\u0002J\t\u0010\u008f\u0001\u001a\u00020bH\u0002J\u0007\u0010\u0090\u0001\u001a\u00020bJ\u0007\u0010\u0091\u0001\u001a\u00020bJ\t\u0010\u0092\u0001\u001a\u00020bH\u0002J\t\u0010\u0093\u0001\u001a\u00020bH\u0002J\t\u0010\u0094\u0001\u001a\u00020bH\u0003J\u0007\u0010\u0095\u0001\u001a\u00020bJ\u0007\u0010\u0096\u0001\u001a\u00020bJ\u0014\u0010\u0097\u0001\u001a\u00020b2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010<H\u0002J\u0007\u0010\u0099\u0001\u001a\u00020bJ\t\u0010\u009a\u0001\u001a\u00020bH\u0002J;\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0015*\u00020\u00142\u0006\u0010X\u001a\u00020\u00142\u0007\u0010\u009c\u0001\u001a\u00020\u00142\u0007\u0010\u009d\u0001\u001a\u00020\u00142\u0007\u0010\u009e\u0001\u001a\u00020\u00142\u0007\u0010\u009f\u0001\u001a\u00020\u0014H\u0003R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n  *\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n  *\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\"\u0010K\u001a\u0004\u0018\u00010\r2\b\u0010J\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010CR\u000e\u0010M\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a6\u0001"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "activity", "Landroid/app/Activity;", "inCallManagerEventCallbacks", "Lio/dyte/core/incallmanager/InCallManagerEventCallbacks;", "(Landroid/app/Activity;Lio/dyte/core/incallmanager/InCallManagerEventCallbacks;)V", "audioDeviceStatusMap", "Landroid/os/Bundle;", "getAudioDeviceStatusMap", "()Landroid/os/Bundle;", "audioDevices", "", "Lio/dyte/core/incallmanager/InCallManagerModule$AudioDevice;", "audioManager", "Landroid/media/AudioManager;", "audioManagerActivated", "", "audioUriMap", "", "", "Landroid/net/Uri;", "automatic", "bluetoothManager", "Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager;", "bundleBusytoneUri", "bundleRingbackUri", "bundleRingtoneUri", "defaultAudioDevice", "defaultAudioMode", "", "defaultBusytoneUri", "kotlin.jvm.PlatformType", "defaultRingbackUri", "defaultRingtoneUri", "defaultSpeakerOn", "forceSpeakerOn", "hasWiredHeadset", "isAudioFocused", "isOrigAudioSetupStored", "isProximityRegistered", "lastLayoutParams", "Landroid/view/WindowManager$LayoutParams;", "mAudioAttributes", "Landroid/media/AudioAttributes;", "mAudioFocusRequest", "Landroid/media/AudioFocusRequest;", "mBusytone", "Lio/dyte/core/incallmanager/InCallManagerModule$MyPlayerInterface;", "mPackageName", "mPowerManager", "Landroid/os/PowerManager;", "mRingback", "mRingtone", "mRingtoneCountDownHandler", "Landroid/os/Handler;", "mWindowManager", "Landroid/view/WindowManager;", "media", "mediaButtonReceiver", "Landroid/content/BroadcastReceiver;", "noisyAudioReceiver", "origAudioMode", "origIsMicrophoneMute", "origIsSpeakerPhoneOn", "preferredAudioDevice", "getPreferredAudioDevice", "()Lio/dyte/core/incallmanager/InCallManagerModule$AudioDevice;", "proximityIsNear", "proximityManager", "Lio/dyte/core/incallmanager/InCallProximityManager;", "savedAudioMode", "savedIsMicrophoneMute", "savedIsSpeakerPhoneOn", "<set-?>", "selectedAudioDevice", "getSelectedAudioDevice", "useSpeakerphone", "userSelectedAudioDevice", "wakeLockUtils", "Lio/dyte/core/incallmanager/InCallWakeLockUtils;", "wiredHeadsetReceiver", "abandonAudioFocus", "abandonAudioFocusOld", "abandonAudioFocusV26", "getAudioDevices", "", "getBusytoneUri", "_type", "getDefaultUserUri", "type", "skipBluetooth", "getRingbackUri", "getRingtoneUri", "getSysFileUri", "target", "hasEarpiece", "manualTurnScreenOff", "", "manualTurnScreenOn", "onAudioFocusChange", "focusChange", "onProximitySensorChangedState", "isNear", "requestAudioFocus", "requestAudioFocusOld", "requestAudioFocusV26", "restoreOriginalAudioSetup", "selectAudioDevice", "device", "sendEvent", "eventName", "params", "", "setAudioDeviceInternal", "setDefaultAudioDevice", "defaultDevice", "setForceSpeakerphoneOn", "flag", "setKeepScreenOn", "enable", "setMediaPlayerEvents", "mp", "Landroid/media/MediaPlayer;", "name", "setMicrophoneMute", "setSpeakerphoneOn", "start", "_media", "auto", "ringbackUriType", "startBusytone", "busytoneUriType", "startEvents", "startMediaButtonEvent", "startNoisyAudioEvent", "startProximitySensor", "startRingback", "startWiredHeadsetEvent", "stop", "stopBusytone", "stopEvents", "stopMediaButtonEvent", "stopNoisyAudioEvent", "stopProximitySensor", "stopRingback", "stopRingtone", "stopWiredHeadsetEvent", "storeOriginalAudioSetup", "turnScreenOff", "turnScreenOn", "unregisterReceiver", "receiver", "updateAudioDeviceState", "updateAudioRoute", "getAudioUri", "fileBundle", "fileSysPath", "uriBundle", "uriDefault", "AudioDevice", "AudioManagerState", "Companion", "DyteMediaPlayer", "DyteToneGenerator", "MyPlayerInterface", "shared_debug"})
public final class InCallManagerModule
implements AudioManager.OnAudioFocusChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mPackageName;
    @Nullable
    private final Activity activity;
    @NotNull
    private final PowerManager mPowerManager;
    @Nullable
    private WindowManager.LayoutParams lastLayoutParams;
    @NotNull
    private final WindowManager mWindowManager;
    @NotNull
    private final AudioManager audioManager;
    private boolean audioManagerActivated;
    private boolean isAudioFocused;
    private boolean isOrigAudioSetupStored;
    private boolean origIsSpeakerPhoneOn;
    private boolean origIsMicrophoneMute;
    private int origAudioMode;
    private boolean defaultSpeakerOn;
    private final int defaultAudioMode;
    private int forceSpeakerOn;
    private boolean automatic;
    private boolean isProximityRegistered;
    private final boolean proximityIsNear;
    @Nullable
    private BroadcastReceiver wiredHeadsetReceiver;
    @Nullable
    private BroadcastReceiver noisyAudioReceiver;
    @Nullable
    private BroadcastReceiver mediaButtonReceiver;
    @Nullable
    private AudioAttributes mAudioAttributes;
    @Nullable
    private AudioFocusRequest mAudioFocusRequest;
    private final Uri defaultRingtoneUri;
    private final Uri defaultRingbackUri;
    private final Uri defaultBusytoneUri;
    @Nullable
    private final Uri bundleRingtoneUri;
    @Nullable
    private final Uri bundleRingbackUri;
    @Nullable
    private final Uri bundleBusytoneUri;
    @NotNull
    private final Map<String, Uri> audioUriMap;
    @Nullable
    private MyPlayerInterface mRingtone;
    @Nullable
    private MyPlayerInterface mRingback;
    @Nullable
    private MyPlayerInterface mBusytone;
    @Nullable
    private Handler mRingtoneCountDownHandler;
    @NotNull
    private String media;
    @NotNull
    private final InCallManagerEventCallbacks inCallManagerEventCallbacks;
    private final int savedAudioMode;
    private final boolean savedIsSpeakerPhoneOn;
    private final boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    @NotNull
    private AudioDevice defaultAudioDevice;
    @Nullable
    private AudioDevice selectedAudioDevice;
    @Nullable
    private AudioDevice userSelectedAudioDevice;
    @NotNull
    private final String useSpeakerphone;
    @Nullable
    private AppRTCBluetoothManager bluetoothManager;
    @NotNull
    private final InCallProximityManager proximityManager;
    @NotNull
    private final InCallWakeLockUtils wakeLockUtils;
    @NotNull
    private Set<AudioDevice> audioDevices;
    @NotNull
    private static final String REACT_NATIVE_MODULE_NAME = "InCallManager";
    @NotNull
    private static final String TAG = "InCallManager";
    @NotNull
    private static final String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    @NotNull
    private static final String SPEAKERPHONE_AUTO = "auto";

    public InCallManagerModule(@NotNull Activity activity, @NotNull InCallManagerEventCallbacks inCallManagerEventCallbacks) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)inCallManagerEventCallbacks, (String)"inCallManagerEventCallbacks");
        this.mPackageName = "io.dyte.core.sample";
        this.origAudioMode = -2;
        this.defaultAudioMode = 3;
        this.automatic = true;
        this.defaultRingtoneUri = Settings.System.DEFAULT_RINGTONE_URI;
        this.defaultRingbackUri = Settings.System.DEFAULT_RINGTONE_URI;
        this.defaultBusytoneUri = Settings.System.DEFAULT_NOTIFICATION_URI;
        this.media = "audio";
        this.savedAudioMode = -2;
        this.defaultAudioDevice = AudioDevice.NONE;
        this.useSpeakerphone = SPEAKERPHONE_AUTO;
        this.audioDevices = new HashSet();
        this.activity = activity;
        this.inCallManagerEventCallbacks = inCallManagerEventCallbacks;
        Object object = activity.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        this.mWindowManager = (WindowManager)object;
        Object object2 = activity.getSystemService("power");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.os.PowerManager");
        this.mPowerManager = (PowerManager)object2;
        Object object3 = activity.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object3;
        this.audioUriMap = new HashMap();
        this.audioUriMap.put("defaultRingtoneUri", this.defaultRingtoneUri);
        this.audioUriMap.put("defaultRingbackUri", this.defaultRingbackUri);
        this.audioUriMap.put("defaultBusytoneUri", this.defaultBusytoneUri);
        this.audioUriMap.put("bundleRingtoneUri", this.bundleRingtoneUri);
        this.audioUriMap.put("bundleRingbackUri", this.bundleRingbackUri);
        this.audioUriMap.put("bundleBusytoneUri", this.bundleBusytoneUri);
        this.wakeLockUtils = new InCallWakeLockUtils((Context)activity);
        this.proximityManager = InCallProximityManager.Companion.create((Context)activity, this);
        this.bluetoothManager = AppRTCBluetoothManager.Companion.create((Context)activity, this);
        Log.d((String)"InCallManager", (String)"InCallManager initialized");
    }

    @Nullable
    public final AudioDevice getSelectedAudioDevice() {
        return this.selectedAudioDevice;
    }

    private final void manualTurnScreenOff() {
        WindowManager.LayoutParams params;
        Log.d((String)"InCallManager", (String)"manualTurnScreenOff()");
        if (this.activity == null) {
            Log.d((String)"InCallManager", (String)"ReactContext doesn't hava any Activity attached.");
            return;
        }
        Window window = this.activity.getWindow();
        this.lastLayoutParams = params = window.getAttributes();
        params.screenBrightness = 0.0f;
        window.setAttributes(params);
        window.clearFlags(128);
    }

    private final void manualTurnScreenOn() {
        Log.d((String)"InCallManager", (String)"manualTurnScreenOn()");
        if (this.activity == null) {
            Log.d((String)"InCallManager", (String)"ReactContext doesn't hava any Activity attached.");
            return;
        }
        Window window = this.activity.getWindow();
        if (this.lastLayoutParams != null) {
            window.setAttributes(this.lastLayoutParams);
        } else {
            WindowManager.LayoutParams params = window.getAttributes();
            params.screenBrightness = -1.0f;
            window.setAttributes(params);
        }
        window.addFlags(128);
    }

    @SuppressLint(value={"WrongConstant"})
    private final void storeOriginalAudioSetup() {
        Log.d((String)"InCallManager", (String)"storeOriginalAudioSetup()");
        if (!this.isOrigAudioSetupStored) {
            this.origAudioMode = this.audioManager.getMode();
            this.origIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
            this.origIsMicrophoneMute = this.audioManager.isMicrophoneMute();
            this.isOrigAudioSetupStored = true;
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private final void restoreOriginalAudioSetup() {
        Log.d((String)"InCallManager", (String)"restoreOriginalAudioSetup()");
        if (this.isOrigAudioSetupStored) {
            this.setSpeakerphoneOn(this.origIsSpeakerPhoneOn);
            this.setMicrophoneMute(this.origIsMicrophoneMute);
            this.audioManager.setMode(this.origAudioMode);
            if (this.activity != null) {
                this.activity.setVolumeControlStream(Integer.MIN_VALUE);
            }
            this.isOrigAudioSetupStored = false;
        }
    }

    private final void startWiredHeadsetEvent() {
        if (this.wiredHeadsetReceiver == null) {
            Log.d((String)"InCallManager", (String)"startWiredHeadsetEvent()");
            IntentFilter filter = new IntentFilter(ACTION_HEADSET_PLUG);
            this.wiredHeadsetReceiver = new BroadcastReceiver(this){
                final /* synthetic */ InCallManagerModule this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    if (Intrinsics.areEqual((Object)"android.intent.action.HEADSET_PLUG", (Object)intent.getAction())) {
                        InCallManagerModule.access$setHasWiredHeadset$p(this.this$0, intent.getIntExtra("state", 0) == 1);
                        InCallManagerModule.access$updateAudioRoute(this.this$0);
                        String deviceName = intent.getStringExtra("name");
                        if (deviceName == null) {
                            deviceName = "";
                        }
                        Bundle data = new Bundle();
                        data.putBoolean("isPlugged", intent.getIntExtra("state", 0) == 1);
                        data.putBoolean("hasMic", intent.getIntExtra("microphone", 0) == 1);
                        data.putString("deviceName", deviceName);
                        InCallManagerModule.access$sendEvent(this.this$0, "WiredHeadset", data);
                    } else {
                        InCallManagerModule.access$setHasWiredHeadset$p(this.this$0, false);
                    }
                }
            };
            if (this.activity != null) {
                this.activity.registerReceiver(this.wiredHeadsetReceiver, filter);
            } else {
                Log.d((String)"InCallManager", (String)"startWiredHeadsetEvent() reactContext is null");
            }
        }
    }

    private final void stopWiredHeadsetEvent() {
        if (this.wiredHeadsetReceiver != null) {
            Log.d((String)"InCallManager", (String)"stopWiredHeadsetEvent()");
            this.unregisterReceiver(this.wiredHeadsetReceiver);
            this.wiredHeadsetReceiver = null;
        }
    }

    private final void startNoisyAudioEvent() {
        if (this.noisyAudioReceiver == null) {
            Log.d((String)"InCallManager", (String)"startNoisyAudioEvent()");
            IntentFilter filter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
            this.noisyAudioReceiver = new BroadcastReceiver(this){
                final /* synthetic */ InCallManagerModule this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    if (Intrinsics.areEqual((Object)"android.media.AUDIO_BECOMING_NOISY", (Object)intent.getAction())) {
                        InCallManagerModule.access$updateAudioRoute(this.this$0);
                        InCallManagerModule.access$sendEvent(this.this$0, "NoisyAudio", null);
                    }
                }
            };
            if (this.activity != null) {
                this.activity.registerReceiver(this.noisyAudioReceiver, filter);
            } else {
                Log.d((String)"InCallManager", (String)"startNoisyAudioEvent() reactContext is null");
            }
        }
    }

    private final void stopNoisyAudioEvent() {
        if (this.noisyAudioReceiver != null) {
            Log.d((String)"InCallManager", (String)"stopNoisyAudioEvent()");
            this.unregisterReceiver(this.noisyAudioReceiver);
            this.noisyAudioReceiver = null;
        }
    }

    private final void startMediaButtonEvent() {
        if (this.mediaButtonReceiver == null) {
            Log.d((String)"InCallManager", (String)"startMediaButtonEvent()");
            IntentFilter filter = new IntentFilter("android.intent.action.MEDIA_BUTTON");
            this.mediaButtonReceiver = new BroadcastReceiver(this){
                final /* synthetic */ InCallManagerModule this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    if (Intrinsics.areEqual((Object)"android.intent.action.MEDIA_BUTTON", (Object)intent.getAction())) {
                        String string;
                        KeyEvent event;
                        KeyEvent keyEvent = event = Build.VERSION.SDK_INT >= 33 ? (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT", KeyEvent.class) : (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                        Intrinsics.checkNotNull((Object)keyEvent);
                        int keyCode = keyEvent.getKeyCode();
                        switch (keyCode) {
                            case 126: {
                                string = "KEYCODE_MEDIA_PLAY";
                                break;
                            }
                            case 127: {
                                string = "KEYCODE_MEDIA_PAUSE";
                                break;
                            }
                            case 85: {
                                string = "KEYCODE_MEDIA_PLAY_PAUSE";
                                break;
                            }
                            case 87: {
                                string = "KEYCODE_MEDIA_NEXT";
                                break;
                            }
                            case 88: {
                                string = "KEYCODE_MEDIA_PREVIOUS";
                                break;
                            }
                            case 128: {
                                string = "KEYCODE_MEDIA_CLOSE";
                                break;
                            }
                            case 129: {
                                string = "KEYCODE_MEDIA_EJECT";
                                break;
                            }
                            case 130: {
                                string = "KEYCODE_MEDIA_RECORD";
                                break;
                            }
                            case 86: {
                                string = "KEYCODE_MEDIA_STOP";
                                break;
                            }
                            default: {
                                string = "KEYCODE_UNKNOW";
                            }
                        }
                        String keyText = string;
                        Bundle data = new Bundle();
                        data.putString("eventText", keyText);
                        data.putInt("eventCode", keyCode);
                        InCallManagerModule.access$sendEvent(this.this$0, "MediaButton", data);
                    }
                }
            };
            if (this.activity != null) {
                this.activity.registerReceiver(this.mediaButtonReceiver, filter);
            } else {
                Log.d((String)"InCallManager", (String)"startMediaButtonEvent() reactContext is null");
            }
        }
    }

    private final void stopMediaButtonEvent() {
        if (this.mediaButtonReceiver != null) {
            Log.d((String)"InCallManager", (String)"stopMediaButtonEvent()");
            this.unregisterReceiver(this.mediaButtonReceiver);
            this.mediaButtonReceiver = null;
        }
    }

    public final void onProximitySensorChangedState(boolean isNear) {
        if (this.automatic && this.selectedAudioDevice == AudioDevice.EARPIECE) {
            if (isNear) {
                this.turnScreenOff();
            } else {
                this.turnScreenOn();
            }
            this.updateAudioRoute();
        }
        Bundle data = new Bundle();
        data.putBoolean("isNear", isNear);
        this.sendEvent("Proximity", data);
    }

    public final void startProximitySensor() {
        if (!this.proximityManager.isProximitySupported()) {
            Log.d((String)"InCallManager", (String)"Proximity Sensor is not supported.");
            return;
        }
        if (this.isProximityRegistered) {
            Log.d((String)"InCallManager", (String)"Proximity Sensor is already registered.");
            return;
        }
        if (!this.proximityManager.start()) {
            Log.d((String)"InCallManager", (String)"proximityManager.start() failed. return false");
            return;
        }
        Log.d((String)"InCallManager", (String)"startProximitySensor()");
        this.isProximityRegistered = true;
    }

    public final void stopProximitySensor() {
        if (!this.proximityManager.isProximitySupported()) {
            Log.d((String)"InCallManager", (String)"Proximity Sensor is not supported.");
            return;
        }
        if (!this.isProximityRegistered) {
            Log.d((String)"InCallManager", (String)"Proximity Sensor is not registered.");
            return;
        }
        Log.d((String)"InCallManager", (String)"stopProximitySensor()");
        this.proximityManager.stop();
        this.isProximityRegistered = false;
    }

    public void onAudioFocusChange(int focusChange) {
        String string;
        String focusChangeStr = null;
        switch (focusChange) {
            case 1: {
                string = "AUDIOFOCUS_GAIN";
                break;
            }
            case 2: {
                string = "AUDIOFOCUS_GAIN_TRANSIENT";
                break;
            }
            case 4: {
                string = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                break;
            }
            case 3: {
                string = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                break;
            }
            case -1: {
                string = "AUDIOFOCUS_LOSS";
                break;
            }
            case -2: {
                string = "AUDIOFOCUS_LOSS_TRANSIENT";
                break;
            }
            case -3: {
                string = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                break;
            }
            case 0: {
                string = "AUDIOFOCUS_NONE";
                break;
            }
            default: {
                string = "AUDIOFOCUS_UNKNOW";
            }
        }
        focusChangeStr = string;
        Log.d((String)"InCallManager", (String)("onAudioFocusChange(): " + focusChange + " - " + focusChangeStr));
        Bundle data = new Bundle();
        data.putString("eventText", focusChangeStr);
        data.putInt("eventCode", focusChange);
        this.sendEvent("onAudioFocusChange", data);
    }

    private final void sendEvent(String eventName, Object params) {
        try {
            this.inCallManagerEventCallbacks.onEvent(eventName, params);
        }
        catch (RuntimeException e) {
            Log.e((String)"InCallManager", (String)"sendEvent(): java.lang.RuntimeException: Trying to invoke JS before CatalystInstance has been set!");
        }
    }

    public final void start(@NotNull String _media, boolean auto, @NotNull String ringbackUriType) {
        Intrinsics.checkNotNullParameter((Object)_media, (String)"_media");
        Intrinsics.checkNotNullParameter((Object)ringbackUriType, (String)"ringbackUriType");
        this.media = _media;
        this.defaultSpeakerOn = Intrinsics.areEqual((Object)this.media, (Object)"video");
        this.automatic = auto;
        if (!this.audioManagerActivated) {
            this.audioManagerActivated = true;
            Log.d((String)"InCallManager", (String)"start audioRouteManager");
            this.wakeLockUtils.acquirePartialWakeLock();
            if (this.mRingtone != null) {
                MyPlayerInterface myPlayerInterface = this.mRingtone;
                Intrinsics.checkNotNull((Object)myPlayerInterface);
                if (myPlayerInterface.isMediaPlaying()) {
                    Log.d((String)"InCallManager", (String)"stop ringtone");
                    this.stopRingtone();
                }
            }
            this.storeOriginalAudioSetup();
            this.requestAudioFocus();
            this.startEvents();
            AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
            Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
            appRTCBluetoothManager.start();
            this.audioManager.setMode(this.defaultAudioMode);
            this.setSpeakerphoneOn(this.defaultSpeakerOn);
            this.setMicrophoneMute(false);
            this.forceSpeakerOn = 0;
            this.hasWiredHeadset = this.hasWiredHeadset();
            this.defaultAudioDevice = this.defaultSpeakerOn ? AudioDevice.SPEAKER_PHONE : (this.hasEarpiece() ? AudioDevice.EARPIECE : AudioDevice.SPEAKER_PHONE);
            this.userSelectedAudioDevice = AudioDevice.NONE;
            this.selectedAudioDevice = AudioDevice.NONE;
            this.audioDevices.clear();
            this.updateAudioRoute();
            if (!(((CharSequence)ringbackUriType).length() == 0)) {
                this.startRingback(ringbackUriType);
            }
        } else {
            Log.d((String)"InCallManager", (String)"not starting");
        }
    }

    @JvmOverloads
    public final void stop(@NotNull String busytoneUriType) {
        Intrinsics.checkNotNullParameter((Object)busytoneUriType, (String)"busytoneUriType");
        if (this.audioManagerActivated) {
            this.stopRingback();
            if (!(((CharSequence)busytoneUriType).length() == 0) && this.startBusytone(busytoneUriType)) {
                Log.d((String)"InCallManager", (String)"play busytone before stop InCallManager");
                return;
            }
            Log.d((String)"InCallManager", (String)"stop() InCallManager");
            this.stopBusytone();
            this.stopEvents();
            this.setSpeakerphoneOn(false);
            this.setMicrophoneMute(false);
            this.forceSpeakerOn = 0;
            AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
            Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
            appRTCBluetoothManager.stop();
            this.restoreOriginalAudioSetup();
            this.abandonAudioFocus();
            this.audioManagerActivated = false;
            this.wakeLockUtils.releasePartialWakeLock();
        }
    }

    public static /* synthetic */ void stop$default(InCallManagerModule inCallManagerModule, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        inCallManagerModule.stop(string);
    }

    private final void startEvents() {
        this.startWiredHeadsetEvent();
        this.startNoisyAudioEvent();
        this.startMediaButtonEvent();
        this.startProximitySensor();
        this.setKeepScreenOn(true);
    }

    private final void stopEvents() {
        this.stopWiredHeadsetEvent();
        this.stopNoisyAudioEvent();
        this.stopMediaButtonEvent();
        this.stopProximitySensor();
        this.setKeepScreenOn(false);
        this.turnScreenOn();
    }

    private final String requestAudioFocus() {
        String requestAudioFocusResStr = Build.VERSION.SDK_INT >= 26 ? this.requestAudioFocusV26() : this.requestAudioFocusOld();
        Log.d((String)"InCallManager", (String)("requestAudioFocus(): res = " + requestAudioFocusResStr));
        return requestAudioFocusResStr;
    }

    @RequiresApi(api=26)
    private final String requestAudioFocusV26() {
        if (this.isAudioFocused) {
            return "";
        }
        if (this.mAudioAttributes == null) {
            this.mAudioAttributes = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
        }
        if (this.mAudioFocusRequest == null) {
            AudioFocusRequest.Builder builder = new AudioFocusRequest.Builder(2);
            AudioAttributes audioAttributes = this.mAudioAttributes;
            Intrinsics.checkNotNull((Object)audioAttributes);
            this.mAudioFocusRequest = builder.setAudioAttributes(audioAttributes).setAcceptsDelayedFocusGain(false).setWillPauseWhenDucked(false).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this).build();
        }
        AudioFocusRequest audioFocusRequest = this.mAudioFocusRequest;
        Intrinsics.checkNotNull((Object)audioFocusRequest);
        int requestAudioFocusRes = this.audioManager.requestAudioFocus(audioFocusRequest);
        String requestAudioFocusResStr = null;
        switch (requestAudioFocusRes) {
            case 0: {
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_FAILED";
                break;
            }
            case 1: {
                this.isAudioFocused = true;
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_GRANTED";
                break;
            }
            case 2: {
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_DELAYED";
                break;
            }
            default: {
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_UNKNOWN";
            }
        }
        return requestAudioFocusResStr;
    }

    private final String requestAudioFocusOld() {
        if (this.isAudioFocused) {
            return "";
        }
        int requestAudioFocusRes = this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 0, 2);
        String requestAudioFocusResStr = null;
        switch (requestAudioFocusRes) {
            case 0: {
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_FAILED";
                break;
            }
            case 1: {
                this.isAudioFocused = true;
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_GRANTED";
                break;
            }
            default: {
                requestAudioFocusResStr = "AUDIOFOCUS_REQUEST_UNKNOWN";
            }
        }
        return requestAudioFocusResStr;
    }

    private final String abandonAudioFocus() {
        String abandonAudioFocusResStr = Build.VERSION.SDK_INT >= 26 ? this.abandonAudioFocusV26() : this.abandonAudioFocusOld();
        Log.d((String)"InCallManager", (String)("abandonAudioFocus(): res = " + abandonAudioFocusResStr));
        return abandonAudioFocusResStr;
    }

    @RequiresApi(api=26)
    private final String abandonAudioFocusV26() {
        if (!this.isAudioFocused || this.mAudioFocusRequest == null) {
            return "";
        }
        AudioFocusRequest audioFocusRequest = this.mAudioFocusRequest;
        Intrinsics.checkNotNull((Object)audioFocusRequest);
        int abandonAudioFocusRes = this.audioManager.abandonAudioFocusRequest(audioFocusRequest);
        String abandonAudioFocusResStr = null;
        switch (abandonAudioFocusRes) {
            case 0: {
                abandonAudioFocusResStr = "AUDIOFOCUS_REQUEST_FAILED";
                break;
            }
            case 1: {
                this.isAudioFocused = false;
                abandonAudioFocusResStr = "AUDIOFOCUS_REQUEST_GRANTED";
                break;
            }
            default: {
                abandonAudioFocusResStr = "AUDIOFOCUS_REQUEST_UNKNOWN";
            }
        }
        return abandonAudioFocusResStr;
    }

    private final String abandonAudioFocusOld() {
        if (!this.isAudioFocused) {
            return "";
        }
        int abandonAudioFocusRes = this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
        String abandonAudioFocusResStr = null;
        switch (abandonAudioFocusRes) {
            case 0: {
                abandonAudioFocusResStr = "AUDIOFOCUS_REQUEST_FAILED";
                break;
            }
            case 1: {
                this.isAudioFocused = false;
                abandonAudioFocusResStr = "AUDIOFOCUS_REQUEST_GRANTED";
                break;
            }
            default: {
                abandonAudioFocusResStr = "AUDIOFOCUS_REQUEST_UNKNOWN";
            }
        }
        return abandonAudioFocusResStr;
    }

    public final void turnScreenOn() {
        if (this.proximityManager.isProximityWakeLockSupported()) {
            Log.d((String)"InCallManager", (String)"turnScreenOn(): use proximity lock.");
            this.proximityManager.releaseProximityWakeLock(true);
        } else {
            Log.d((String)"InCallManager", (String)"turnScreenOn(): proximity lock is not supported. try manually.");
            this.manualTurnScreenOn();
        }
    }

    public final void turnScreenOff() {
        if (this.proximityManager.isProximityWakeLockSupported()) {
            Log.d((String)"InCallManager", (String)"turnScreenOff(): use proximity lock.");
            this.proximityManager.acquireProximityWakeLock();
        } else {
            Log.d((String)"InCallManager", (String)"turnScreenOff(): proximity lock is not supported. try manually.");
            this.manualTurnScreenOff();
        }
    }

    public final void setKeepScreenOn(boolean enable) {
        Log.d((String)"InCallManager", (String)("setKeepScreenOn() " + enable));
        if (this.activity == null) {
            Log.d((String)"InCallManager", (String)"ReactContext doesn't hava any Activity attached.");
            return;
        }
        Window window = this.activity.getWindow();
        if (enable) {
            window.addFlags(128);
        } else {
            window.clearFlags(128);
        }
    }

    public final void setSpeakerphoneOn(boolean enable) {
        if (enable != this.audioManager.isSpeakerphoneOn()) {
            Log.d((String)"InCallManager", (String)("setSpeakerphoneOn(): " + enable));
            this.audioManager.setSpeakerphoneOn(enable);
        }
    }

    public final void setForceSpeakerphoneOn(int flag) {
        if (flag < -1 || flag > 1) {
            return;
        }
        Log.d((String)"InCallManager", (String)("setForceSpeakerphoneOn() flag: " + flag));
        this.forceSpeakerOn = flag;
        switch (flag) {
            case 1: {
                this.selectAudioDevice(AudioDevice.SPEAKER_PHONE);
                break;
            }
            case -1: {
                this.selectAudioDevice(AudioDevice.EARPIECE);
                break;
            }
            default: {
                this.selectAudioDevice(AudioDevice.NONE);
            }
        }
    }

    public final void setMicrophoneMute(boolean enable) {
        if (enable != this.audioManager.isMicrophoneMute()) {
            Log.d((String)"InCallManager", (String)("setMicrophoneMute(): " + enable));
            this.audioManager.setMicrophoneMute(enable);
        }
    }

    public final void startRingback(@NotNull String ringbackUriType) {
        Intrinsics.checkNotNullParameter((Object)ringbackUriType, (String)"ringbackUriType");
        if (((CharSequence)ringbackUriType).length() == 0) {
            return;
        }
        try {
            Log.d((String)"InCallManager", (String)("startRingback(): UriType=" + ringbackUriType));
            if (this.mRingback != null) {
                MyPlayerInterface myPlayerInterface = this.mRingback;
                Intrinsics.checkNotNull((Object)myPlayerInterface);
                if (myPlayerInterface.isMediaPlaying()) {
                    Log.d((String)"InCallManager", (String)"startRingback(): is already playing");
                    return;
                }
                this.stopRingback();
            }
            Uri ringbackUri = null;
            Map data = new HashMap();
            data.put("name", "mRingback");
            if (Intrinsics.areEqual((Object)ringbackUriType, (Object)"_DTMF_")) {
                MyPlayerInterface myPlayerInterface = this.mRingback = (MyPlayerInterface)new DyteToneGenerator(105);
                Intrinsics.checkNotNull((Object)myPlayerInterface, (String)"null cannot be cast to non-null type io.dyte.core.incallmanager.InCallManagerModule.DyteToneGenerator");
                ((DyteToneGenerator)myPlayerInterface).startPlay(MapsKt.toMap((Map)data));
                return;
            }
            ringbackUri = this.getRingbackUri(ringbackUriType);
            if (ringbackUri == null) {
                Log.d((String)"InCallManager", (String)"startRingback(): no available media");
                return;
            }
            this.mRingback = new DyteMediaPlayer();
            data.put("sourceUri", ringbackUri);
            data.put("setLooping", true);
            data.put("audioUsage", 2);
            data.put("audioContentType", 2);
            MyPlayerInterface myPlayerInterface = this.mRingback;
            Intrinsics.checkNotNull((Object)myPlayerInterface, (String)"null cannot be cast to non-null type android.media.MediaPlayer");
            this.setMediaPlayerEvents((MediaPlayer)myPlayerInterface, "mRingback");
            MyPlayerInterface myPlayerInterface2 = this.mRingback;
            Intrinsics.checkNotNull((Object)myPlayerInterface2, (String)"null cannot be cast to non-null type io.dyte.core.incallmanager.InCallManagerModule.DyteMediaPlayer");
            ((DyteMediaPlayer)myPlayerInterface2).startPlay(MapsKt.toMap((Map)data));
        }
        catch (Exception e) {
            Log.d((String)"InCallManager", (String)"startRingback() failed", (Throwable)e);
        }
    }

    public final void stopRingback() {
        try {
            if (this.mRingback != null) {
                MyPlayerInterface myPlayerInterface = this.mRingback;
                Intrinsics.checkNotNull((Object)myPlayerInterface);
                myPlayerInterface.stopPlay();
                this.mRingback = null;
            }
        }
        catch (Exception e) {
            Log.d((String)"InCallManager", (String)"stopRingback() failed");
        }
    }

    public final boolean startBusytone(@NotNull String busytoneUriType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)busytoneUriType, (String)"busytoneUriType");
        if (((CharSequence)busytoneUriType).length() == 0) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Log.d((String)"InCallManager", (String)("startBusytone(): UriType=" + busytoneUriType));
                if (this.mBusytone != null) {
                    MyPlayerInterface myPlayerInterface = this.mBusytone;
                    Intrinsics.checkNotNull((Object)myPlayerInterface);
                    if (myPlayerInterface.isMediaPlaying()) {
                        Log.d((String)"InCallManager", (String)"startBusytone(): is already playing");
                        return false;
                    }
                    this.stopBusytone();
                }
                Uri busytoneUri = null;
                Map data = new HashMap();
                data.put("name", "mBusytone");
                if (Intrinsics.areEqual((Object)busytoneUriType, (Object)"_DTMF_")) {
                    MyPlayerInterface myPlayerInterface = this.mBusytone = (MyPlayerInterface)new DyteToneGenerator(102);
                    Intrinsics.checkNotNull((Object)myPlayerInterface, (String)"null cannot be cast to non-null type io.dyte.core.incallmanager.InCallManagerModule.DyteToneGenerator");
                    ((DyteToneGenerator)myPlayerInterface).startPlay(MapsKt.toMap((Map)data));
                    return true;
                }
                busytoneUri = this.getBusytoneUri(busytoneUriType);
                if (busytoneUri == null) {
                    Log.d((String)"InCallManager", (String)"startBusytone(): no available media");
                    return false;
                }
                this.mBusytone = new DyteMediaPlayer();
                data.put("sourceUri", busytoneUri);
                data.put("setLooping", false);
                data.put("audioUsage", 2);
                data.put("audioContentType", 4);
                MyPlayerInterface myPlayerInterface = this.mBusytone;
                Intrinsics.checkNotNull((Object)myPlayerInterface, (String)"null cannot be cast to non-null type android.media.MediaPlayer");
                this.setMediaPlayerEvents((MediaPlayer)myPlayerInterface, "mBusytone");
                MyPlayerInterface myPlayerInterface2 = this.mBusytone;
                Intrinsics.checkNotNull((Object)myPlayerInterface2, (String)"null cannot be cast to non-null type io.dyte.core.incallmanager.InCallManagerModule.DyteMediaPlayer");
                ((DyteMediaPlayer)myPlayerInterface2).startPlay(MapsKt.toMap((Map)data));
                bl2 = true;
            }
            catch (Exception e) {
                Log.d((String)"InCallManager", (String)"startBusytone() failed", (Throwable)e);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final void stopBusytone() {
        try {
            if (this.mBusytone != null) {
                MyPlayerInterface myPlayerInterface = this.mBusytone;
                Intrinsics.checkNotNull((Object)myPlayerInterface);
                myPlayerInterface.stopPlay();
                this.mBusytone = null;
            }
        }
        catch (Exception e) {
            Log.d((String)"InCallManager", (String)"stopBusytone() failed");
        }
    }

    private final void stopRingtone() {
        Thread thread2 = new Thread(this){
            final /* synthetic */ InCallManagerModule this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                try {
                    if (InCallManagerModule.access$getMRingtone$p(this.this$0) != null) {
                        MyPlayerInterface myPlayerInterface = InCallManagerModule.access$getMRingtone$p(this.this$0);
                        Intrinsics.checkNotNull((Object)myPlayerInterface);
                        myPlayerInterface.stopPlay();
                        InCallManagerModule.access$setMRingtone$p(this.this$0, null);
                        InCallManagerModule.access$restoreOriginalAudioSetup(this.this$0);
                    }
                    if (InCallManagerModule.access$getMRingtoneCountDownHandler$p(this.this$0) != null) {
                        Handler handler = InCallManagerModule.access$getMRingtoneCountDownHandler$p(this.this$0);
                        Intrinsics.checkNotNull((Object)handler);
                        handler.removeCallbacksAndMessages(null);
                        InCallManagerModule.access$setMRingtoneCountDownHandler$p(this.this$0, null);
                    }
                }
                catch (Exception e) {
                    Log.d((String)"InCallManager", (String)"stopRingtone() failed");
                }
                InCallManagerModule.access$getWakeLockUtils$p(this.this$0).releasePartialWakeLock();
            }
        };
        thread2.start();
    }

    private final void setMediaPlayerEvents(MediaPlayer mp, String name) {
        mp.setOnErrorListener((arg_0, arg_1, arg_2) -> InCallManagerModule.setMediaPlayerEvents$lambda$0(name, arg_0, arg_1, arg_2));
        mp.setOnInfoListener((arg_0, arg_1, arg_2) -> InCallManagerModule.setMediaPlayerEvents$lambda$1(name, arg_0, arg_1, arg_2));
        mp.setOnPreparedListener(arg_0 -> InCallManagerModule.setMediaPlayerEvents$lambda$2(name, this, mp, arg_0));
        mp.setOnCompletionListener(arg_0 -> InCallManagerModule.setMediaPlayerEvents$lambda$3(name, this, arg_0));
    }

    private final Uri getRingtoneUri(String _type) {
        String fileBundle = "incallmanager_ringtone";
        String fileBundleExt = "mp3";
        String fileSysPath = "/system/media/audio/ui";
        if (Intrinsics.areEqual((Object)_type, (Object)"_DEFAULT_") || ((CharSequence)_type).length() == 0) {
            return this.getDefaultUserUri("defaultRingtoneUri");
        }
        String type = _type;
        return this.getAudioUri(fileBundleExt, type, fileBundle, fileSysPath, "bundleRingtoneUri", "defaultRingtoneUri");
    }

    private final Uri getRingbackUri(String _type) {
        String fileBundle = "incallmanager_ringback";
        String fileBundleExt = "mp3";
        String fileSysPath = "/system/media/audio/ui";
        if (Intrinsics.areEqual((Object)_type, (Object)"_DEFAULT_") || ((CharSequence)_type).length() == 0) {
            return this.getDefaultUserUri("defaultRingbackUri");
        }
        String type = _type;
        return this.getAudioUri(fileBundleExt, type, fileBundle, fileSysPath, "bundleRingbackUri", "defaultRingbackUri");
    }

    private final Uri getBusytoneUri(String _type) {
        String fileBundle = "incallmanager_busytone";
        String fileBundleExt = "mp3";
        String fileSysPath = "/system/media/audio/ui";
        if (Intrinsics.areEqual((Object)_type, (Object)"_DEFAULT_") || ((CharSequence)_type).length() == 0) {
            return this.getDefaultUserUri("defaultBusytoneUri");
        }
        String type = _type;
        return this.getAudioUri(fileBundleExt, type, fileBundle, fileSysPath, "bundleBusytoneUri", "defaultBusytoneUri");
    }

    @SuppressLint(value={"DiscouragedApi"})
    private final Uri getAudioUri(String $this$getAudioUri, String _type, String fileBundle, String fileSysPath, String uriBundle, String uriDefault) {
        Uri uri;
        if (Intrinsics.areEqual((Object)_type, (Object)"_BUNDLE_")) {
            Uri uri2;
            if (this.audioUriMap.get(uriBundle) == null) {
                int res = 0;
                if (this.activity != null) {
                    res = this.activity.getResources().getIdentifier(fileBundle, "raw", this.mPackageName);
                } else {
                    Log.d((String)"InCallManager", (String)"getAudioUri() reactContext is null");
                }
                if (res <= 0) {
                    String string = "getAudioUri() %s.%s not found in bundle.";
                    Object[] objectArray = new Object[]{fileBundle, $this$getAudioUri};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    Log.d((String)"InCallManager", (String)string2);
                    this.audioUriMap.put(uriBundle, null);
                    uri2 = this.getDefaultUserUri(uriDefault);
                } else {
                    this.audioUriMap.put(uriBundle, Uri.parse((String)("android.resource://" + this.mPackageName + '/' + res)));
                    Log.d((String)"InCallManager", (String)("getAudioUri() using: " + _type));
                    uri2 = this.audioUriMap.get(uriBundle);
                }
            } else {
                Log.d((String)"InCallManager", (String)("getAudioUri() using: " + _type));
                uri2 = this.audioUriMap.get(uriBundle);
            }
            return uri2;
        }
        String target = fileSysPath + '/' + _type;
        Uri _uri = this.getSysFileUri(target);
        if (_uri == null) {
            Log.d((String)"InCallManager", (String)"getAudioUri() using user default");
            uri = this.getDefaultUserUri(uriDefault);
        } else {
            Log.d((String)"InCallManager", (String)("getAudioUri() using internal: " + target));
            this.audioUriMap.put(uriDefault, _uri);
            uri = _uri;
        }
        return uri;
    }

    private final Uri getSysFileUri(String target) {
        File file = new File(target);
        return file.isFile() ? Uri.fromFile((File)file) : null;
    }

    /*
     * Unable to fully structure code
     */
    private final Uri getDefaultUserUri(String type) {
        block7: {
            block6: {
                switch (type.hashCode()) {
                    case 773102036: {
                        if (type.equals("defaultRingbackUri")) break;
                        ** break;
                    }
                    case 1460820352: {
                        if (!type.equals("defaultBusytoneUri")) {
                            ** break;
                        }
                        break block6;
                    }
                    case -20912791: {
                        if (!type.equals("defaultRingtoneUri")) ** break;
                        v0 = Settings.System.DEFAULT_RINGTONE_URI;
                        v1 = v0;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"{\n      System.DEFAULT_RINGTONE_URI\n    }");
                        break block7;
                    }
                }
                v2 = Settings.System.DEFAULT_RINGTONE_URI;
                v1 = v2;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"{\n      System.DEFAULT_RINGTONE_URI\n    }");
                break block7;
            }
            v3 = Settings.System.DEFAULT_NOTIFICATION_URI;
            v1 = v3;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"{\n      System.DEFAULT_N\u2026ULT_ALARM_ALERT_URI\n    }");
            break block7;
lbl24:
            // 4 sources

            v4 = Settings.System.DEFAULT_NOTIFICATION_URI;
            v1 = v4;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"{\n      System.DEFAULT_NOTIFICATION_URI\n    }");
        }
        return v1;
    }

    private final void updateAudioRoute() {
        if (!this.automatic) {
            return;
        }
        this.updateAudioDeviceState();
    }

    private final void setAudioDeviceInternal(AudioDevice device) {
        Log.d((String)"InCallManager", (String)("setAudioDeviceInternal(device=" + (Object)((Object)device) + ')'));
        if (!this.audioDevices.contains((Object)device)) {
            Log.e((String)"InCallManager", (String)"specified audio device does not exist");
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[device.ordinal()]) {
            case 1: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case 2: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case 3: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case 4: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                Log.e((String)"InCallManager", (String)"Invalid audio device selection");
            }
        }
        this.selectedAudioDevice = device;
    }

    public final void setDefaultAudioDevice(@Nullable AudioDevice defaultDevice) {
        AudioDevice audioDevice = defaultDevice;
        switch (audioDevice == null ? -1 : WhenMappings.$EnumSwitchMapping$0[audioDevice.ordinal()]) {
            case 1: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case 2: {
                this.defaultAudioDevice = this.hasEarpiece() ? defaultDevice : AudioDevice.SPEAKER_PHONE;
                break;
            }
            default: {
                Log.e((String)"InCallManager", (String)"Invalid default audio device selection");
            }
        }
        Log.d((String)"InCallManager", (String)("setDefaultAudioDevice(device=" + (Object)((Object)this.defaultAudioDevice) + ')'));
        this.updateAudioDeviceState();
    }

    public final void selectAudioDevice(@NotNull AudioDevice device) {
        Intrinsics.checkNotNullParameter((Object)((Object)device), (String)"device");
        if (device != AudioDevice.NONE && !this.audioDevices.contains((Object)device)) {
            Log.e((String)"InCallManager", (String)("selectAudioDevice() Can not select " + (Object)((Object)device) + " from available " + this.audioDevices));
            return;
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    @NotNull
    public final Set<AudioDevice> getAudioDevices() {
        Set<AudioDevice> set2 = Collections.unmodifiableSet(new HashSet(this.audioDevices));
        Intrinsics.checkNotNullExpressionValue(set2, (String)"unmodifiableSet(HashSet(audioDevices))");
        return set2;
    }

    private final void unregisterReceiver(BroadcastReceiver receiver) {
        if (this.activity != null) {
            try {
                this.activity.unregisterReceiver(receiver);
            }
            catch (Exception e) {
                Log.d((String)"InCallManager", (String)"unregisterReceiver() failed");
            }
        } else {
            Log.d((String)"InCallManager", (String)"unregisterReceiver() reactContext is null");
        }
    }

    private final boolean hasEarpiece() {
        Activity activity = this.activity;
        Intrinsics.checkNotNull((Object)activity);
        return activity.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private final boolean hasWiredHeadset() {
        boolean bl;
        if (Build.VERSION.SDK_INT < 23) {
            bl = this.audioManager.isWiredHeadsetOn();
        } else {
            AudioDeviceInfo[] devices = this.audioManager.getDevices(1);
            Intrinsics.checkNotNullExpressionValue((Object)devices, (String)"devices");
            for (AudioDeviceInfo device : devices) {
                int type = device.getType();
                switch (type) {
                    case 3: {
                        Log.d((String)"InCallManager", (String)"hasWiredHeadset: found wired headset");
                        return true;
                    }
                    case 11: {
                        Log.d((String)"InCallManager", (String)"hasWiredHeadset: found USB audio device");
                        return true;
                    }
                    case 4: {
                        Log.d((String)"InCallManager", (String)"hasWiredHeadset: found wired headphones");
                        return true;
                    }
                }
            }
            bl = false;
        }
        return bl;
    }

    public final void updateAudioDeviceState() {
        AudioDevice newAudioDevice;
        boolean audioDeviceSetUpdated;
        block23: {
            block24: {
                Set newAudioDevices;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                StringBuilder stringBuilder = new StringBuilder().append("--- updateAudioDeviceState: wired headset=").append(this.hasWiredHeadset).append(", BT state=");
                                AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
                                Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
                                Log.d((String)"InCallManager", (String)stringBuilder.append((Object)appRTCBluetoothManager.getState()).toString());
                                Log.d((String)"InCallManager", (String)("Device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice) + ", user selected=" + (Object)((Object)this.userSelectedAudioDevice)));
                                AppRTCBluetoothManager appRTCBluetoothManager2 = this.bluetoothManager;
                                Intrinsics.checkNotNull((Object)appRTCBluetoothManager2);
                                if (appRTCBluetoothManager2.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE) break block19;
                                AppRTCBluetoothManager appRTCBluetoothManager3 = this.bluetoothManager;
                                Intrinsics.checkNotNull((Object)appRTCBluetoothManager3);
                                if (appRTCBluetoothManager3.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE) break block19;
                                AppRTCBluetoothManager appRTCBluetoothManager4 = this.bluetoothManager;
                                Intrinsics.checkNotNull((Object)appRTCBluetoothManager4);
                                if (appRTCBluetoothManager4.getState() != AppRTCBluetoothManager.State.SCO_DISCONNECTING) break block20;
                            }
                            AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
                            Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
                            appRTCBluetoothManager.updateDevice();
                        }
                        newAudioDevices = new HashSet();
                        newAudioDevices.add(AudioDevice.SPEAKER_PHONE);
                        AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
                        Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
                        if (appRTCBluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED) break block21;
                        AppRTCBluetoothManager appRTCBluetoothManager5 = this.bluetoothManager;
                        Intrinsics.checkNotNull((Object)appRTCBluetoothManager5);
                        if (appRTCBluetoothManager5.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING) break block21;
                        AppRTCBluetoothManager appRTCBluetoothManager6 = this.bluetoothManager;
                        Intrinsics.checkNotNull((Object)appRTCBluetoothManager6);
                        if (appRTCBluetoothManager6.getState() != AppRTCBluetoothManager.State.HEADSET_AVAILABLE) break block22;
                    }
                    newAudioDevices.add(AudioDevice.BLUETOOTH);
                }
                if (this.hasWiredHeadset) {
                    newAudioDevices.add(AudioDevice.WIRED_HEADSET);
                }
                if (this.hasEarpiece()) {
                    newAudioDevices.add(AudioDevice.EARPIECE);
                }
                if (this.userSelectedAudioDevice != null && this.userSelectedAudioDevice != AudioDevice.NONE && !CollectionsKt.contains((Iterable)newAudioDevices, (Object)((Object)this.userSelectedAudioDevice))) {
                    this.userSelectedAudioDevice = AudioDevice.NONE;
                }
                audioDeviceSetUpdated = !Intrinsics.areEqual(this.audioDevices, (Object)newAudioDevices);
                this.audioDevices = newAudioDevices;
                newAudioDevice = this.getPreferredAudioDevice();
                if (this.selectedAudioDevice != AudioDevice.BLUETOOTH || newAudioDevice == AudioDevice.BLUETOOTH) break block23;
                AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
                Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
                if (appRTCBluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED) break block24;
                AppRTCBluetoothManager appRTCBluetoothManager7 = this.bluetoothManager;
                Intrinsics.checkNotNull((Object)appRTCBluetoothManager7);
                if (appRTCBluetoothManager7.getState() != AppRTCBluetoothManager.State.SCO_CONNECTING) break block23;
            }
            AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
            Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
            appRTCBluetoothManager.stopScoAudio();
            AppRTCBluetoothManager appRTCBluetoothManager8 = this.bluetoothManager;
            Intrinsics.checkNotNull((Object)appRTCBluetoothManager8);
            appRTCBluetoothManager8.updateDevice();
        }
        if (this.selectedAudioDevice != AudioDevice.BLUETOOTH && newAudioDevice == AudioDevice.BLUETOOTH) {
            AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
            Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
            if (appRTCBluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE) {
                AppRTCBluetoothManager appRTCBluetoothManager9 = this.bluetoothManager;
                Intrinsics.checkNotNull((Object)appRTCBluetoothManager9);
                if (!appRTCBluetoothManager9.startScoAudio()) {
                    this.audioDevices.remove((Object)AudioDevice.BLUETOOTH);
                    audioDeviceSetUpdated = true;
                    if (this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
                        this.userSelectedAudioDevice = AudioDevice.NONE;
                    }
                    newAudioDevice = this.getPreferredAudioDevice();
                }
            }
        }
        if (newAudioDevice == AudioDevice.BLUETOOTH) {
            AppRTCBluetoothManager appRTCBluetoothManager = this.bluetoothManager;
            Intrinsics.checkNotNull((Object)appRTCBluetoothManager);
            if (appRTCBluetoothManager.getState() != AppRTCBluetoothManager.State.SCO_CONNECTED) {
                newAudioDevice = this.getPreferredAudioDevice(true);
            }
        }
        if (newAudioDevice != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            Log.d((String)"InCallManager", (String)("New device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)newAudioDevice)));
            this.sendEvent("onAudioDeviceChanged", this.getAudioDeviceStatusMap());
        }
        Log.d((String)"InCallManager", (String)"--- updateAudioDeviceState done");
    }

    private final Bundle getAudioDeviceStatusMap() {
        String string;
        Bundle data = new Bundle();
        String audioDevicesJson = "[";
        for (AudioDevice s : this.audioDevices) {
            audioDevicesJson = audioDevicesJson + '\"' + s.name() + "\",";
        }
        if (audioDevicesJson.length() > 1) {
            String string2 = audioDevicesJson.substring(0, audioDevicesJson.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            audioDevicesJson = string2;
        }
        audioDevicesJson = audioDevicesJson + ']';
        data.putString("availableAudioDeviceList", audioDevicesJson);
        if (this.selectedAudioDevice == null) {
            string = "";
        } else {
            AudioDevice audioDevice = this.selectedAudioDevice;
            Intrinsics.checkNotNull((Object)((Object)audioDevice));
            string = audioDevice.name();
        }
        data.putString("selectedAudioDevice", string);
        return data;
    }

    private final AudioDevice getPreferredAudioDevice() {
        return this.getPreferredAudioDevice(false);
    }

    private final AudioDevice getPreferredAudioDevice(boolean skipBluetooth) {
        AudioDevice audioDevice;
        if (this.userSelectedAudioDevice != null && this.userSelectedAudioDevice != AudioDevice.NONE) {
            AudioDevice audioDevice2 = this.userSelectedAudioDevice;
            audioDevice = audioDevice2;
            Intrinsics.checkNotNull((Object)((Object)audioDevice2));
        } else {
            audioDevice = !skipBluetooth && this.audioDevices.contains((Object)AudioDevice.BLUETOOTH) ? AudioDevice.BLUETOOTH : (this.audioDevices.contains((Object)AudioDevice.WIRED_HEADSET) ? AudioDevice.WIRED_HEADSET : (this.audioDevices.contains((Object)this.defaultAudioDevice) ? this.defaultAudioDevice : AudioDevice.SPEAKER_PHONE));
        }
        AudioDevice newAudioDevice = audioDevice;
        return newAudioDevice;
    }

    @JvmOverloads
    public final void stop() {
        InCallManagerModule.stop$default(this, null, 1, null);
    }

    private static final boolean setMediaPlayerEvents$lambda$0(String $name, MediaPlayer mediaPlayer, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        String string = "MediaPlayer %s onError(). what: %d, extra: %d";
        Object[] objectArray = new Object[]{$name, what, extra};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        Log.d((String)"InCallManager", (String)string2);
        return true;
    }

    private static final boolean setMediaPlayerEvents$lambda$1(String $name, MediaPlayer mediaPlayer, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        String string = "MediaPlayer %s onInfo(). what: %d, extra: %d";
        Object[] objectArray = new Object[]{$name, what, extra};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        Log.d((String)"InCallManager", (String)string2);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final void setMediaPlayerEvents$lambda$2(String $name, InCallManagerModule this$0, MediaPlayer $mp, MediaPlayer it) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$mp, (String)"$mp");
            var5_4 = "MediaPlayer %s onPrepared(), start play, isSpeakerPhoneOn %b";
            var6_5 = new Object[]{$name, this$0.audioManager.isSpeakerphoneOn()};
            v0 = String.format(var5_4, Arrays.copyOf(var6_5, var6_5.length));
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"format(format, *args)");
            Log.d((String)"InCallManager", (String)v0);
            var4_6 = $name;
            switch (var4_6.hashCode()) {
                case -616530268: {
                    if (var4_6.equals("mRingback")) break;
                    ** break;
                }
                case -615980241: {
                    if (!var4_6.equals("mRingtone")) {
                        ** break;
                    }
                    break block6;
                }
                case -511263112: {
                    if (!var4_6.equals("mBusytone")) ** break;
                    this$0.audioManager.setMode(3);
                    ** break;
                }
            }
            this$0.audioManager.setMode(3);
            ** break;
        }
        this$0.audioManager.setMode(1);
lbl28:
        // 7 sources

        this$0.updateAudioRoute();
        $mp.start();
    }

    private static final void setMediaPlayerEvents$lambda$3(String $name, InCallManagerModule this$0, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = "MediaPlayer %s onCompletion()";
        Object[] objectArray = new Object[]{$name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        Log.d((String)"InCallManager", (String)string2);
        if (Intrinsics.areEqual((Object)$name, (Object)"mBusytone")) {
            Log.d((String)"InCallManager", (String)"MyMediaPlayer(): invoke stop()");
            InCallManagerModule.stop$default(this$0, null, 1, null);
        }
    }

    public static final /* synthetic */ void access$setHasWiredHeadset$p(InCallManagerModule $this, boolean bl) {
        $this.hasWiredHeadset = bl;
    }

    public static final /* synthetic */ void access$updateAudioRoute(InCallManagerModule $this) {
        $this.updateAudioRoute();
    }

    public static final /* synthetic */ void access$sendEvent(InCallManagerModule $this, String eventName, Object params) {
        $this.sendEvent(eventName, params);
    }

    public static final /* synthetic */ MyPlayerInterface access$getMRingtone$p(InCallManagerModule $this) {
        return $this.mRingtone;
    }

    public static final /* synthetic */ void access$setMRingtone$p(InCallManagerModule $this, MyPlayerInterface myPlayerInterface) {
        $this.mRingtone = myPlayerInterface;
    }

    public static final /* synthetic */ void access$restoreOriginalAudioSetup(InCallManagerModule $this) {
        $this.restoreOriginalAudioSetup();
    }

    public static final /* synthetic */ Handler access$getMRingtoneCountDownHandler$p(InCallManagerModule $this) {
        return $this.mRingtoneCountDownHandler;
    }

    public static final /* synthetic */ void access$setMRingtoneCountDownHandler$p(InCallManagerModule $this, Handler handler) {
        $this.mRingtoneCountDownHandler = handler;
    }

    public static final /* synthetic */ InCallWakeLockUtils access$getWakeLockUtils$p(InCallManagerModule $this) {
        return $this.wakeLockUtils;
    }

    public static final /* synthetic */ AudioManager access$getAudioManager$p(InCallManagerModule $this) {
        return $this.audioManager;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule$AudioDevice;", "", "(Ljava/lang/String;I)V", "SPEAKER_PHONE", "WIRED_HEADSET", "EARPIECE", "BLUETOOTH", "NONE", "shared_debug"})
    public static final class AudioDevice
    extends Enum<AudioDevice> {
        public static final /* enum */ AudioDevice SPEAKER_PHONE = new AudioDevice();
        public static final /* enum */ AudioDevice WIRED_HEADSET = new AudioDevice();
        public static final /* enum */ AudioDevice EARPIECE = new AudioDevice();
        public static final /* enum */ AudioDevice BLUETOOTH = new AudioDevice();
        public static final /* enum */ AudioDevice NONE = new AudioDevice();
        private static final /* synthetic */ AudioDevice[] $VALUES;

        public static AudioDevice[] values() {
            return (AudioDevice[])$VALUES.clone();
        }

        public static AudioDevice valueOf(String value) {
            return Enum.valueOf(AudioDevice.class, value);
        }

        static {
            $VALUES = audioDeviceArray = new AudioDevice[]{AudioDevice.SPEAKER_PHONE, AudioDevice.WIRED_HEADSET, AudioDevice.EARPIECE, AudioDevice.BLUETOOTH, AudioDevice.NONE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule$AudioManagerState;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "PREINITIALIZED", "RUNNING", "shared_debug"})
    public static final class AudioManagerState
    extends Enum<AudioManagerState> {
        public static final /* enum */ AudioManagerState UNINITIALIZED = new AudioManagerState();
        public static final /* enum */ AudioManagerState PREINITIALIZED = new AudioManagerState();
        public static final /* enum */ AudioManagerState RUNNING = new AudioManagerState();
        private static final /* synthetic */ AudioManagerState[] $VALUES;

        public static AudioManagerState[] values() {
            return (AudioManagerState[])$VALUES.clone();
        }

        public static AudioManagerState valueOf(String value) {
            return Enum.valueOf(AudioManagerState.class, value);
        }

        static {
            $VALUES = audioManagerStateArray = new AudioManagerState[]{AudioManagerState.UNINITIALIZED, AudioManagerState.PREINITIALIZED, AudioManagerState.RUNNING};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\"\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\bH&J\b\u0010\n\u001a\u00020\u0006H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u000b"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule$MyPlayerInterface;", "", "isMediaPlaying", "", "()Z", "startPlay", "", "data", "", "", "stopPlay", "shared_debug"})
    public static interface MyPlayerInterface {
        public boolean isMediaPlaying();

        public void startPlay(@Nullable Map<String, ? extends Object> var1);

        public void stopPlay();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00172\u0018\u0010\u0019\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule$DyteToneGenerator;", "Ljava/lang/Thread;", "Lio/dyte/core/incallmanager/InCallManagerModule$MyPlayerInterface;", "toneCategory", "", "(Lio/dyte/core/incallmanager/InCallManagerModule;I)V", "caller", "", "getCaller", "()Ljava/lang/String;", "setCaller", "(Ljava/lang/String;)V", "customWaitTimeMs", "getCustomWaitTimeMs", "()I", "setCustomWaitTimeMs", "(I)V", "<set-?>", "", "isMediaPlaying", "()Z", "toneType", "run", "", "startPlay", "data", "", "", "stopPlay", "shared_debug"})
    private final class DyteToneGenerator
    extends Thread
    implements MyPlayerInterface {
        private final int toneCategory;
        private int toneType;
        private boolean isMediaPlaying;
        private int customWaitTimeMs;
        @Nullable
        private String caller;

        public DyteToneGenerator(int toneCategory) {
            this.toneCategory = toneCategory;
            this.customWaitTimeMs = 3600000;
        }

        @Override
        public boolean isMediaPlaying() {
            return this.isMediaPlaying;
        }

        public final int getCustomWaitTimeMs() {
            return this.customWaitTimeMs;
        }

        public final void setCustomWaitTimeMs(int n) {
            this.customWaitTimeMs = n;
        }

        @Nullable
        public final String getCaller() {
            return this.caller;
        }

        public final void setCaller(@Nullable String string) {
            this.caller = string;
        }

        @Override
        public void startPlay(@Nullable Map<String, ? extends Object> data) {
            String name;
            Map<String, ? extends Object> map = data;
            this.caller = name = (String)(map != null ? map.get("name") : null);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopPlay() {
            DyteToneGenerator dyteToneGenerator = this;
            synchronized (dyteToneGenerator) {
                boolean bl = false;
                if (this.isMediaPlaying()) {
                    DyteToneGenerator $this$notify$iv = this;
                    boolean $i$f$notify = false;
                    $this$notify$iv.notify();
                }
                this.isMediaPlaying = false;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            block22: {
                toneWaitTimeMs = 0;
                switch (this.toneCategory) {
                    case 106: {
                        this.toneType = 42;
                        toneWaitTimeMs = 1000;
                        break;
                    }
                    case 102: {
                        this.toneType = 20;
                        toneWaitTimeMs = 4000;
                        break;
                    }
                    case 105: {
                        this.toneType = 35;
                        toneWaitTimeMs = 3600000;
                        break;
                    }
                    case 103: {
                        this.toneType = 27;
                        toneWaitTimeMs = 200;
                        break;
                    }
                    case 104: {
                        this.toneType = 22;
                        toneWaitTimeMs = 3600000;
                        break;
                    }
                    case 101: {
                        this.toneType = 28;
                        toneWaitTimeMs = 1000;
                        break;
                    }
                    default: {
                        Log.d((String)"InCallManager", (String)("myToneGenerator: use internal tone type: " + this.toneCategory));
                        this.toneType = this.toneCategory;
                        toneWaitTimeMs = this.customWaitTimeMs;
                    }
                }
                var3_2 = "myToneGenerator: toneCategory: %d ,toneType: %d, toneWaitTimeMs: %d";
                var4_3 /* !! */  = new Object[]{this.toneCategory, this.toneType, toneWaitTimeMs};
                v0 = String.format((String)var3_2, Arrays.copyOf(var4_3 /* !! */ , var4_3 /* !! */ .length));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"format(format, *args)");
                Log.d((String)"InCallManager", (String)v0);
                try {
                    var3_2 = new ToneGenerator(0, 100);
                }
                catch (RuntimeException e) {
                    Log.d((String)"InCallManager", (String)("myToneGenerator: Exception caught while creating ToneGenerator: " + e));
                    var3_2 = null;
                }
                tg = var3_2;
                if (tg == null) break block22;
                var3_2 = InCallManagerModule.this;
                var4_3 /* !! */  = this;
                synchronized (var4_3 /* !! */ ) {
                    block23: {
                        block24: {
                            block25: {
                                $i$a$-synchronized-InCallManagerModule$DyteToneGenerator$run$1 = false;
                                if (this.isMediaPlaying()) break block23;
                                this.isMediaPlaying = true;
                                var6_9 = this.caller;
                                if (var6_9 == null) break block24;
                                switch (var6_9.hashCode()) {
                                    case -616530268: {
                                        if (var6_9.equals("mRingback")) break;
                                        ** break;
                                    }
                                    case -615980241: {
                                        if (!var6_9.equals("mRingtone")) {
                                            ** break;
                                        }
                                        break block25;
                                    }
                                    case -511263112: {
                                        if (!var6_9.equals("mBusytone")) ** break;
                                        InCallManagerModule.access$getAudioManager$p((InCallManagerModule)var3_2).setMode(3);
                                        ** break;
                                    }
                                }
                                InCallManagerModule.access$getAudioManager$p((InCallManagerModule)var3_2).setMode(3);
                                ** break;
                            }
                            InCallManagerModule.access$getAudioManager$p((InCallManagerModule)var3_2).setMode(1);
                        }
                        InCallManagerModule.access$updateAudioRoute((InCallManagerModule)var3_2);
                        tg.startTone(this.toneType);
                        try {
                            Thread.sleep(toneWaitTimeMs + 20);
                        }
                        catch (InterruptedException e) {
                            Log.d((String)"InCallManager", (String)("myToneGenerator stopped. toneType: " + this.toneType));
                        }
                        tg.stopTone();
                    }
                    this.isMediaPlaying = false;
                    tg.release();
                    var5_7 = Unit.INSTANCE;
                }
            }
            Log.d((String)"InCallManager", (String)("MyToneGenerator(): play finished. caller=" + this.caller));
            if (Intrinsics.areEqual((Object)this.caller, (Object)"mBusytone")) {
                Log.d((String)"InCallManager", (String)"MyToneGenerator(): invoke stop()");
                InCallManagerModule.stop$default(InCallManagerModule.this, null, 1, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u000bH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule$DyteMediaPlayer;", "Landroid/media/MediaPlayer;", "Lio/dyte/core/incallmanager/InCallManagerModule$MyPlayerInterface;", "(Lio/dyte/core/incallmanager/InCallManagerModule;)V", "<set-?>", "", "isMediaPlaying", "()Z", "startPlay", "", "data", "", "", "", "stopPlay", "shared_debug"})
    private final class DyteMediaPlayer
    extends MediaPlayer
    implements MyPlayerInterface {
        private boolean isMediaPlaying;

        @Override
        public boolean isMediaPlaying() {
            return this.isMediaPlaying;
        }

        @Override
        public void stopPlay() {
            this.stop();
            this.reset();
            this.release();
        }

        @Override
        public void startPlay(@Nullable Map<String, ? extends Object> data) {
            try {
                Activity activity = InCallManagerModule.this.activity;
                Intrinsics.checkNotNull((Object)activity);
                Context context = (Context)activity;
                Map<String, ? extends Object> map = data;
                Uri uri = (Uri)(map != null ? map.get("sourceUri") : null);
                Intrinsics.checkNotNull((Object)uri);
                this.setDataSource(context, uri);
                Map<String, ? extends Object> map2 = data;
                Boolean bl = (Boolean)(map2 != null ? map2.get("setLooping") : null);
                Intrinsics.checkNotNull((Object)bl);
                this.setLooping(bl);
                AudioAttributes.Builder builder = new AudioAttributes.Builder();
                Map<String, ? extends Object> map3 = data;
                Integer n = (Integer)(map3 != null ? map3.get("audioUsage") : null);
                Intrinsics.checkNotNull((Object)n);
                AudioAttributes.Builder builder2 = builder.setUsage(n.intValue());
                Map<String, ? extends Object> map4 = data;
                Integer n2 = (Integer)(map4 != null ? map4.get("audioContentType") : null);
                Intrinsics.checkNotNull((Object)n2);
                this.setAudioAttributes(builder2.setContentType(n2.intValue()).build());
                this.prepareAsync();
            }
            catch (Exception e) {
                Log.d((String)"InCallManager", (String)"startPlay() failed", (Throwable)e);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/dyte/core/incallmanager/InCallManagerModule$Companion;", "", "()V", "ACTION_HEADSET_PLUG", "", "REACT_NATIVE_MODULE_NAME", "SPEAKERPHONE_AUTO", "TAG", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AudioDevice.values().length];
            try {
                nArray[AudioDevice.SPEAKER_PHONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioDevice.EARPIECE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioDevice.WIRED_HEADSET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioDevice.BLUETOOTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

