/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.incallmanager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import io.dyte.core.incallmanager.InCallManagerModule;
import io.dyte.core.incallmanager.apprtc.AppRTCProximitySensor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/dyte/core/incallmanager/InCallProximityManager;", "", "context", "Landroid/content/Context;", "inCallManager", "Lio/dyte/core/incallmanager/InCallManagerModule;", "(Landroid/content/Context;Lio/dyte/core/incallmanager/InCallManagerModule;)V", "<set-?>", "", "isProximitySupported", "()Z", "isProximityWakeLockSupported", "mPowerManagerRelease", "Ljava/lang/reflect/Method;", "mProximityLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "proximityIsNear", "getProximityIsNear", "proximitySensor", "Lio/dyte/core/incallmanager/apprtc/AppRTCProximitySensor;", "acquireProximityWakeLock", "", "checkProximitySupport", "releaseProximityWakeLock", "waitForNoProximity", "start", "stop", "Companion", "shared_debug"})
public final class InCallProximityManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PowerManager.WakeLock mProximityLock;
    @Nullable
    private Method mPowerManagerRelease;
    private boolean isProximitySupported;
    @Nullable
    private AppRTCProximitySensor proximitySensor;
    @NotNull
    private static final String TAG = "InCallProximityManager";

    private InCallProximityManager(Context context, InCallManagerModule inCallManager) {
        Log.d((String)TAG, (String)TAG);
        this.checkProximitySupport(context);
        if (this.isProximitySupported) {
            this.proximitySensor = AppRTCProximitySensor.Companion.create(context, () -> InCallProximityManager._init_$lambda$2(inCallManager, this));
        }
    }

    public final boolean isProximitySupported() {
        return this.isProximitySupported;
    }

    @SuppressLint(value={"InvalidWakeLockTag"})
    private final void checkProximitySupport(Context context) {
        Object object = context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        SensorManager sensorManager = (SensorManager)object;
        if (sensorManager.getDefaultSensor(8) == null) {
            this.isProximitySupported = false;
            return;
        }
        Object object2 = context.getSystemService("power");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager powerManager = (PowerManager)object2;
        this.isProximitySupported = true;
        try {
            boolean proximitySupported;
            boolean bl;
            Method method;
            Field field = PowerManager.class.getDeclaredField("PROXIMITY_SCREEN_OFF_WAKE_LOCK");
            Object object3 = field.get(null);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
            int proximityScreenOffWakeLock = (Integer)object3;
            if (Build.VERSION.SDK_INT < 17) {
                method = powerManager.getClass().getDeclaredMethod("getSupportedWakeLockFlags", new Class[0]);
                Object object4 = method.invoke((Object)powerManager, new Object[0]);
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
                int powerManagerSupportedFlags = (Integer)object4;
                bl = (powerManagerSupportedFlags & proximityScreenOffWakeLock) != 0;
            } else {
                Class[] classArray = new Class[]{Integer.TYPE};
                method = powerManager.getClass().getDeclaredMethod("isWakeLockLevelSupported", classArray);
                Object[] objectArray = new Object[]{proximityScreenOffWakeLock};
                Object object5 = method.invoke((Object)powerManager, objectArray);
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Boolean");
                bl = proximitySupported = ((Boolean)object5).booleanValue();
            }
            if (proximitySupported) {
                PowerManager.WakeLock wakeLock = this.mProximityLock = powerManager.newWakeLock(proximityScreenOffWakeLock, TAG);
                Intrinsics.checkNotNull((Object)wakeLock);
                wakeLock.setReferenceCounted(false);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Failed to get proximity screen locker. exception: ", (Throwable)e);
        }
        if (this.mProximityLock != null) {
            Log.d((String)TAG, (String)"use native screen locker...");
            try {
                PowerManager.WakeLock wakeLock = this.mProximityLock;
                Intrinsics.checkNotNull((Object)wakeLock);
                Class[] e = new Class[]{Integer.TYPE};
                this.mPowerManagerRelease = wakeLock.getClass().getDeclaredMethod("release", e);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"failed to get proximity screen locker: `release()`. exception: ", (Throwable)e);
            }
        } else {
            Log.d((String)TAG, (String)"fallback to old school screen locker...");
        }
    }

    public final boolean start() {
        if (!this.isProximitySupported) {
            return false;
        }
        AppRTCProximitySensor appRTCProximitySensor = this.proximitySensor;
        Intrinsics.checkNotNull((Object)appRTCProximitySensor);
        appRTCProximitySensor.start();
        return true;
    }

    public final void stop() {
        AppRTCProximitySensor appRTCProximitySensor = this.proximitySensor;
        Intrinsics.checkNotNull((Object)appRTCProximitySensor);
        appRTCProximitySensor.stop();
    }

    public final boolean isProximityWakeLockSupported() {
        return this.mProximityLock != null;
    }

    public final boolean getProximityIsNear() {
        boolean bl;
        if (this.isProximitySupported) {
            AppRTCProximitySensor appRTCProximitySensor = this.proximitySensor;
            Intrinsics.checkNotNull((Object)appRTCProximitySensor);
            bl = appRTCProximitySensor.sensorReportsNearState();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acquireProximityWakeLock() {
        if (!this.isProximityWakeLockSupported()) {
            return;
        }
        PowerManager.WakeLock wakeLock = this.mProximityLock;
        Intrinsics.checkNotNull((Object)wakeLock);
        PowerManager.WakeLock wakeLock2 = wakeLock;
        synchronized (wakeLock2) {
            boolean bl = false;
            PowerManager.WakeLock wakeLock3 = this.mProximityLock;
            Intrinsics.checkNotNull((Object)wakeLock3);
            if (!wakeLock3.isHeld()) {
                Log.d((String)TAG, (String)"acquireProximityWakeLock()");
                PowerManager.WakeLock wakeLock4 = this.mProximityLock;
                Intrinsics.checkNotNull((Object)wakeLock4);
                wakeLock4.acquire();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseProximityWakeLock(boolean waitForNoProximity) {
        if (!this.isProximityWakeLockSupported()) {
            return;
        }
        PowerManager.WakeLock wakeLock = this.mProximityLock;
        Intrinsics.checkNotNull((Object)wakeLock);
        PowerManager.WakeLock wakeLock2 = wakeLock;
        synchronized (wakeLock2) {
            boolean bl = false;
            PowerManager.WakeLock wakeLock3 = this.mProximityLock;
            Intrinsics.checkNotNull((Object)wakeLock3);
            if (wakeLock3.isHeld()) {
                try {
                    int flags = waitForNoProximity ? 1 : 0;
                    Method method = this.mPowerManagerRelease;
                    Intrinsics.checkNotNull((Object)method);
                    Object[] objectArray = new Object[]{flags};
                    method.invoke((Object)this.mProximityLock, objectArray);
                    Log.d((String)TAG, (String)"releaseProximityWakeLock()");
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"failed to release proximity lock. e: ", (Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void _init_$lambda$2(InCallManagerModule $inCallManager, InCallProximityManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$inCallManager, (String)"$inCallManager");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AppRTCProximitySensor appRTCProximitySensor = this$0.proximitySensor;
        Intrinsics.checkNotNull((Object)appRTCProximitySensor);
        $inCallManager.onProximitySensorChangedState(appRTCProximitySensor.sensorReportsNearState());
    }

    public /* synthetic */ InCallProximityManager(Context context, InCallManagerModule inCallManager, DefaultConstructorMarker $constructor_marker) {
        this(context, inCallManager);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/dyte/core/incallmanager/InCallProximityManager$Companion;", "", "()V", "TAG", "", "create", "Lio/dyte/core/incallmanager/InCallProximityManager;", "context", "Landroid/content/Context;", "inCallManager", "Lio/dyte/core/incallmanager/InCallManagerModule;", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InCallProximityManager create(@NotNull Context context, @NotNull InCallManagerModule inCallManager) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)inCallManager, (String)"inCallManager");
            return new InCallProximityManager(context, inCallManager, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

