/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.incallmanager.apprtc;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import io.dyte.core.incallmanager.InCallManagerModule;
import io.dyte.core.incallmanager.apprtc.util.AppRTCUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.ThreadUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 @2\u00020\u0001:\u0004>?@AB\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010&\u001a\u00020'H\u0003J\b\u0010(\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010*\u001a\u00020\u001b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010+\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010,\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0010\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\u000bH\u0005J\u001c\u00101\u001a\u00020'2\b\u00102\u001a\u0004\u0018\u00010\u00112\b\u00103\u001a\u0004\u0018\u000104H\u0002J\b\u00105\u001a\u00020'H\u0007J\u0006\u00106\u001a\u00020\u001bJ\b\u00107\u001a\u00020'H\u0002J\u0010\u00108\u001a\u00020.2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0006\u00109\u001a\u00020'J\u0006\u0010:\u001a\u00020'J\u0012\u0010;\u001a\u00020'2\b\u00102\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010<\u001a\u00020'H\u0002J\b\u0010=\u001a\u00020'H\u0007R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006B"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager;", "", "context", "Landroid/content/Context;", "audioManager", "Lio/dyte/core/incallmanager/InCallManagerModule;", "(Landroid/content/Context;Lio/dyte/core/incallmanager/InCallManagerModule;)V", "apprtcAudioManager", "apprtcContext", "Landroid/media/AudioManager;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "bluetoothHeadset", "Landroid/bluetooth/BluetoothHeadset;", "bluetoothHeadsetReceiver", "Landroid/content/BroadcastReceiver;", "bluetoothServiceListener", "Landroid/bluetooth/BluetoothProfile$ServiceListener;", "bluetoothState", "Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager$State;", "bluetoothTimeoutRunnable", "Ljava/lang/Runnable;", "handler", "Landroid/os/Handler;", "isScoOn", "", "()Z", "scoConnectionAttempts", "", "getScoConnectionAttempts", "()I", "setScoConnectionAttempts", "(I)V", "state", "getState", "()Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager$State;", "bluetoothTimeout", "", "cancelTimer", "getAudioManager", "getBluetoothProfileProxy", "listener", "hasPermission", "permission", "", "logBluetoothAdapterInfo", "localAdapter", "registerReceiver", "receiver", "filter", "Landroid/content/IntentFilter;", "start", "startScoAudio", "startTimer", "stateToString", "stop", "stopScoAudio", "unregisterReceiver", "updateAudioDeviceState", "updateDevice", "BluetoothHeadsetBroadcastReceiver", "BluetoothServiceListener", "Companion", "State", "shared_debug"})
public class AppRTCBluetoothManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context apprtcContext;
    @NotNull
    private final InCallManagerModule apprtcAudioManager;
    @Nullable
    private final AudioManager audioManager;
    @NotNull
    private final Handler handler;
    private int scoConnectionAttempts;
    @NotNull
    private State bluetoothState;
    @NotNull
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    @Nullable
    private BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothHeadset bluetoothHeadset;
    @Nullable
    private BluetoothDevice bluetoothDevice;
    @NotNull
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    @NotNull
    private final Runnable bluetoothTimeoutRunnable;
    @NotNull
    private static final String TAG = "AppRTCBluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 2;

    protected AppRTCBluetoothManager(@NotNull Context context, @NotNull InCallManagerModule audioManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        this.bluetoothTimeoutRunnable = () -> AppRTCBluetoothManager.bluetoothTimeoutRunnable$lambda$0(this);
        Log.d((String)TAG, (String)"ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.apprtcAudioManager = audioManager;
        this.audioManager = this.getAudioManager(context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public final int getScoConnectionAttempts() {
        return this.scoConnectionAttempts;
    }

    public final void setScoConnectionAttempts(int n) {
        this.scoConnectionAttempts = n;
    }

    @NotNull
    public final State getState() {
        ThreadUtils.checkIsOnMainThread();
        return this.bluetoothState;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void start() {
        String p;
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"start");
        String string = p = Build.VERSION.SDK_INT >= 31 ? "android.permission.BLUETOOTH_CONNECT" : "android.permission.BLUETOOTH";
        if (!this.hasPermission(p)) {
            Log.w((String)TAG, (String)("Process (pid=" + Process.myPid() + ") lacks BLUETOOTH permission"));
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            Log.w((String)TAG, (String)"Invalid BT state");
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        Object object = this.apprtcContext.getSystemService("bluetooth");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        this.bluetoothAdapter = ((BluetoothManager)object).getAdapter();
        if (this.bluetoothAdapter == null) {
            Log.w((String)TAG, (String)"Device does not support Bluetooth");
            return;
        }
        AudioManager audioManager = this.audioManager;
        Intrinsics.checkNotNull((Object)audioManager);
        if (!audioManager.isBluetoothScoAvailableOffCall()) {
            Log.e((String)TAG, (String)"Bluetooth SCO audio is not available off call");
            return;
        }
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        Intrinsics.checkNotNull((Object)bluetoothAdapter);
        this.logBluetoothAdapterInfo(bluetoothAdapter);
        if (!this.getBluetoothProfileProxy(this.apprtcContext, this.bluetoothServiceListener)) {
            Log.e((String)TAG, (String)"BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        StringBuilder stringBuilder = new StringBuilder().append("HEADSET profile state: ");
        BluetoothAdapter bluetoothAdapter2 = this.bluetoothAdapter;
        Intrinsics.checkNotNull((Object)bluetoothAdapter2);
        Log.d((String)TAG, (String)stringBuilder.append(this.stateToString(bluetoothAdapter2.getProfileConnectionState(1))).toString());
        Log.d((String)TAG, (String)"Bluetooth proxy for headset profile has started");
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
        Log.d((String)TAG, (String)("start done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    public final void stop() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("stop: BT state=" + (Object)((Object)this.bluetoothState)));
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        if (this.bluetoothHeadset != null) {
            BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
            Intrinsics.checkNotNull((Object)bluetoothAdapter);
            bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
        Log.d((String)TAG, (String)("stop done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    public final boolean startScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("startSco: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn()));
        if (this.scoConnectionAttempts >= 2) {
            Log.e((String)TAG, (String)"BT SCO connection fails - no more attempts");
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            Log.e((String)TAG, (String)"BT SCO connection fails - no headset available");
            return false;
        }
        Log.d((String)TAG, (String)"Starting Bluetooth SCO and waits for ACTION_AUDIO_STATE_CHANGED...");
        this.bluetoothState = State.SCO_CONNECTING;
        AudioManager audioManager = this.audioManager;
        Intrinsics.checkNotNull((Object)audioManager);
        audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        int n = this.scoConnectionAttempts;
        this.scoConnectionAttempts = n + 1;
        this.startTimer();
        Log.d((String)TAG, (String)("startScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
        return true;
    }

    public final void stopScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("stopScoAudio: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        AudioManager audioManager = this.audioManager;
        Intrinsics.checkNotNull((Object)audioManager);
        audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
        Log.d((String)TAG, (String)("stopScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
    }

    @SuppressLint(value={"MissingPermission"})
    public final void updateDevice() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d((String)TAG, (String)"updateDevice");
        BluetoothHeadset bluetoothHeadset = this.bluetoothHeadset;
        Intrinsics.checkNotNull((Object)bluetoothHeadset);
        List devices = bluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.bluetoothDevice = null;
            this.bluetoothState = State.HEADSET_UNAVAILABLE;
            Log.d((String)TAG, (String)"No connected bluetooth headset");
        } else {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            this.bluetoothState = State.HEADSET_AVAILABLE;
            StringBuilder stringBuilder = new StringBuilder().append("Connected bluetooth headset: name=");
            BluetoothDevice bluetoothDevice = this.bluetoothDevice;
            Intrinsics.checkNotNull((Object)bluetoothDevice);
            StringBuilder stringBuilder2 = stringBuilder.append(bluetoothDevice.getName()).append(", state=");
            BluetoothHeadset bluetoothHeadset2 = this.bluetoothHeadset;
            Intrinsics.checkNotNull((Object)bluetoothHeadset2);
            StringBuilder stringBuilder3 = stringBuilder2.append(this.stateToString(bluetoothHeadset2.getConnectionState(this.bluetoothDevice))).append(", SCO audio=");
            BluetoothHeadset bluetoothHeadset3 = this.bluetoothHeadset;
            Intrinsics.checkNotNull((Object)bluetoothHeadset3);
            Log.d((String)TAG, (String)stringBuilder3.append(bluetoothHeadset3.isAudioConnected(this.bluetoothDevice)).toString());
        }
        Log.d((String)TAG, (String)("updateDevice done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    private final AudioManager getAudioManager(Context context) {
        Object object = context.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        return (AudioManager)object;
    }

    private final void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private final void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private final boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener) {
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        Intrinsics.checkNotNull((Object)bluetoothAdapter);
        return bluetoothAdapter.getProfileProxy(context, listener, 1);
    }

    private final boolean hasPermission(String permission) {
        String string = permission;
        Intrinsics.checkNotNull((Object)string);
        return this.apprtcContext.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    protected final void logBluetoothAdapterInfo(@NotNull BluetoothAdapter localAdapter) {
        Intrinsics.checkNotNullParameter((Object)localAdapter, (String)"localAdapter");
        Log.d((String)TAG, (String)("BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.stateToString(localAdapter.getState()) + ", name=" + localAdapter.getName() + ", address=" + localAdapter.getAddress()));
        Set pairedDevices = localAdapter.getBondedDevices();
        Intrinsics.checkNotNullExpressionValue((Object)pairedDevices, (String)"pairedDevices");
        if (!((Collection)pairedDevices).isEmpty()) {
            Log.d((String)TAG, (String)"paired devices:");
            for (BluetoothDevice device : pairedDevices) {
                Log.d((String)TAG, (String)(" name=" + device.getName() + ", address=" + device.getAddress()));
            }
        }
    }

    private final void updateAudioDeviceState() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"updateAudioDeviceState");
        this.apprtcAudioManager.updateAudioDeviceState();
    }

    private final void startTimer() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"startTimer");
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private final void cancelTimer() {
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)"cancelTimer");
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    private final void bluetoothTimeout() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d((String)TAG, (String)("bluetoothTimeout: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn()));
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        BluetoothHeadset bluetoothHeadset = this.bluetoothHeadset;
        Intrinsics.checkNotNull((Object)bluetoothHeadset);
        List devices = bluetoothHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            BluetoothHeadset bluetoothHeadset2 = this.bluetoothHeadset;
            Intrinsics.checkNotNull((Object)bluetoothHeadset2);
            if (bluetoothHeadset2.isAudioConnected(this.bluetoothDevice)) {
                StringBuilder stringBuilder = new StringBuilder().append("SCO connected with ");
                BluetoothDevice bluetoothDevice = this.bluetoothDevice;
                Intrinsics.checkNotNull((Object)bluetoothDevice);
                Log.d((String)TAG, (String)stringBuilder.append(bluetoothDevice.getName()).toString());
                scoConnected = true;
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("SCO is not connected with ");
                BluetoothDevice bluetoothDevice = this.bluetoothDevice;
                Intrinsics.checkNotNull((Object)bluetoothDevice);
                Log.d((String)TAG, (String)stringBuilder.append(bluetoothDevice.getName()).toString());
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            Log.w((String)TAG, (String)"BT failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
        Log.d((String)TAG, (String)("bluetoothTimeout done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    private final boolean isScoOn() {
        AudioManager audioManager = this.audioManager;
        Intrinsics.checkNotNull((Object)audioManager);
        return audioManager.isBluetoothScoOn();
    }

    private final String stateToString(int state) {
        String string;
        switch (state) {
            case 0: {
                string = "DISCONNECTED";
                break;
            }
            case 2: {
                string = "CONNECTED";
                break;
            }
            case 1: {
                string = "CONNECTING";
                break;
            }
            case 3: {
                string = "DISCONNECTING";
                break;
            }
            case 10: {
                string = "OFF";
                break;
            }
            case 12: {
                string = "ON";
                break;
            }
            case 13: {
                string = "TURNING_OFF";
                break;
            }
            case 11: {
                string = "TURNING_ON";
                break;
            }
            default: {
                string = "INVALID";
            }
        }
        return string;
    }

    private static final void bluetoothTimeoutRunnable$lambda$0(AppRTCBluetoothManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.bluetoothTimeout();
    }

    @JvmStatic
    @NotNull
    public static final AppRTCBluetoothManager create(@NotNull Context context, @NotNull InCallManagerModule audioManager) {
        return Companion.create(context, audioManager);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager$State;", "", "(Ljava/lang/String;I)V", "UNINITIALIZED", "ERROR", "HEADSET_UNAVAILABLE", "HEADSET_AVAILABLE", "SCO_DISCONNECTING", "SCO_CONNECTING", "SCO_CONNECTED", "shared_debug"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State UNINITIALIZED = new State();
        public static final /* enum */ State ERROR = new State();
        public static final /* enum */ State HEADSET_UNAVAILABLE = new State();
        public static final /* enum */ State HEADSET_AVAILABLE = new State();
        public static final /* enum */ State SCO_DISCONNECTING = new State();
        public static final /* enum */ State SCO_CONNECTING = new State();
        public static final /* enum */ State SCO_CONNECTED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.UNINITIALIZED, State.ERROR, State.HEADSET_UNAVAILABLE, State.HEADSET_AVAILABLE, State.SCO_DISCONNECTING, State.SCO_CONNECTING, State.SCO_CONNECTED};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager$BluetoothServiceListener;", "Landroid/bluetooth/BluetoothProfile$ServiceListener;", "(Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager;)V", "onServiceConnected", "", "profile", "", "proxy", "Landroid/bluetooth/BluetoothProfile;", "onServiceDisconnected", "shared_debug"})
    private final class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        public void onServiceConnected(int profile, @NotNull BluetoothProfile proxy) {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            Log.d((String)AppRTCBluetoothManager.TAG, (String)("BluetoothServiceListener.onServiceConnected: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
            AppRTCBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
            Log.d((String)AppRTCBluetoothManager.TAG, (String)("onServiceConnected done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            Log.d((String)AppRTCBluetoothManager.TAG, (String)("BluetoothServiceListener.onServiceDisconnected: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
            AppRTCBluetoothManager.this.stopScoAudio();
            AppRTCBluetoothManager.this.bluetoothHeadset = null;
            AppRTCBluetoothManager.this.bluetoothDevice = null;
            AppRTCBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            AppRTCBluetoothManager.this.updateAudioDeviceState();
            Log.d((String)AppRTCBluetoothManager.TAG, (String)("onServiceDisconnected done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager$BluetoothHeadsetBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "(Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "shared_debug"})
    private final class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (Intrinsics.areEqual((Object)action, (Object)"android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                Log.d((String)AppRTCBluetoothManager.TAG, (String)("BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + AppRTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
                switch (state) {
                    case 2: {
                        AppRTCBluetoothManager.this.setScoConnectionAttempts(0);
                        AppRTCBluetoothManager.this.updateAudioDeviceState();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 0: {
                        AppRTCBluetoothManager.this.stopScoAudio();
                        AppRTCBluetoothManager.this.updateAudioDeviceState();
                    }
                }
            } else if (Intrinsics.areEqual((Object)action, (Object)"android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                Log.d((String)AppRTCBluetoothManager.TAG, (String)("BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + AppRTCBluetoothManager.this.stateToString(state) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
                switch (state) {
                    case 12: {
                        AppRTCBluetoothManager.this.cancelTimer();
                        if (AppRTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                            Log.d((String)AppRTCBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now connected");
                            AppRTCBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                            AppRTCBluetoothManager.this.setScoConnectionAttempts(0);
                            AppRTCBluetoothManager.this.updateAudioDeviceState();
                            break;
                        }
                        Log.w((String)AppRTCBluetoothManager.TAG, (String)"Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                        break;
                    }
                    case 11: {
                        Log.d((String)AppRTCBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now connecting...");
                        break;
                    }
                    case 10: {
                        Log.d((String)AppRTCBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now disconnected");
                        if (this.isInitialStickyBroadcast()) {
                            Log.d((String)AppRTCBluetoothManager.TAG, (String)"Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                            return;
                        }
                        AppRTCBluetoothManager.this.updateAudioDeviceState();
                    }
                }
            }
            Log.d((String)AppRTCBluetoothManager.TAG, (String)("onReceive done: BT state=" + (Object)((Object)AppRTCBluetoothManager.this.bluetoothState)));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager$Companion;", "", "()V", "BLUETOOTH_SCO_TIMEOUT_MS", "", "MAX_SCO_CONNECTION_ATTEMPTS", "TAG", "", "create", "Lio/dyte/core/incallmanager/apprtc/AppRTCBluetoothManager;", "context", "Landroid/content/Context;", "audioManager", "Lio/dyte/core/incallmanager/InCallManagerModule;", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AppRTCBluetoothManager create(@NotNull Context context, @NotNull InCallManagerModule audioManager) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
            Log.d((String)AppRTCBluetoothManager.TAG, (String)("create" + AppRTCUtils.getThreadInfo()));
            return new AppRTCBluetoothManager(context, audioManager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

