/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.incallmanager.apprtc;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import io.dyte.core.incallmanager.apprtc.util.AppRTCUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.ThreadUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCProximitySensor;", "Landroid/hardware/SensorEventListener;", "context", "Landroid/content/Context;", "sensorStateListener", "Ljava/lang/Runnable;", "(Landroid/content/Context;Ljava/lang/Runnable;)V", "lastStateReportIsNear", "", "onSensorStateListener", "proximitySensor", "Landroid/hardware/Sensor;", "sensorManager", "Landroid/hardware/SensorManager;", "threadChecker", "Lorg/webrtc/ThreadUtils$ThreadChecker;", "initDefaultSensor", "logProximitySensorInfo", "", "onAccuracyChanged", "sensor", "accuracy", "", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "sensorReportsNearState", "start", "stop", "Companion", "shared_debug"})
public final class AppRTCProximitySensor
implements SensorEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    @Nullable
    private final Runnable onSensorStateListener;
    @NotNull
    private final SensorManager sensorManager;
    @Nullable
    private Sensor proximitySensor;
    private boolean lastStateReportIsNear;
    @NotNull
    private static final String TAG = "AppRTCProximitySensor";

    private AppRTCProximitySensor(Context context, Runnable sensorStateListener) {
        Log.d((String)TAG, (String)(TAG + AppRTCUtils.getThreadInfo()));
        this.onSensorStateListener = sensorStateListener;
        Object object = context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        this.sensorManager = (SensorManager)object;
    }

    public final boolean start() {
        this.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)("start" + AppRTCUtils.getThreadInfo()));
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public final void stop() {
        this.threadChecker.checkIsOnValidThread();
        Log.d((String)TAG, (String)("stop" + AppRTCUtils.getThreadInfo()));
        if (this.proximitySensor == null) {
            return;
        }
        this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
    }

    public final boolean sensorReportsNearState() {
        this.threadChecker.checkIsOnValidThread();
        return this.lastStateReportIsNear;
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
        this.threadChecker.checkIsOnValidThread();
        AppRTCUtils.assertIsTrue(sensor.getType() == 8);
        if (accuracy == 0) {
            Log.e((String)TAG, (String)"The values returned by this sensor cannot be trusted");
        }
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.threadChecker.checkIsOnValidThread();
            AppRTCUtils.assertIsTrue(event.sensor.getType() == 8);
            float distanceInCentimeters = event.values[0];
            Sensor sensor = this.proximitySensor;
            Intrinsics.checkNotNull((Object)sensor);
            this.lastStateReportIsNear = distanceInCentimeters < sensor.getMaximumRange();
            Runnable runnable = this.onSensorStateListener;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private final boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.logProximitySensorInfo();
        return true;
    }

    private final void logProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder info = new StringBuilder("Proximity sensor: ");
        StringBuilder stringBuilder = info.append("name=");
        Sensor sensor = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor);
        stringBuilder.append(sensor.getName());
        StringBuilder stringBuilder2 = info.append(", vendor: ");
        Sensor sensor2 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor2);
        stringBuilder2.append(sensor2.getVendor());
        StringBuilder stringBuilder3 = info.append(", power: ");
        Sensor sensor3 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor3);
        stringBuilder3.append(sensor3.getPower());
        StringBuilder stringBuilder4 = info.append(", resolution: ");
        Sensor sensor4 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor4);
        stringBuilder4.append(sensor4.getResolution());
        StringBuilder stringBuilder5 = info.append(", max range: ");
        Sensor sensor5 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor5);
        stringBuilder5.append(sensor5.getMaximumRange());
        StringBuilder stringBuilder6 = info.append(", min delay: ");
        Sensor sensor6 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor6);
        stringBuilder6.append(sensor6.getMinDelay());
        StringBuilder stringBuilder7 = info.append(", type: ");
        Sensor sensor7 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor7);
        stringBuilder7.append(sensor7.getStringType());
        StringBuilder stringBuilder8 = info.append(", max delay: ");
        Sensor sensor8 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor8);
        stringBuilder8.append(sensor8.getMaxDelay());
        StringBuilder stringBuilder9 = info.append(", reporting mode: ");
        Sensor sensor9 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor9);
        stringBuilder9.append(sensor9.getReportingMode());
        StringBuilder stringBuilder10 = info.append(", isWakeUpSensor: ");
        Sensor sensor10 = this.proximitySensor;
        Intrinsics.checkNotNull((Object)sensor10);
        stringBuilder10.append(sensor10.isWakeUpSensor());
        Log.d((String)TAG, (String)info.toString());
    }

    @JvmStatic
    @NotNull
    public static final AppRTCProximitySensor create(@NotNull Context context, @NotNull Runnable sensorStateListener) {
        return Companion.create(context, sensorStateListener);
    }

    public /* synthetic */ AppRTCProximitySensor(Context context, Runnable sensorStateListener, DefaultConstructorMarker $constructor_marker) {
        this(context, sensorStateListener);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/dyte/core/incallmanager/apprtc/AppRTCProximitySensor$Companion;", "", "()V", "TAG", "", "create", "Lio/dyte/core/incallmanager/apprtc/AppRTCProximitySensor;", "context", "Landroid/content/Context;", "sensorStateListener", "Ljava/lang/Runnable;", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AppRTCProximitySensor create(@NotNull Context context, @NotNull Runnable sensorStateListener) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)sensorStateListener, (String)"sensorStateListener");
            return new AppRTCProximitySensor(context, sensorStateListener, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

