/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.network.info;

import io.dyte.core.network.info.VideoPermissions;
import io.dyte.core.network.models.ParticipantPreset;
import io.dyte.core.network.models.UserPresetData;
import io.dyte.core.network.models.UserPresetDataWrapper;
import io.dyte.core.network.models.UserPresetModel;
import io.dyte.core.network.models.UserPresetPermissionsModel;
import io.dyte.core.network.models.UserPresetProducePermissions;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010\u0013J\t\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/dyte/core/network/info/MediaPermissions;", "", "video", "Lio/dyte/core/network/info/VideoPermissions;", "canPublishAudio", "", "(Lio/dyte/core/network/info/VideoPermissions;Z)V", "getCanPublishAudio", "()Z", "canPublishVideo", "getCanPublishVideo", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toMap", "", "", "toString", "Companion", "shared_debug"})
public final class MediaPermissions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VideoPermissions video;
    private final boolean canPublishAudio;
    private final boolean canPublishVideo;

    public MediaPermissions(@NotNull VideoPermissions video, boolean canPublishAudio) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        this.video = video;
        this.canPublishAudio = canPublishAudio;
        this.canPublishVideo = this.video.getCanPublish();
    }

    public final boolean getCanPublishAudio() {
        return this.canPublishAudio;
    }

    public final boolean getCanPublishVideo() {
        return this.canPublishVideo;
    }

    @NotNull
    public final Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"canPublishAudio", (Object)this.canPublishAudio), TuplesKt.to((Object)"canPublishVideo", (Object)this.canPublishVideo)};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    private final VideoPermissions component1() {
        return this.video;
    }

    public final boolean component2() {
        return this.canPublishAudio;
    }

    @NotNull
    public final MediaPermissions copy(@NotNull VideoPermissions video, boolean canPublishAudio) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        return new MediaPermissions(video, canPublishAudio);
    }

    public static /* synthetic */ MediaPermissions copy$default(MediaPermissions mediaPermissions, VideoPermissions videoPermissions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            videoPermissions = mediaPermissions.video;
        }
        if ((n & 2) != 0) {
            bl = mediaPermissions.canPublishAudio;
        }
        return mediaPermissions.copy(videoPermissions, bl);
    }

    @NotNull
    public String toString() {
        return "MediaPermissions(video=" + this.video + ", canPublishAudio=" + this.canPublishAudio + ')';
    }

    public int hashCode() {
        int result2 = this.video.hashCode();
        int n = this.canPublishAudio ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaPermissions)) {
            return false;
        }
        MediaPermissions mediaPermissions = (MediaPermissions)other;
        if (!Intrinsics.areEqual((Object)this.video, (Object)mediaPermissions.video)) {
            return false;
        }
        return this.canPublishAudio == mediaPermissions.canPublishAudio;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/dyte/core/network/info/MediaPermissions$Companion;", "", "()V", "getMediaPermissionsFromV1", "Lio/dyte/core/network/info/MediaPermissions;", "userPresetData", "Lio/dyte/core/network/models/UserPresetDataWrapper;", "getMediaPermissionsFromV2", "participantPreset", "Lio/dyte/core/network/models/ParticipantPreset;", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaPermissions getMediaPermissionsFromV1(@NotNull UserPresetDataWrapper userPresetData) {
            Intrinsics.checkNotNullParameter((Object)userPresetData, (String)"userPresetData");
            Object object = userPresetData.getData();
            if (object != null && (object = ((UserPresetData)object).getPreset()) != null && (object = ((UserPresetModel)object).getPermissions()) != null) {
                Object object2;
                Object permissions = object;
                boolean bl = false;
                return new MediaPermissions(VideoPermissions.Companion.getVideoPermissionsFromV1(userPresetData), (object2 = ((UserPresetPermissionsModel)permissions).getProduce()) != null && (object2 = ((UserPresetProducePermissions)object2).getAudio()) != null ? (Boolean)object2 : false);
            }
            Companion $this$getMediaPermissionsFromV1_u24lambda_u241 = this;
            boolean bl = false;
            throw new IllegalArgumentException("not sufficient data to build media permissions from v1 api");
        }

        @NotNull
        public final MediaPermissions getMediaPermissionsFromV2(@NotNull ParticipantPreset participantPreset) {
            Intrinsics.checkNotNullParameter((Object)participantPreset, (String)"participantPreset");
            return new MediaPermissions(VideoPermissions.Companion.getVideoPermissionsFromV2(participantPreset), Intrinsics.areEqual((Object)participantPreset.getPermissions().getMedia().getAudio().getCanProduce(), (Object)"ALLOWED"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

