/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.platform;

import android.util.Log;
import io.dyte.core.platform.IDyteLoggerUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/dyte/core/platform/DyteAndroidLogger;", "Lio/dyte/core/platform/IDyteLoggerUtils;", "()V", "isLogEnabled", "", "enableLogger", "", "enable", "getStackString", "", "t", "", "getTag", "tag", "", "isLoggerEnabled", "logD", "message", "logE", "throwable", "logI", "logW", "shared_debug"})
public final class DyteAndroidLogger
implements IDyteLoggerUtils {
    private boolean isLogEnabled;

    @Override
    public void enableLogger(boolean enable) {
        this.isLogEnabled = enable;
    }

    @Override
    public boolean isLoggerEnabled() {
        return this.isLogEnabled;
    }

    @Override
    public void logI(@NotNull Object tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.isLogEnabled) {
            Log.i((String)this.getTag(tag), (String)message);
        }
    }

    @Override
    public void logD(@NotNull Object tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.isLogEnabled) {
            Log.d((String)this.getTag(tag), (String)message);
        }
    }

    @Override
    public void logW(@NotNull Object tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.isLogEnabled) {
            Log.w((String)this.getTag(tag), (String)message);
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.isLogEnabled) {
            Log.e((String)this.getTag(tag), (String)message);
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.isLogEnabled) {
            Log.e((String)this.getTag(tag), (String)this.getStackString(throwable));
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.isLogEnabled) {
            Log.e((String)this.getTag(tag), (String)message, (Throwable)throwable);
        }
    }

    private final String getTag(Object tag) {
        String string;
        Object object = tag;
        if (object == null) {
            string = "null";
        } else if (object instanceof String) {
            string = (String)tag;
        } else {
            String string2 = tag.getClass().getSimpleName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag.javaClass.simpleName");
        }
        String stringTag = string;
        return "DyteSDK:" + stringTag;
    }

    private final String getStackString(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        String string = errors.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errors.toString()");
        return string;
    }
}

